/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.lb;

import com.sun.enterprise.admin.monitor.stats.lb.CommonBean;
import com.sun.enterprise.admin.monitor.stats.lb.InstanceStatsInterface;
import com.sun.enterprise.admin.monitor.stats.lb.LoadBalancerStats;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstanceStats
implements InstanceStatsInterface,
CommonBean {
    private String _Id;
    private String _Health;
    private String _NumTotalRequests;
    private String _NumActiveRequests;
    private List _ApplicationStats = new ArrayList();
    private String _ApplicationStatsId;
    private String _ApplicationStatsAverageResponseTime;
    private String _ApplicationStatsMinResponseTime;
    private String _ApplicationStatsMaxResponseTime;
    private String _ApplicationStatsNumFailoverRequests;
    private String _ApplicationStatsNumErrorRequests;
    private String _ApplicationStatsNumActiveRequests;
    private String _ApplicationStatsNumIdempotentUrlRequests;
    private String _ApplicationStatsNumTotalRequests;

    public InstanceStats() {
        this._Id = "";
        this._Health = "";
        this._NumTotalRequests = "";
        this._NumActiveRequests = "";
        this._ApplicationStatsId = "";
        this._ApplicationStatsAverageResponseTime = "";
        this._ApplicationStatsMinResponseTime = "";
        this._ApplicationStatsMaxResponseTime = "";
        this._ApplicationStatsNumFailoverRequests = "";
        this._ApplicationStatsNumErrorRequests = "";
        this._ApplicationStatsNumActiveRequests = "";
        this._ApplicationStatsNumIdempotentUrlRequests = "";
        this._ApplicationStatsNumTotalRequests = "";
    }

    public InstanceStats(InstanceStats source) {
        this._Id = source._Id;
        this._Health = source._Health;
        this._NumTotalRequests = source._NumTotalRequests;
        this._NumActiveRequests = source._NumActiveRequests;
        Iterator it = source._ApplicationStats.iterator();
        while (it.hasNext()) {
            this._ApplicationStats.add(it.next());
        }
        this._ApplicationStatsId = source._ApplicationStatsId;
        this._ApplicationStatsAverageResponseTime = source._ApplicationStatsAverageResponseTime;
        this._ApplicationStatsMinResponseTime = source._ApplicationStatsMinResponseTime;
        this._ApplicationStatsMaxResponseTime = source._ApplicationStatsMaxResponseTime;
        this._ApplicationStatsNumFailoverRequests = source._ApplicationStatsNumFailoverRequests;
        this._ApplicationStatsNumErrorRequests = source._ApplicationStatsNumErrorRequests;
        this._ApplicationStatsNumActiveRequests = source._ApplicationStatsNumActiveRequests;
        this._ApplicationStatsNumIdempotentUrlRequests = source._ApplicationStatsNumIdempotentUrlRequests;
        this._ApplicationStatsNumTotalRequests = source._ApplicationStatsNumTotalRequests;
    }

    public void setId(String value) {
        this._Id = value;
    }

    public String getId() {
        return this._Id;
    }

    public void setHealth(String value) {
        this._Health = value;
    }

    public String getHealth() {
        return this._Health;
    }

    public void setNumTotalRequests(String value) {
        this._NumTotalRequests = value;
    }

    public String getNumTotalRequests() {
        return this._NumTotalRequests;
    }

    public void setNumActiveRequests(String value) {
        this._NumActiveRequests = value;
    }

    public String getNumActiveRequests() {
        return this._NumActiveRequests;
    }

    public void setApplicationStats(boolean[] value) {
        if (value == null) {
            value = new boolean[]{};
        }
        this._ApplicationStats.clear();
        for (int i = 0; i < value.length; ++i) {
            this._ApplicationStats.add(value[i] ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setApplicationStats(int index, boolean value) {
        this._ApplicationStats.set(index, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean[] getApplicationStats() {
        boolean[] arr = new boolean[this._ApplicationStats.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Boolean)this._ApplicationStats.get(i);
        }
        return arr;
    }

    public List fetchApplicationStatsList() {
        return this._ApplicationStats;
    }

    public boolean isApplicationStats(int index) {
        return (Boolean)this._ApplicationStats.get(index);
    }

    public int sizeApplicationStats() {
        return this._ApplicationStats.size();
    }

    public int addApplicationStats(boolean value) {
        this._ApplicationStats.add(value ? Boolean.TRUE : Boolean.FALSE);
        return this._ApplicationStats.size() - 1;
    }

    public int removeApplicationStats(boolean value) {
        int pos = this._ApplicationStats.indexOf(value ? Boolean.TRUE : Boolean.FALSE);
        if (pos >= 0) {
            this._ApplicationStats.remove(pos);
        }
        return pos;
    }

    public void setApplicationStatsId(String value) {
        this._ApplicationStatsId = value;
    }

    public String getApplicationStatsId() {
        return this._ApplicationStatsId;
    }

    public void setApplicationStatsAverageResponseTime(String value) {
        this._ApplicationStatsAverageResponseTime = value;
    }

    public String getApplicationStatsAverageResponseTime() {
        return this._ApplicationStatsAverageResponseTime;
    }

    public void setApplicationStatsMinResponseTime(String value) {
        this._ApplicationStatsMinResponseTime = value;
    }

    public String getApplicationStatsMinResponseTime() {
        return this._ApplicationStatsMinResponseTime;
    }

    public void setApplicationStatsMaxResponseTime(String value) {
        this._ApplicationStatsMaxResponseTime = value;
    }

    public String getApplicationStatsMaxResponseTime() {
        return this._ApplicationStatsMaxResponseTime;
    }

    public void setApplicationStatsNumFailoverRequests(String value) {
        this._ApplicationStatsNumFailoverRequests = value;
    }

    public String getApplicationStatsNumFailoverRequests() {
        return this._ApplicationStatsNumFailoverRequests;
    }

    public void setApplicationStatsNumErrorRequests(String value) {
        this._ApplicationStatsNumErrorRequests = value;
    }

    public String getApplicationStatsNumErrorRequests() {
        return this._ApplicationStatsNumErrorRequests;
    }

    public void setApplicationStatsNumActiveRequests(String value) {
        this._ApplicationStatsNumActiveRequests = value;
    }

    public String getApplicationStatsNumActiveRequests() {
        return this._ApplicationStatsNumActiveRequests;
    }

    public void setApplicationStatsNumIdempotentUrlRequests(String value) {
        this._ApplicationStatsNumIdempotentUrlRequests = value;
    }

    public String getApplicationStatsNumIdempotentUrlRequests() {
        return this._ApplicationStatsNumIdempotentUrlRequests;
    }

    public void setApplicationStatsNumTotalRequests(String value) {
        this._ApplicationStatsNumTotalRequests = value;
    }

    public String getApplicationStatsNumTotalRequests() {
        return this._ApplicationStatsNumTotalRequests;
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        out.write(indent);
        out.write("<");
        out.write(nodeName);
        if (this._Id != null) {
            out.write(" id");
            out.write("='");
            LoadBalancerStats.writeXML(out, this._Id, true);
            out.write("'");
        }
        if (this._Health != null) {
            out.write(" health");
            out.write("='");
            LoadBalancerStats.writeXML(out, this._Health, true);
            out.write("'");
        }
        if (this._NumTotalRequests != null) {
            out.write(" num-total-requests");
            out.write("='");
            LoadBalancerStats.writeXML(out, this._NumTotalRequests, true);
            out.write("'");
        }
        if (this._NumActiveRequests != null) {
            out.write(" num-active-requests");
            out.write("='");
            LoadBalancerStats.writeXML(out, this._NumActiveRequests, true);
            out.write("'");
        }
        out.write(">\n");
        String nextIndent = indent + "\t";
        Iterator it = this._ApplicationStats.iterator();
        while (it.hasNext()) {
            boolean element = (Boolean)it.next();
            if (!element) continue;
            out.write(nextIndent);
            out.write("<application-stats");
            if (this._ApplicationStatsId != null) {
                out.write(" id");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsId, true);
                out.write("'");
            }
            if (this._ApplicationStatsAverageResponseTime != null) {
                out.write(" average-response-time");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsAverageResponseTime, true);
                out.write("'");
            }
            if (this._ApplicationStatsMinResponseTime != null) {
                out.write(" min-response-time");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsMinResponseTime, true);
                out.write("'");
            }
            if (this._ApplicationStatsMaxResponseTime != null) {
                out.write(" max-response-time");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsMaxResponseTime, true);
                out.write("'");
            }
            if (this._ApplicationStatsNumFailoverRequests != null) {
                out.write(" num-failover-requests");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsNumFailoverRequests, true);
                out.write("'");
            }
            if (this._ApplicationStatsNumErrorRequests != null) {
                out.write(" num-error-requests");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsNumErrorRequests, true);
                out.write("'");
            }
            if (this._ApplicationStatsNumActiveRequests != null) {
                out.write(" num-active-requests");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsNumActiveRequests, true);
                out.write("'");
            }
            if (this._ApplicationStatsNumIdempotentUrlRequests != null) {
                out.write(" num-idempotent-url-requests");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsNumIdempotentUrlRequests, true);
                out.write("'");
            }
            if (this._ApplicationStatsNumTotalRequests != null) {
                out.write(" num-total-requests");
                out.write("='");
                LoadBalancerStats.writeXML(out, this._ApplicationStatsNumTotalRequests, true);
                out.write("'");
            }
            out.write("/>\n");
        }
        out.write(indent);
        out.write("</" + nodeName + ">\n");
    }

    public void readNode(Node node) {
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            Attr attr = (Attr)attrs.getNamedItem("id");
            if (attr != null) {
                this._Id = attr.getValue();
            }
            if ((attr = (Attr)attrs.getNamedItem("health")) != null) {
                this._Health = attr.getValue();
            }
            if ((attr = (Attr)attrs.getNamedItem("num-total-requests")) != null) {
                this._NumTotalRequests = attr.getValue();
            }
            if ((attr = (Attr)attrs.getNamedItem("num-active-requests")) != null) {
                this._NumActiveRequests = attr.getValue();
            }
        }
        NodeList children = node.getChildNodes();
        int lastElementType = 0;
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName != "application-stats") continue;
            boolean aApplicationStats = childNode.getFirstChild() == null ? true : Boolean.valueOf(childNodeValue);
            if (childNode.hasAttributes()) {
                NamedNodeMap attrs = childNode.getAttributes();
                Attr attr = (Attr)attrs.getNamedItem("id");
                if (attr != null) {
                    this._ApplicationStatsId = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("average-response-time")) != null) {
                    this._ApplicationStatsAverageResponseTime = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("min-response-time")) != null) {
                    this._ApplicationStatsMinResponseTime = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("max-response-time")) != null) {
                    this._ApplicationStatsMaxResponseTime = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("num-failover-requests")) != null) {
                    this._ApplicationStatsNumFailoverRequests = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("num-error-requests")) != null) {
                    this._ApplicationStatsNumErrorRequests = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("num-active-requests")) != null) {
                    this._ApplicationStatsNumActiveRequests = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("num-idempotent-url-requests")) != null) {
                    this._ApplicationStatsNumIdempotentUrlRequests = attr.getValue();
                }
                if ((attr = (Attr)attrs.getNamedItem("num-total-requests")) != null) {
                    this._ApplicationStatsNumTotalRequests = attr.getValue();
                }
            }
            this._ApplicationStats.add(aApplicationStats ? Boolean.TRUE : Boolean.FALSE);
            lastElementType = 4;
        }
    }

    public void validate() throws LoadBalancerStats.ValidateException {
        boolean restrictionFailure = false;
        if (this.getId() == null) {
            throw new LoadBalancerStats.ValidateException("getId() == null", "id", this);
        }
        if (this.getHealth() == null) {
            throw new LoadBalancerStats.ValidateException("getHealth() == null", "health", this);
        }
        if (this.getNumTotalRequests() == null) {
            throw new LoadBalancerStats.ValidateException("getNumTotalRequests() == null", "numTotalRequests", this);
        }
        if (this.getNumActiveRequests() == null) {
            throw new LoadBalancerStats.ValidateException("getNumActiveRequests() == null", "numActiveRequests", this);
        }
        for (int _index = 0; _index < this.sizeApplicationStats(); ++_index) {
            boolean bl = this.isApplicationStats(_index);
        }
        if (this.getApplicationStatsId() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsId() == null", "applicationStatsId", this);
        }
        if (this.getApplicationStatsAverageResponseTime() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsAverageResponseTime() == null", "applicationStatsAverageResponseTime", this);
        }
        if (this.getApplicationStatsMinResponseTime() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsMinResponseTime() == null", "applicationStatsMinResponseTime", this);
        }
        if (this.getApplicationStatsMaxResponseTime() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsMaxResponseTime() == null", "applicationStatsMaxResponseTime", this);
        }
        if (this.getApplicationStatsNumFailoverRequests() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsNumFailoverRequests() == null", "applicationStatsNumFailoverRequests", this);
        }
        if (this.getApplicationStatsNumErrorRequests() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsNumErrorRequests() == null", "applicationStatsNumErrorRequests", this);
        }
        if (this.getApplicationStatsNumActiveRequests() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsNumActiveRequests() == null", "applicationStatsNumActiveRequests", this);
        }
        if (this.getApplicationStatsNumIdempotentUrlRequests() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsNumIdempotentUrlRequests() == null", "applicationStatsNumIdempotentUrlRequests", this);
        }
        if (this.getApplicationStatsNumTotalRequests() == null) {
            throw new LoadBalancerStats.ValidateException("getApplicationStatsNumTotalRequests() == null", "applicationStatsNumTotalRequests", this);
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "id") {
            this.setId((String)value);
        } else if (name == "health") {
            this.setHealth((String)value);
        } else if (name == "numTotalRequests") {
            this.setNumTotalRequests((String)value);
        } else if (name == "numActiveRequests") {
            this.setNumActiveRequests((String)value);
        } else if (name == "applicationStats") {
            this.addApplicationStats((Boolean)value);
        } else if (name == "applicationStats[]") {
            this.setApplicationStats((boolean[])value);
        } else if (name == "applicationStatsId") {
            this.setApplicationStatsId((String)value);
        } else if (name == "applicationStatsAverageResponseTime") {
            this.setApplicationStatsAverageResponseTime((String)value);
        } else if (name == "applicationStatsMinResponseTime") {
            this.setApplicationStatsMinResponseTime((String)value);
        } else if (name == "applicationStatsMaxResponseTime") {
            this.setApplicationStatsMaxResponseTime((String)value);
        } else if (name == "applicationStatsNumFailoverRequests") {
            this.setApplicationStatsNumFailoverRequests((String)value);
        } else if (name == "applicationStatsNumErrorRequests") {
            this.setApplicationStatsNumErrorRequests((String)value);
        } else if (name == "applicationStatsNumActiveRequests") {
            this.setApplicationStatsNumActiveRequests((String)value);
        } else if (name == "applicationStatsNumIdempotentUrlRequests") {
            this.setApplicationStatsNumIdempotentUrlRequests((String)value);
        } else if (name == "applicationStatsNumTotalRequests") {
            this.setApplicationStatsNumTotalRequests((String)value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for InstanceStats");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "id") {
            return this.getId();
        }
        if (name == "health") {
            return this.getHealth();
        }
        if (name == "numTotalRequests") {
            return this.getNumTotalRequests();
        }
        if (name == "numActiveRequests") {
            return this.getNumActiveRequests();
        }
        if (name == "applicationStats[]") {
            return this.getApplicationStats();
        }
        if (name == "applicationStatsId") {
            return this.getApplicationStatsId();
        }
        if (name == "applicationStatsAverageResponseTime") {
            return this.getApplicationStatsAverageResponseTime();
        }
        if (name == "applicationStatsMinResponseTime") {
            return this.getApplicationStatsMinResponseTime();
        }
        if (name == "applicationStatsMaxResponseTime") {
            return this.getApplicationStatsMaxResponseTime();
        }
        if (name == "applicationStatsNumFailoverRequests") {
            return this.getApplicationStatsNumFailoverRequests();
        }
        if (name == "applicationStatsNumErrorRequests") {
            return this.getApplicationStatsNumErrorRequests();
        }
        if (name == "applicationStatsNumActiveRequests") {
            return this.getApplicationStatsNumActiveRequests();
        }
        if (name == "applicationStatsNumIdempotentUrlRequests") {
            return this.getApplicationStatsNumIdempotentUrlRequests();
        }
        if (name == "applicationStatsNumTotalRequests") {
            return this.getApplicationStatsNumTotalRequests();
        }
        throw new IllegalArgumentException(name + " is not a valid property name for InstanceStats");
    }

    public CommonBean[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        CommonBean[] result = new CommonBean[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceStats)) {
            return false;
        }
        InstanceStats inst = (InstanceStats)o;
        if (!(this._Id != null ? this._Id.equals(inst._Id) : inst._Id == null)) {
            return false;
        }
        if (!(this._Health != null ? this._Health.equals(inst._Health) : inst._Health == null)) {
            return false;
        }
        if (!(this._NumTotalRequests != null ? this._NumTotalRequests.equals(inst._NumTotalRequests) : inst._NumTotalRequests == null)) {
            return false;
        }
        if (!(this._NumActiveRequests != null ? this._NumActiveRequests.equals(inst._NumActiveRequests) : inst._NumActiveRequests == null)) {
            return false;
        }
        if (this.sizeApplicationStats() != inst.sizeApplicationStats()) {
            return false;
        }
        Iterator it = this._ApplicationStats.iterator();
        Iterator it2 = inst._ApplicationStats.iterator();
        while (it.hasNext() && it2.hasNext()) {
            boolean element2;
            boolean element = (Boolean)it.next();
            if (element == (element2 = ((Boolean)it2.next()).booleanValue())) continue;
            return false;
        }
        if (!(this._ApplicationStatsId != null ? this._ApplicationStatsId.equals(inst._ApplicationStatsId) : inst._ApplicationStatsId == null)) {
            return false;
        }
        if (!(this._ApplicationStatsAverageResponseTime != null ? this._ApplicationStatsAverageResponseTime.equals(inst._ApplicationStatsAverageResponseTime) : inst._ApplicationStatsAverageResponseTime == null)) {
            return false;
        }
        if (!(this._ApplicationStatsMinResponseTime != null ? this._ApplicationStatsMinResponseTime.equals(inst._ApplicationStatsMinResponseTime) : inst._ApplicationStatsMinResponseTime == null)) {
            return false;
        }
        if (!(this._ApplicationStatsMaxResponseTime != null ? this._ApplicationStatsMaxResponseTime.equals(inst._ApplicationStatsMaxResponseTime) : inst._ApplicationStatsMaxResponseTime == null)) {
            return false;
        }
        if (!(this._ApplicationStatsNumFailoverRequests != null ? this._ApplicationStatsNumFailoverRequests.equals(inst._ApplicationStatsNumFailoverRequests) : inst._ApplicationStatsNumFailoverRequests == null)) {
            return false;
        }
        if (!(this._ApplicationStatsNumErrorRequests != null ? this._ApplicationStatsNumErrorRequests.equals(inst._ApplicationStatsNumErrorRequests) : inst._ApplicationStatsNumErrorRequests == null)) {
            return false;
        }
        if (!(this._ApplicationStatsNumActiveRequests != null ? this._ApplicationStatsNumActiveRequests.equals(inst._ApplicationStatsNumActiveRequests) : inst._ApplicationStatsNumActiveRequests == null)) {
            return false;
        }
        if (!(this._ApplicationStatsNumIdempotentUrlRequests != null ? this._ApplicationStatsNumIdempotentUrlRequests.equals(inst._ApplicationStatsNumIdempotentUrlRequests) : inst._ApplicationStatsNumIdempotentUrlRequests == null)) {
            return false;
        }
        return this._ApplicationStatsNumTotalRequests != null ? this._ApplicationStatsNumTotalRequests.equals(inst._ApplicationStatsNumTotalRequests) : inst._ApplicationStatsNumTotalRequests == null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._Id == null ? 0 : this._Id.hashCode());
        result = 37 * result + (this._Health == null ? 0 : this._Health.hashCode());
        result = 37 * result + (this._NumTotalRequests == null ? 0 : this._NumTotalRequests.hashCode());
        result = 37 * result + (this._NumActiveRequests == null ? 0 : this._NumActiveRequests.hashCode());
        result = 37 * result + ((Object)this._ApplicationStats).hashCode();
        result = 37 * result + (this._ApplicationStatsId == null ? 0 : this._ApplicationStatsId.hashCode());
        result = 37 * result + (this._ApplicationStatsAverageResponseTime == null ? 0 : this._ApplicationStatsAverageResponseTime.hashCode());
        result = 37 * result + (this._ApplicationStatsMinResponseTime == null ? 0 : this._ApplicationStatsMinResponseTime.hashCode());
        result = 37 * result + (this._ApplicationStatsMaxResponseTime == null ? 0 : this._ApplicationStatsMaxResponseTime.hashCode());
        result = 37 * result + (this._ApplicationStatsNumFailoverRequests == null ? 0 : this._ApplicationStatsNumFailoverRequests.hashCode());
        result = 37 * result + (this._ApplicationStatsNumErrorRequests == null ? 0 : this._ApplicationStatsNumErrorRequests.hashCode());
        result = 37 * result + (this._ApplicationStatsNumActiveRequests == null ? 0 : this._ApplicationStatsNumActiveRequests.hashCode());
        result = 37 * result + (this._ApplicationStatsNumIdempotentUrlRequests == null ? 0 : this._ApplicationStatsNumIdempotentUrlRequests.hashCode());
        result = 37 * result + (this._ApplicationStatsNumTotalRequests == null ? 0 : this._ApplicationStatsNumTotalRequests.hashCode());
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeNode(sw, "InstanceStats", "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

