/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.filter.spi;

import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FilterRegistry {
    private static FilterRegistry fm = null;
    private static HashMap managedEndpoints = null;
    private static HashMap filters = null;
    public static final String DELIM = ":";

    public synchronized void registerFilter(String stage, String endpoint, Filter filter) {
        ArrayList<Filter> fl = (ArrayList<Filter>)filters.get(stage + DELIM + endpoint);
        if (fl == null) {
            fl = new ArrayList<Filter>();
        }
        fl.add(filter);
        filters.put(stage + DELIM + endpoint, fl);
        this.setManaged(endpoint);
    }

    public void unregisterFilter(String stage, String endpoint, Filter filter) {
        List fl = (List)filters.get(stage + DELIM + endpoint);
        if (fl == null) {
            throw new IllegalArgumentException(" No registration exists for " + stage + DELIM + endpoint);
        }
        fl.remove(filter);
        if (fl.size() == 0) {
            this.setUnManaged(endpoint);
        }
    }

    public void unregisterFilterByName(String stage, String endpoint, String filtername) {
        List fl = (List)filters.get(stage + DELIM + endpoint);
        if (fl == null) {
            throw new IllegalArgumentException(" No registration exists for " + stage + DELIM + endpoint);
        }
        Iterator fli = fl.iterator();
        while (fli.hasNext()) {
            Filter f = (Filter)fli.next();
            if (!f.getName().equals(filtername)) continue;
            fli.remove();
        }
        if (fl.size() == 0) {
            this.setUnManaged(endpoint);
        }
    }

    public void unregisterAllFilters(String endpoint) {
        Iterator itr = filters.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.contains(DELIM + endpoint)) continue;
            itr.remove();
        }
    }

    public List getFilters(String stage, String endpoint) {
        return (List)filters.get(stage + DELIM + endpoint);
    }

    public FilterRegistration[] getFilters(String endpoint) {
        return null;
    }

    public boolean isManaged(String endpoint) {
        if (managedEndpoints == null) {
            return false;
        }
        Object o = managedEndpoints.get(endpoint);
        return o != null;
    }

    public void setManaged(String endpoint) {
        managedEndpoints.put(endpoint, new Boolean(true));
    }

    public void setUnManaged(String endpoint) {
        managedEndpoints.remove(endpoint);
    }

    public static synchronized FilterRegistry getInstance() {
        if (fm == null) {
            fm = new FilterRegistry();
        }
        if (managedEndpoints == null) {
            managedEndpoints = new HashMap();
        }
        if (filters == null) {
            filters = new HashMap();
        }
        return fm;
    }

    private FilterRegistry() {
    }
}

