/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.pool.impl;

import com.sun.enterprise.admin.wsmgmt.pool.spi.Pool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BoundedPool
implements Pool {
    private List _keyList = null;
    private Map _map = null;
    private String _name = null;
    private int _maxSizeAllowed = 25;

    public BoundedPool(String name) {
        this._name = name;
        this._keyList = Collections.synchronizedList(new ArrayList());
        this._map = new HashMap();
    }

    public BoundedPool(String name, int size) {
        this(name);
        this._maxSizeAllowed = size;
    }

    public Object get(Object key) {
        return this._map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object val) {
        if (key == null && val == null) {
            throw new IllegalArgumentException();
        }
        Object oldVal = null;
        BoundedPool boundedPool = this;
        synchronized (boundedPool) {
            oldVal = this._map.put(key, val);
            this._keyList.add(key);
            if (this._keyList.size() > this._maxSizeAllowed) {
                Object rkey = this._keyList.remove(0);
                assert (rkey != null);
                Object rval = this._map.remove(rkey);
                assert (rval != null);
            }
        }
        return oldVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object val = null;
        BoundedPool boundedPool = this;
        synchronized (boundedPool) {
            this._keyList.remove(key);
            val = this._map.remove(key);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        BoundedPool boundedPool = this;
        synchronized (boundedPool) {
            this._map.clear();
            this._keyList.clear();
        }
    }

    public int size() {
        return this._map.size();
    }

    public int getMaxSize() {
        return this._maxSizeAllowed;
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object val) {
        return this._map.containsValue(val);
    }

    public Collection values() {
        return this._map.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int size) {
        if (size < 1) {
            return;
        }
        if (size != this._maxSizeAllowed) {
            if (size > this._maxSizeAllowed) {
                BoundedPool boundedPool = this;
                synchronized (boundedPool) {
                    this._maxSizeAllowed = size;
                }
            }
            BoundedPool boundedPool = this;
            synchronized (boundedPool) {
                int i;
                int currentSize = this._map.size();
                int diff = currentSize - size;
                for (i = 0; i < diff; ++i) {
                    Object key = this._keyList.get(i);
                    assert (key != null);
                    if (key == null) continue;
                    Object val = this._map.remove(key);
                    assert (val != null);
                }
                for (i = 0; i < diff; ++i) {
                    this._keyList.remove(0);
                }
                this._maxSizeAllowed = size;
            }
        }
    }

    public String getName() {
        return this._name;
    }
}

