/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.management.offline.AuthRealmSupport;
import com.sun.enterprise.management.offline.StdConfigBeanHelper;
import java.util.Set;
import javax.management.AttributeNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AuthRealmConfigBeanHelper
extends StdConfigBeanHelper {
    private AuthRealmSupport mSupport = this.createSupport();
    private static final String TEMPLATE_PREFIX = "${";
    private static final String USER_NAMES_ATTR = "UserNames";
    private static final String GROUP_NAMES_ATTR = "GroupNames";
    private static final Set<String> SUPPORTED_OPERATIONS = GSetUtil.newUnmodifiableStringSet("getUserGroupNames", "addUser", "updateUser", "removeUser");

    public AuthRealmConfigBeanHelper(ConfigContext configContext, ConfigBean configBean) {
        super(configContext, configBean);
    }

    private AuthRealmSupport createSupport() {
        AuthRealmSupport support = null;
        if (this.isStdFileRealm()) {
            String file = null;
            try {
                file = this.getFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file != null && file.indexOf(TEMPLATE_PREFIX) < 0) {
                support = new AuthRealmSupport(this);
            } else if (file != null) {
                // empty if block
            }
        }
        return support;
    }

    private boolean isStdFileRealm() {
        return "com.sun.enterprise.security.auth.realm.file.FileRealm".equals(this.getClassname());
    }

    private void checkRealmType() {
        if (!this.isStdFileRealm()) {
            throw new IllegalArgumentException("AuthRealm type " + this.getClassname() + " not supported.");
        }
    }

    @Override
    protected Set<String> _getAttributeNames() {
        Set<String> attrNames = super._getAttributeNames();
        if (this.isStdFileRealm()) {
            attrNames.add(GROUP_NAMES_ATTR);
            attrNames.add(USER_NAMES_ATTR);
        }
        return attrNames;
    }

    @Override
    protected Class getAttributeClass(String attrName) {
        Class<String[]> result = null;
        result = this.isStdFileRealm() && (GROUP_NAMES_ATTR.equals(attrName) || USER_NAMES_ATTR.equals(attrName)) ? String[].class : super.getAttributeClass(attrName);
        return result;
    }

    @Override
    public Object getAttribute(String attrName) throws AttributeNotFoundException {
        Object result = null;
        if (GROUP_NAMES_ATTR.equals(attrName)) {
            this.checkRealmType();
            result = this.mSupport.getGroupNames();
        } else if (USER_NAMES_ATTR.equals(attrName)) {
            this.checkRealmType();
            result = this.mSupport.getUserNames();
        } else {
            result = super.getAttribute(attrName);
        }
        return result;
    }

    @Override
    public Object handleInvoke(String operationName, Object[] args, String[] types) {
        int numArgs;
        String[] result = null;
        int n = numArgs = args == null ? 0 : args.length;
        if (this.isStdFileRealm() && SUPPORTED_OPERATIONS.contains(operationName) && numArgs >= 1) {
            String user = (String)args[0];
            if (operationName.equals("getUserGroupNames") && numArgs == 1) {
                result = this.mSupport.getUserGroupNames(user);
            } else if (operationName.equals("addUser") && numArgs == 3) {
                String password = (String)args[1];
                String[] groupList = (String[])args[2];
                this.mSupport.addUser(user, password, groupList);
            } else if (operationName.equals("updateUser") && numArgs == 3) {
                String password = (String)args[1];
                String[] groupList = (String[])args[2];
                this.mSupport.updateUser(user, password, groupList);
            } else if (operationName.equals("removeUser") && numArgs == 1) {
                this.mSupport.removeUser(user);
            } else {
                this.unsupportedOperation(operationName, args, types);
            }
        } else {
            this.unsupportedOperation(operationName, args, types);
        }
        return result;
    }

    public String getFile() {
        return this.getPropertyValue("file");
    }

    public String getClassname() {
        try {
            return (String)this.getAttribute("Classname");
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

