/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.XTypesMapper;
import com.sun.appserv.management.j2ee.J2EETypesMapper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.ObjectNameQueryImpl;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.RegexUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.AMXNonConfigImplBase;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMgrImpl
extends AMXNonConfigImplBase {
    private static J2EETypesMapper sJ2EETypesMapper = null;

    @Override
    public final String getGroup() {
        return "utility";
    }

    private static Set<ObjectName> checked(Set<ObjectName> s) {
        return Collections.checkedSet(s, ObjectName.class);
    }

    public static Set<ObjectName> queryPropsObjectNameSet(MBeanServerConnection conn, String jmxDomainName, String props) throws IOException {
        ObjectName pattern = Util.newObjectNamePattern(jmxDomainName, props);
        Set<ObjectName> names = JMXUtil.queryNames(conn, pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public static Set<ObjectName> queryPropsObjectNameSet(MBeanServer server, String jmxDomainName, String props) {
        ObjectName pattern = Util.newObjectNamePattern(jmxDomainName, props);
        Set<ObjectName> names = JMXUtil.queryNames(server, pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public Set<ObjectName> queryPropsObjectNameSet(String props) {
        String myDomain = this.getObjectName().getDomain();
        Set<ObjectName> names = QueryMgrImpl.queryPropsObjectNameSet(this.getMBeanServer(), myDomain, props);
        return QueryMgrImpl.checked(names);
    }

    public ObjectName querySingletonJ2EETypeObjectName(String j2eeType) {
        return QueryMgrImpl.querySingletonJ2EETypeObjectName(this.getMBeanServer(), this.getObjectName().getDomain(), j2eeType);
    }

    public static ObjectName querySingletonJ2EETypeObjectName(MBeanServer server, String domainName, String j2eeTypeValue) {
        try {
            ObjectName objectName = QueryMgrImpl.querySingletonJ2EETypeObjectName((MBeanServerConnection)server, domainName, j2eeTypeValue);
            return objectName;
        }
        catch (IOException e) {
            assert (false);
            throw new RuntimeException(e);
        }
    }

    public static ObjectName querySingletonJ2EETypeObjectName(MBeanServerConnection conn, String domainName, String j2eeTypeValue) throws IOException {
        Set<ObjectName> names = QueryMgrImpl.queryJ2EETypeObjectNameSet(conn, domainName, j2eeTypeValue);
        if (names.size() != 1) {
            throw new IllegalArgumentException("request was for a single Object name of type: " + j2eeTypeValue + " but found several: " + SmartStringifier.toString(names));
        }
        ObjectName objectName = GSetUtil.getSingleton(names);
        return objectName;
    }

    public static Set<ObjectName> queryJ2EETypeObjectNameSet(MBeanServerConnection conn, String domainName, String j2eeTypeValue) throws IOException {
        String prop = Util.makeJ2EETypeProp(j2eeTypeValue);
        ObjectName pat = Util.newObjectNamePattern(domainName, prop);
        Set<ObjectName> names = QueryMgrImpl.queryPatternObjectNameSet(conn, pat);
        return QueryMgrImpl.checked(names);
    }

    public Set<ObjectName> queryJ2EETypesObjectNameSet(Set<String> j2eeTypes) throws IOException {
        String[] values = GSetUtil.toStringArray(j2eeTypes);
        String[] keys = new String[j2eeTypes.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = "j2eeType";
        }
        return this.queryWildObjectNameSet(keys, values);
    }

    public ObjectName querySingletonJ2EEType(String j2eeTypeValue) {
        Set<ObjectName> names = this.queryJ2EETypeObjectNameSet(j2eeTypeValue);
        if (names.size() > 1) {
            this.trace("QueryMgrImpl.getJ2EETypeObjectName: expected 1, got " + names.size());
            throw new IllegalArgumentException(j2eeTypeValue);
        }
        ObjectName objectName = names.size() == 0 ? null : GSetUtil.getSingleton(names);
        return objectName;
    }

    public Set<ObjectName> queryJ2EETypeObjectNameSet(String j2eeTypeValue) {
        String prop = Util.makeJ2EETypeProp(j2eeTypeValue);
        ObjectName pat = Util.newObjectNamePattern(this.getJMXDomain(), prop);
        Set<ObjectName> names = QueryMgrImpl.queryPropsObjectNameSet(this.getMBeanServer(), this.getJMXDomain(), prop);
        return names;
    }

    public Set<ObjectName> queryJ2EENameObjectNameSet(String nameValue) {
        String prop = Util.makeNameProp(nameValue);
        Set<ObjectName> names = QueryMgrImpl.queryPropsObjectNameSet(this.getMBeanServer(), this.getJMXDomain(), prop);
        return names;
    }

    public static Set<ObjectName> queryPatternObjectNameSet(MBeanServerConnection conn, ObjectName pattern) throws IOException {
        Set<ObjectName> names = JMXUtil.queryNames(conn, pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public static Set<ObjectName> queryPatternObjectNameSet(MBeanServer server, ObjectName pattern) {
        Set<ObjectName> names = JMXUtil.queryNames(server, pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public Set<ObjectName> queryPatternObjectNameSet(ObjectName pattern) {
        return QueryMgrImpl.queryPatternObjectNameSet(this.getMBeanServer(), pattern);
    }

    public Set<ObjectName> queryPatternObjectNameSet(String domain, String props) {
        String myDomain = this.getObjectName().getDomain();
        ObjectName pattern = Util.newObjectNamePattern(domain == null ? myDomain : domain, props);
        return QueryMgrImpl.queryPatternObjectNameSet(this.getMBeanServer(), pattern);
    }

    public String[] queryJ2EETypeNames(String j2eeType) {
        String prop = Util.makeJ2EETypeProp(j2eeType);
        Set<ObjectName> objectNameSet = this.queryPropsObjectNameSet(prop);
        ObjectName[] objectNames = JMXUtil.objectNameSetToArray(objectNameSet);
        String[] nameKeyValues = JMXUtil.getKeyProperty("name", objectNames);
        return nameKeyValues;
    }

    public Set<ObjectName> queryJ2EETypeNameObjectNameSet(String j2eeType, String name) {
        String props = Util.makeRequiredProps(j2eeType, name);
        return this.queryPatternObjectNameSet(Util.newObjectNamePattern(this.getObjectName().getDomain(), props));
    }

    private static String[] convertToRegex(String[] wildExprs) {
        String[] regexExprs = null;
        if (wildExprs != null) {
            regexExprs = new String[wildExprs.length];
            for (int i = 0; i < wildExprs.length; ++i) {
                String regex;
                String expr = wildExprs[i];
                regexExprs[i] = regex = expr == null ? null : RegexUtil.wildcardToJavaRegex(expr);
            }
        }
        return regexExprs;
    }

    private Set<ObjectName> matchWild(Set<ObjectName> candidates, String[] wildKeys, String[] wildValues) {
        String[] regexNames = QueryMgrImpl.convertToRegex(wildKeys);
        String[] regexValues = QueryMgrImpl.convertToRegex(wildValues);
        ObjectNameQueryImpl query = new ObjectNameQueryImpl();
        Set<ObjectName> resultSet = query.matchAll(candidates, regexNames, regexValues);
        return resultSet;
    }

    public Set<ObjectName> queryWildObjectNameSet(String[] wildKeys, String[] wildValues) {
        Set<ObjectName> candidates = this.queryAllObjectNameSet();
        return this.matchWild(candidates, wildKeys, wildValues);
    }

    public Set<ObjectName> queryAllObjectNameSet() {
        ObjectName pat = Util.newObjectNamePattern(this.getJMXDomain(), "");
        return this.queryPatternObjectNameSet(pat);
    }

    private Set<ObjectName> queryInterfaceObjectNameSet(Set<ObjectName> objectNames, String interfaceName, String attributeName) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        MBeanServer server = this.getMBeanServer();
        for (ObjectName objectName : objectNames) {
            try {
                if (!server.getAttribute(objectName, attributeName).equals(interfaceName)) continue;
                result.add(objectName);
            }
            catch (JMException e) {}
        }
        return QueryMgrImpl.checked(result);
    }

    public Set<ObjectName> queryInterfaceObjectNameSet(String searchInterfaceName, Set<ObjectName> candidates) throws ClassNotFoundException {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        Set<ObjectName> iter = candidates == null ? this.queryAllObjectNameSet() : candidates;
        Class searchInterface = ClassUtil.getClassFromName(searchInterfaceName);
        MBeanServer server = this.getMBeanServer();
        for (ObjectName objectName : iter) {
            try {
                String interfaceName = (String)server.getAttribute(objectName, "InterfaceName");
                Class c = ClassUtil.getClassFromName(interfaceName);
                if (!searchInterface.isAssignableFrom(c)) continue;
                result.add(objectName);
            }
            catch (JMException e) {}
        }
        return QueryMgrImpl.checked(result);
    }

    private static synchronized Class interfaceForJ2EEType(String j2eeType) {
        Class theClass = XTypesMapper.getInstance().getInterfaceForType(j2eeType);
        if (theClass == null) {
            theClass = J2EETypesMapper.getInstance().getInterfaceForType(j2eeType);
        }
        return theClass;
    }
}

