/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.tools.admingui.util.JarExtract;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FileUtil {
    public static final String DEPLOY = "deploy";
    public static final String REDEPLOY = "redeploy";
    public static final String TRANSFORMATION_RULE = "transformationRule";
    public static final String INSTANCE_ROOT = System.getProperty("com.sun.aas.instanceRoot");
    public static final String GEN_XML_DIR = INSTANCE_ROOT + File.separator + "generated" + File.separator + "xml";
    public static final String GEN_XML_APP_DIR = GEN_XML_DIR + File.separator + "j2ee-apps";
    public static final String GEN_XML_MOD_DIR = GEN_XML_DIR + File.separator + "j2ee-modules";

    public static String getUploadDir() throws Exception {
        return AdminService.getAdminService().getGUITempDirPath();
    }

    public static boolean isEARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isWARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("WEB-INF/web.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isEJBJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ejb-jar.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isJarFile(File file) {
        try {
            boolean result = false;
            if (file.getName().endsWith(".jar")) {
                JarFile jar = new JarFile(file);
                if (jar != null) {
                    result = jar.entries().hasMoreElements();
                }
                jar.close();
                return result;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isRARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ra.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isAppClientJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application-client.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void extractMbeanJarFile(String domainRoot, String fileName) throws IOException {
        File f = new File(fileName);
        if (FileUtil.isJarFile(f)) {
            JarExtract.extract(fileName, domainRoot + "/applications/mbeans");
        }
    }
}

