/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.ViewBean;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewManager;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import java.util.Iterator;
import java.util.List;

public class DisplayFieldHandlers {
    public static final String VALUE = "value";
    public static final String MULTI_VALUE = "multiple";
    public static final String VIEW_ID = "viewID";
    public static final String FIELD_NAME = "fieldName";
    public static final String DISPLAY_FIELD = "displayField";

    public void getDisplayFieldValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        DisplayField field = (DisplayField)handlerCtx.getInputValue(DISPLAY_FIELD);
        if (field == null) {
            this.getDisplayField(reqCtx, handlerCtx);
            field = (DisplayField)handlerCtx.getOutputValue(VALUE);
        }
        Boolean multi = (Boolean)handlerCtx.getInputValue(MULTI_VALUE);
        boolean getMulti = false;
        if (multi != null) {
            getMulti = multi;
        }
        Object value = getMulti ? field.getValues() : field.getValue();
        handlerCtx.setOutputValue(VALUE, value);
    }

    public void getDisplayField(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object viewID = handlerCtx.getInputValue(VIEW_ID);
        if (viewID == null) {
            throw new IllegalArgumentException("The parameter map did not contain viewID!");
        }
        ViewBeanManager vm = reqCtx.getViewBeanManager();
        ViewBean view = null;
        String topName = viewID instanceof List ? ((List)viewID).get(0).toString() : viewID.toString();
        try {
            view = vm.getViewBean(topName);
        }
        catch (ClassCastException ex) {
            view = ((DescriptorViewManager)vm).getView(null, topName);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        if (view == null) {
            throw new RuntimeException("Unable to obtain the view for mapping!");
        }
        if (viewID instanceof List) {
            Iterator iter = ((List)viewID).iterator();
            iter.next();
            while (iter.hasNext()) {
                if (!(view instanceof ContainerView)) {
                    throw new RuntimeException("View (" + view.getQualifiedName() + ") is not a ContainerView!");
                }
                view = ((ContainerView)view).getChild("" + iter.next());
            }
        }
        if (!(view instanceof ContainerView)) {
            throw new RuntimeException("View (" + view.getQualifiedName() + ") is not a ContainerView!");
        }
        Object fieldName = handlerCtx.getInputValue(FIELD_NAME);
        if (fieldName == null) {
            throw new IllegalArgumentException("The parameter map did not contain fieldName!");
        }
        DisplayField field = ((ContainerView)view).getDisplayField(fieldName.toString());
        if (field == null) {
            throw new RuntimeException("Field (" + fieldName + ") not found on View (" + viewID + ")!");
        }
        handlerCtx.setOutputValue(VALUE, field);
    }

    public void setDisplayFieldValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        DisplayField field = (DisplayField)handlerCtx.getInputValue(DISPLAY_FIELD);
        if (field == null) {
            this.getDisplayField(reqCtx, handlerCtx);
            field = (DisplayField)handlerCtx.getOutputValue(VALUE);
        }
        Boolean multi = (Boolean)handlerCtx.getInputValue(MULTI_VALUE);
        boolean getMulti = false;
        if (multi != null) {
            getMulti = multi;
        }
        Object[] value = handlerCtx.getInputValue(VALUE);
        if (getMulti) {
            if (value != null && !value.getClass().isArray()) {
                value = new Object[]{value};
            }
            field.setValues(value);
        } else {
            field.setValue((Object)value);
        }
    }
}

