/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOObjectNotFoundException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SCO;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.TestStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateObjectDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.QueryValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.state.Hollow;
import com.sun.jdo.spi.persistence.support.sqlstore.state.LifeCycleState;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentClean;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentNonTransactional;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.NullSemaphore;
import com.sun.jdo.spi.persistence.utility.Semaphore;
import com.sun.jdo.spi.persistence.utility.SemaphoreImpl;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class SQLStateManager
implements Cloneable,
StateManager,
TestStateManager {
    private static final int PRESENCE_MASK = 0;
    private static final int SET_MASK = 1;
    private static final int MAX_MASKS = 2;
    private BitSet fieldMasks;
    public ArrayList hiddenValues;
    private ClassDesc persistenceConfig;
    private PersistenceManager persistenceManager;
    private PersistenceStore store;
    private SQLStateManager beforeImage;
    private Object persistentObject;
    private Object objectId;
    private LifeCycleState state;
    private static final short ST_UPDATE_DISABLED = 1;
    private static final short ST_REGISTERED = 2;
    private static final short ST_VISITED = 4;
    private static final short ST_PREPARED_PHASE_II = 8;
    private static final short ST_FIELD_TRACKING_INPROGRESS = 16;
    private static final short ST_DELETE_INPROGRESS = 32;
    private static final short ST_VALIDATION_FAILED = 64;
    private short stateFlags;
    private boolean isReplacementInstance = false;
    private boolean needsRegisterAtRollback = false;
    private boolean needsVerifyAtDeregister = false;
    private boolean valid = false;
    private UpdateObjectDescImpl updateDesc;
    private HashSet updatedForeignReferences;
    private int referenceCount;
    private final Semaphore lock;
    private static Logger logger = LogHelperStateManager.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(SQLStateManager.class);
    public static final String USE_BATCH_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.USE_BATCH";
    private static final boolean USE_BATCH = Boolean.valueOf(System.getProperty("com.sun.jdo.spi.persistence.support.sqlstore.USE_BATCH", "true"));

    public SQLStateManager(PersistenceStore store, ClassDesc persistenceConfig) {
        this.store = store;
        this.persistenceConfig = persistenceConfig;
        this.lock = EJBHelper.isManaged() ? new NullSemaphore("SQLStateManager") : new SemaphoreImpl("SQLStateManager");
    }

    public synchronized void initialize(boolean persistentInDB) {
        boolean xactActive = this.persistenceManager.isActiveTransaction();
        boolean optimistic = this.persistenceManager.isOptimisticTransaction();
        boolean nontransactionalRead = this.persistenceManager.isNontransactionalRead();
        LifeCycleState oldstate = this.state;
        if (this.state == null) {
            if (!persistentInDB) {
                this.state = LifeCycleState.getLifeCycleState(0);
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            } else {
                if (xactActive && !optimistic) {
                    this.state = LifeCycleState.getLifeCycleState(2);
                    this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
                } else {
                    this.state = LifeCycleState.getLifeCycleState(1);
                    this.persistenceManager.setFlags(this.persistentObject, (byte)1);
                }
                this.valid = true;
            }
        } else if (this.state.needMerge()) {
            this.state = this.state.transitionReadField(optimistic, nontransactionalRead, xactActive);
            if (this.state.needsReload(optimistic, nontransactionalRead, xactActive)) {
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            } else if (this.persistenceManager.getFlags(this.persistentObject) == 1) {
                this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
            }
        }
        this.registerInstance(false, null, oldstate);
    }

    private void registerInstance(boolean throwDuplicateException, ArrayList newlyRegisteredSMs, LifeCycleState oldstate) {
        if ((this.stateFlags & 2) == 0 || oldstate != this.state && (oldstate == null || oldstate.isDirty() != this.state.isDirty() || oldstate.isTransactional() != this.state.isTransactional())) {
            this.persistenceManager.registerInstance(this, this.getObjectId(), throwDuplicateException, false);
            this.stateFlags = (short)(this.stateFlags | 2);
            if (newlyRegisteredSMs != null && !newlyRegisteredSMs.contains(this)) {
                newlyRegisteredSMs.add(this);
            }
        }
    }

    public void setPersistenceManager(com.sun.jdo.api.persistence.support.PersistenceManager pm) {
        this.persistenceManager = (PersistenceManager)pm;
    }

    public void setPersistent(Object pc) {
        this.persistentObject = pc;
    }

    public PersistenceStore getStore() {
        return this.store;
    }

    public Object getPersistent() {
        return this.persistentObject;
    }

    public PersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig;
    }

    private UpdateObjectDescImpl getUpdateDesc() {
        if (this.updateDesc == null) {
            this.updateDesc = (UpdateObjectDescImpl)this.store.getUpdateObjectDesc(this.persistenceConfig.getPersistenceCapableClass());
        }
        if (this.updateDesc.getConcurrency() == null) {
            boolean optimistic = this.persistenceManager.isOptimisticTransaction();
            this.updateDesc.setConcurrency(this.persistenceConfig.getConcurrency(optimistic));
        }
        return this.updateDesc;
    }

    private void unsetMaskBit(int index, int mask) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        } else if (index >= 0) {
            this.fieldMasks.clear(index + mask * this.persistenceConfig.maxFields);
        } else {
            this.fieldMasks.clear(-(index + 1) + this.persistenceConfig.maxVisibleFields + mask * this.persistenceConfig.maxFields);
        }
    }

    private void clearMask(int mask) {
        if (this.fieldMasks != null) {
            this.fieldMasks.clear(mask * this.persistenceConfig.maxFields, (mask + 1) * this.persistenceConfig.maxFields);
        }
    }

    private void setVisibleMaskBits(int mask) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        int offset = mask * this.persistenceConfig.maxFields;
        this.fieldMasks.set(offset, offset + this.persistenceConfig.maxVisibleFields);
    }

    private BitSet getVisibleMaskBits(int mask) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        int offset = mask * this.persistenceConfig.maxFields;
        return this.fieldMasks.get(offset, offset + this.persistenceConfig.maxVisibleFields);
    }

    private void newFieldMasks() {
        this.fieldMasks = new BitSet(2 * this.persistenceConfig.maxFields);
    }

    public void setPresenceMaskBit(int index) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (index >= 0) {
            this.fieldMasks.set(index + 0 * this.persistenceConfig.maxFields);
        } else {
            this.fieldMasks.set(-(index + 1) + this.persistenceConfig.maxVisibleFields + 0 * this.persistenceConfig.maxFields);
        }
    }

    private void setSetMaskBit(int index) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (index >= 0) {
            this.fieldMasks.set(index + 1 * this.persistenceConfig.maxFields);
        } else {
            this.fieldMasks.set(-(index + 1) + this.persistenceConfig.maxVisibleFields + 1 * this.persistenceConfig.maxFields);
        }
    }

    public boolean getPresenceMaskBit(int index) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (index >= 0) {
            return this.fieldMasks.get(index + 0 * this.persistenceConfig.maxFields);
        }
        return this.fieldMasks.get(-(index + 1) + this.persistenceConfig.maxVisibleFields + 0 * this.persistenceConfig.maxFields);
    }

    public boolean getSetMaskBit(int index) {
        if (this.fieldMasks == null) {
            this.newFieldMasks();
        }
        if (index >= 0) {
            return this.fieldMasks.get(index + 1 * this.persistenceConfig.maxFields);
        }
        return this.fieldMasks.get(-(index + 1) + this.persistenceConfig.maxVisibleFields + 1 * this.persistenceConfig.maxFields);
    }

    public Object getHiddenValue(int index) {
        if (index >= 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.poshiddenindex", "" + index));
        }
        int realIndex = -(index + 1);
        if (this.hiddenValues != null && realIndex < this.hiddenValues.size()) {
            return this.hiddenValues.get(realIndex);
        }
        return null;
    }

    public void setHiddenValue(int index, Object value) {
        if (index >= 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.poshiddenindex", "" + index));
        }
        int realIndex = -(index + 1);
        if (this.hiddenValues == null) {
            this.hiddenValues = new ArrayList();
        }
        for (int i = this.hiddenValues.size(); i <= realIndex; ++i) {
            this.hiddenValues.add(null);
        }
        this.hiddenValues.set(realIndex, value);
    }

    public synchronized void replaceObjectField(String fieldName, Object o) {
        FieldDesc fieldDesc;
        Object oldo;
        boolean debug = logger.isLoggable();
        if (debug) {
            Object[] items = new Object[]{fieldName, o.getClass().getName()};
            logger.fine("sqlstore.sqlstatemanager.replaceobjectfield", items);
        }
        if ((oldo = this.prepareSetField(fieldDesc = this.persistenceConfig.getField(fieldName), o)) instanceof SCO && oldo != o) {
            if (debug) {
                logger.fine("sqlstore.sqlstatemanager.replaceobjectfield.unsetsco");
            }
            ((SCO)oldo).unsetOwner();
        }
    }

    public synchronized void makeDirty(String fieldName) {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.makedirty", fieldName);
        }
        FieldDesc fieldDesc = this.persistenceConfig.getField(fieldName);
        Object oldo = fieldDesc.getValue(this);
        this.prepareUpdateField(fieldDesc, null);
        Object newo = fieldDesc.getValue(this);
        if (newo instanceof SCO && oldo != newo) {
            if (oldo instanceof SCOCollection) {
                if (debug) {
                    logger.fine("sqlstore.sqlstatemanager.makedirty.fixscocollection");
                }
                ((SCOCollection)oldo).clearInternal();
                ((SCOCollection)oldo).addAllInternal((Collection)newo);
            } else if (oldo instanceof SCODate) {
                if (debug) {
                    logger.fine("sqlstore.sqlstatemanager.makedirty.fixscodate");
                }
                long l = ((Date)newo).getTime();
                int n = 0;
                n = newo instanceof Timestamp ? ((Timestamp)newo).getNanos() : (int)(l % 1000L * 1000000L);
                if (oldo instanceof SqlTimestamp) {
                    ((SCODate)oldo).setTimeInternal(l);
                    ((SqlTimestamp)oldo).setNanosInternal(n);
                } else if (newo instanceof Timestamp) {
                    ((SCODate)oldo).setTimeInternal(l + (long)(n / 1000000));
                } else {
                    ((SCODate)oldo).setTimeInternal(l);
                }
            }
            this.updateTrackedFields(fieldDesc, oldo, null);
            fieldDesc.setValue(this, oldo);
            if (newo instanceof SCO) {
                ((SCO)newo).unsetOwner();
            }
        }
    }

    public void applyUpdates(String fieldName, SCOCollection c) {
        FieldDesc fieldDesc;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.applyupdates", fieldName);
        }
        if ((fieldDesc = this.persistenceConfig.getField(fieldName)) instanceof ForeignFieldDesc) {
            ArrayList removed = new ArrayList(c.getRemoved());
            ArrayList added = new ArrayList(c.getAdded());
            c.reset();
            this.processCollectionUpdates((ForeignFieldDesc)fieldDesc, removed, added, null, true, false);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.applyupdates.exit");
        }
    }

    public void makePresent(String fieldName, Object value) {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.makepresent", fieldName);
        }
        FieldDesc fieldDesc = this.persistenceConfig.getField(fieldName);
        fieldDesc.setValue(this, value);
        this.setPresenceMaskBit(fieldDesc.absoluteID);
    }

    public void setObjectId(Object objectId) {
        this.objectId = objectId;
    }

    public Object getObjectId() {
        if (this.objectId == null) {
            Class oidClass = this.persistenceConfig.getOidClass();
            Object oid = null;
            try {
                oid = oidClass.newInstance();
            }
            catch (Exception e) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantnewoid", oidClass.getName()), e);
            }
            Field[] keyFields = this.persistenceConfig.getKeyFields();
            String[] keyFieldNames = this.persistenceConfig.getKeyFieldNames();
            for (int i = 0; i < keyFields.length; ++i) {
                Field keyField = keyFields[i];
                try {
                    FieldDesc fd = this.persistenceConfig.getField(keyFieldNames[i]);
                    if (fd == null) continue;
                    keyField.set(oid, fd.getValue(this));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantsetkeyfield", keyField.getName()), e);
                }
            }
            this.objectId = oid;
        }
        return this.objectId;
    }

    private void makeAutoPersistent(Object pc) {
        this.persistenceManager.makePersistent(pc);
        SQLStateManager sm = (SQLStateManager)this.persistenceManager.getStateManager(pc);
        sm.state = LifeCycleState.getLifeCycleState(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistent(PersistenceManager pm, Object pc) {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.makepersistence", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (this.state != null) {
            if (this.state.isAutoPersistent()) {
                this.state = this.state.transitionMakePersistent();
            }
            return;
        }
        this.persistenceManager = pm;
        this.persistentObject = pc;
        this.setVisibleMaskBits(0);
        this.getBeforeImage();
        this.state = LifeCycleState.getLifeCycleState(4);
        try {
            this.registerInstance(true, null, null);
        }
        catch (JDOException e) {
            this.release();
            throw e;
        }
        pm.setStateManager(pc, this);
        this.valid = true;
        try {
            this.getLock();
            Object obj = null;
            ArrayList fields = this.persistenceConfig.fields;
            for (int i = 0; i < fields.size(); ++i) {
                FieldDesc f = (FieldDesc)fields.get(i);
                if ((f.sqlProperties & 0x40) > 0) continue;
                obj = f.getValue(this);
                if (f instanceof ForeignFieldDesc) {
                    ForeignFieldDesc ff = (ForeignFieldDesc)f;
                    ArrayList trackedFields = null;
                    if (debug) {
                        logger.fine("sqlstore.sqlstatemanager.processforeign", ff.getName());
                    }
                    if ((ff.sqlProperties & 0x20) > 0) {
                        trackedFields = ff.getTrackedFields();
                        Object theValue = obj;
                        for (int j = 0; j < trackedFields.size(); ++j) {
                            FieldDesc tf = (FieldDesc)trackedFields.get(j);
                            Object value = tf.getValue(this);
                            if (theValue != null && value != null && theValue != value) {
                                if (this.needsVerifyAtDeregister) {
                                    this.persistenceManager.deregisterInstance(this.getObjectId(), this);
                                    this.needsVerifyAtDeregister = false;
                                } else {
                                    this.persistenceManager.deregisterInstance(this.getObjectId());
                                }
                                this.release();
                                throw new JDOUserException(I18NHelper.getMessage(messages, "core.statemanager.conflictingvalues", ff.getName(), tf.getName()));
                            }
                            if (theValue != null || value == null) continue;
                            theValue = value;
                        }
                        if (theValue != obj) {
                            obj = theValue;
                            ff.setValue(this, obj);
                        }
                    }
                    if (obj != null) {
                        if (obj instanceof Collection) {
                            if (((Collection)obj).size() > 0) {
                                ArrayList removed = null;
                                ArrayList added = new ArrayList((Collection)obj);
                                this.processCollectionUpdates(ff, removed, added, null, true, false);
                            }
                        } else {
                            ff.setValue(this, null);
                            this.updateObjectField(ff, obj, true, false);
                            ff.setValue(this, obj);
                        }
                    } else if (ff.getInverseRelationshipField() != null && ff.cardinalityUPB > 1) {
                        this.replaceCollection(ff, null);
                    }
                    this.updateTrackedFields(ff, ff.getValue(this), null);
                } else {
                    if ((f.sqlProperties & 0x80) > 0) {
                        FieldDesc tf;
                        ArrayList trackedFields = f.getTrackedFields();
                        boolean found = false;
                        for (int j = trackedFields.size() - 1; j >= 0 && (tf = (FieldDesc)trackedFields.get(j)) instanceof ForeignFieldDesc; --j) {
                            if (tf.getValue(this) == null) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.updateTrackedFields(f, obj, null);
                        }
                    } else {
                        this.updateTrackedFields(f, obj, null);
                    }
                    if ((f.sqlProperties & 8) > 0) {
                        this.getUpdateDesc().recordUpdatedField((LocalFieldDesc)f);
                    }
                }
                if (debug) {
                    logger.fine("sqlstore.sqlstatemanager.makedirtyfield", f.getName());
                }
                this.setSetMaskBit(f.absoluteID);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent() {
        if (logger.isLoggable()) {
            logger.fine("sqlstore.sqlstatemanager.deletepersistence", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        this.persistenceManager.acquireFieldUpdateLock();
        try {
            try {
                this.getLock();
                if (this.state.isDeleted()) {
                    return;
                }
                this.deleteRelationships();
                LifeCycleState oldstate = this.state;
                this.state = this.state.transitionDeletePersistent();
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
                this.registerInstance(false, null, oldstate);
            }
            finally {
                this.releaseLock();
            }
        }
        finally {
            this.persistenceManager.releaseFieldUpdateLock();
        }
    }

    private void deleteRelationships() {
        ArrayList foreignFields = this.persistenceConfig.foreignFields;
        int size = foreignFields.size();
        this.stateFlags = (short)(this.stateFlags | 0x20);
        for (int i = 0; i < size; ++i) {
            SQLStateManager sm;
            ForeignFieldDesc ff = (ForeignFieldDesc)foreignFields.get(i);
            ForeignFieldDesc irf = ff.getInverseRelationshipField();
            if ((ff.sqlProperties & 0x40) > 0 || ff.deleteAction != 3 && irf == null) continue;
            this.prepareUpdateField(ff, null);
            if (ff.cardinalityUPB > 1) {
                Collection c = (Collection)ff.getValue(this);
                if (c == null) continue;
                ArrayList removed = new ArrayList(c);
                this.processCollectionUpdates(ff, removed, null, null, true, false);
                if (c instanceof SCOCollection) {
                    ((SCOCollection)c).clearInternal();
                } else {
                    c.clear();
                }
                if (ff.deleteAction != 3) continue;
                for (Object obj : removed) {
                    SQLStateManager sm2;
                    if (obj == null || (sm2 = (SQLStateManager)this.persistenceManager.getStateManager(obj)) == null || sm2.isDeleted() || (sm2.stateFlags & 0x20) != 0) continue;
                    try {
                        this.persistenceManager.deletePersistent(obj);
                    }
                    catch (Throwable e) {}
                }
                continue;
            }
            Object obj = ff.getValue(this);
            if (obj == null) continue;
            this.updateObjectField(ff, null, true, false);
            ff.setValue(this, null);
            if (ff.deleteAction != 3 || (sm = (SQLStateManager)this.persistenceManager.getStateManager(obj)) == null || sm.isDeleted() || (sm.stateFlags & 0x20) != 0) continue;
            try {
                this.persistenceManager.deletePersistent(obj);
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.stateFlags = (short)(this.stateFlags & 0xFFFFFFDF);
    }

    public void updatePersistent(StateManager next) {
        boolean debug = logger.isLoggable();
        if ((this.stateFlags & 1) > 0) {
            if (debug) {
                Object[] items = new Object[]{this.persistenceConfig.getPersistenceCapableClass().getName(), this.persistentObject};
                logger.fine("sqlstore.sqlstatemanager.updatepersistent.skipped", items);
            }
            return;
        }
        try {
            if (debug) {
                logger.fine("sqlstore.sqlstatemanager.updatepersistent", this.persistenceConfig.getPersistenceCapableClass().getName());
            }
            ArrayList actions = new ArrayList();
            this.getUpdateActions(actions);
            if (actions.size() == 1 && this.useBatch()) {
                UpdateObjectDesc updateDesc = (UpdateObjectDesc)actions.get(0);
                boolean immediateFlush = this.requiresImmediateFlush((SQLStateManager)next);
                if (debug && immediateFlush) {
                    Object[] items = new Object[]{this.getPersistent(), next != null ? next.getPersistent() : null};
                    logger.fine("sqlstore.sqlstatemanager.updatepersistent.immediateflush", items);
                }
                this.store.executeBatch(this.persistenceManager, updateDesc, immediateFlush);
            } else if (actions.size() > 0) {
                this.store.execute(this.persistenceManager, actions);
            }
            SQLStateManager.incrementVersion(actions);
            if (debug) {
                logger.fine("sqlstore.sqlstatemanager.updatepersistent.exit");
            }
        }
        catch (JDOException e) {
            e.addFailedObject(this.persistentObject);
            throw e;
        }
        catch (Exception e) {
            logger.throwing("sqlstore.SQLStateManager", "updatePersistent", e);
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.unknownexception"), e);
        }
    }

    private static void incrementVersion(List actions) {
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            ((UpdateObjectDescImpl)iter.next()).incrementVersion();
        }
    }

    public void incrementVersion() {
        LocalFieldDesc[] versionFields = this.persistenceConfig.getVersionFields();
        for (int i = 0; i < versionFields.length; ++i) {
            versionFields[i].incrementValue(this);
        }
    }

    public boolean hasVersionConsistency() {
        return this.persistenceConfig.hasVersionConsistency();
    }

    public boolean verifyPersistent() {
        assert (this.persistenceConfig.hasVersionConsistency());
        boolean verified = true;
        if (this.state instanceof PersistentClean) {
            RetrieveDesc verificationRD = this.persistenceConfig.getRetrieveDescForVerificationQuery(this.store);
            LocalFieldDesc[] keyFields = this.persistenceConfig.getKeyFieldDescs();
            LocalFieldDesc[] versionFields = this.persistenceConfig.getVersionFields();
            Object[] parameters = new Object[keyFields.length + versionFields.length];
            this.copyValues(parameters, keyFields, 0);
            this.copyValues(parameters, versionFields, keyFields.length);
            Boolean result = (Boolean)this.store.retrieve(this.persistenceManager, verificationRD, new QueryValueFetcher(parameters));
            verified = result;
        }
        return verified;
    }

    private boolean useBatch() {
        boolean result = false;
        if (USE_BATCH) {
            switch (this.state.getUpdateAction()) {
                case 1: {
                    result = !this.getUpdateDesc().hasChangedRelationships() && !this.getUpdateDesc().hasModifiedLobField();
                    break;
                }
                case 2: 
                case 3: {
                    result = !this.persistenceManager.isOptimisticTransaction() && !this.persistenceConfig.hasModifiedCheckAtCommitConsistency() && !this.getUpdateDesc().hasChangedRelationships() && !this.getUpdateDesc().hasModifiedLobField() && !this.hasVersionConsistency();
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void setVerificationFailed() {
        if (this.hasVersionConsistency()) {
            this.stateFlags = (short)(this.stateFlags | 0x40);
        }
    }

    public boolean isVerificationFailed() {
        return (this.stateFlags & 0x40) > 0;
    }

    private boolean requiresImmediateFlush(SQLStateManager next) {
        if (next == null) {
            return true;
        }
        if (this.persistenceConfig != next.persistenceConfig) {
            return true;
        }
        if (this.state.getUpdateAction() != next.state.getUpdateAction()) {
            return true;
        }
        if ((next.stateFlags & 1) > 0) {
            return true;
        }
        if (!next.useBatch()) {
            return true;
        }
        return this.getUpdateDesc().getUpdateAction() == 3 && this.persistenceConfig.hasLocalNonDFGFields() && !this.compareUpdatedFields(next);
    }

    private boolean compareUpdatedFields(SQLStateManager next) {
        BitSet updFields = this.getVisibleMaskBits(1);
        BitSet nextUpdFields = next != null ? next.getVisibleMaskBits(1) : null;
        return updFields.equals(nextUpdFields);
    }

    public void refreshPersistent() {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.refreshpersistent", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (this.state.isRefreshable()) {
            LifeCycleState oldstate = this.state;
            this.state = this.state.transitionRefreshPersistent();
            this.reload(null);
            this.registerInstance(false, null, oldstate);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.refreshpersistent.exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        boolean debug = logger.isLoggable(400);
        if (debug) {
            logger.finer("sqlstore.sqlstatemanager.unconditionalreload", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        this.persistenceManager.acquireShareLock();
        try {
            this.getLock();
            this.reload(null);
        }
        finally {
            this.persistenceManager.releaseShareLock();
            this.releaseLock();
            if (debug) {
                logger.finer("sqlstore.sqlstatemanager.unconditionalreload.exit");
            }
        }
    }

    private void reload(FieldDesc additionalField) {
        boolean debug = logger.isLoggable();
        if (debug) {
            String fieldName = additionalField != null ? additionalField.getName() : null;
            logger.fine("sqlstore.sqlstatemanager.reload", this.persistenceConfig.getPersistenceCapableClass().getName(), fieldName);
        }
        this.clearMask(0);
        this.markKeyFieldsPresent();
        this.clearMask(1);
        LifeCycleState oldState = this.state;
        this.state = this.state.transitionReload(this.persistenceManager.isActiveTransaction());
        if (!this.retrieveFromVersionConsistencyCache(additionalField)) {
            try {
                this.retrieve(additionalField);
            }
            catch (JDOException e) {
                this.state = oldState;
                throw e;
            }
        }
        this.registerInstance(false, null, oldState);
        if (this.persistenceManager.getFlags(this.persistentObject) == 1) {
            this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.reload.exit");
        }
    }

    private boolean retrieveFromVersionConsistencyCache(FieldDesc additionalField) {
        boolean rc = this.persistenceManager.initializeFromVersionConsistencyCache(this);
        if (rc && additionalField != null && !this.getPresenceMaskBit(additionalField.absoluteID)) {
            this.realizeField(additionalField);
        }
        return rc;
    }

    public void prepareToUpdatePhaseI() {
        int i;
        int action;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph1", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if ((action = this.state.getUpdateAction()) == 4 || action == 2) {
            return;
        }
        this.getUpdateDesc();
        ArrayList newlyRegisteredSMs = new ArrayList();
        ArrayList foreignFields = this.persistenceConfig.foreignFields;
        int size = foreignFields.size();
        for (i = 0; i < size; ++i) {
            Collection v;
            ForeignFieldDesc ff = (ForeignFieldDesc)foreignFields.get(i);
            if ((ff.sqlProperties & 0x40) > 0 || ff.cardinalityUPB <= 1 || !this.getSetMaskBit(ff.absoluteID) || (v = (Collection)ff.getValue(this)) == null || v instanceof SCO && ((SCO)((Object)v)).getOwner() != null || v.size() <= 0) continue;
            ArrayList removed = null;
            ArrayList added = new ArrayList(v);
            this.processCollectionUpdates(ff, removed, added, newlyRegisteredSMs, true, false);
        }
        for (i = 0; i < newlyRegisteredSMs.size(); ++i) {
            SQLStateManager sm = (SQLStateManager)newlyRegisteredSMs.get(i);
            sm.prepareToUpdatePhaseI();
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph1.exit");
        }
    }

    public void prepareToUpdatePhaseII(HashSet phase3sms) {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph2", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (this.state.isAutoPersistent()) {
            this.state = this.state.transitionMakePending();
            phase3sms.add(this);
            return;
        }
        if ((this.stateFlags & 8) > 0) {
            return;
        }
        this.stateFlags = (short)(this.stateFlags | 8);
        if (!this.state.isNew() && !this.state.isDirty() || this.state.isDeleted()) {
            return;
        }
        ArrayList foreignFields = this.persistenceConfig.foreignFields;
        int size = foreignFields.size();
        for (int i = 0; i < size; ++i) {
            ForeignFieldDesc ff = (ForeignFieldDesc)foreignFields.get(i);
            if (ff.cardinalityUPB <= 1) {
                Object v;
                if (!this.getPresenceMaskBit(ff.absoluteID) || (v = ff.getValue(this)) == null) continue;
                this.transitionPersistent(v, phase3sms);
                continue;
            }
            Collection c = this.getCollectionValue(ff);
            if (c == null) continue;
            for (Object v : c) {
                this.transitionPersistent(v, phase3sms);
            }
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph2.exit");
        }
    }

    public void prepareToUpdatePhaseIII() {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph3", this.persistenceConfig.getPersistenceCapableClass().getName());
        }
        if (!this.state.isPersistentInDataStore()) {
            if (this.updateDesc != null) {
                this.updateDesc.clearUpdatedJoinTableRelationships();
            }
            return;
        }
        ArrayList foreignFields = this.persistenceConfig.foreignFields;
        int size = foreignFields.size();
        for (int i = 0; i < size; ++i) {
            ForeignFieldDesc ff = (ForeignFieldDesc)foreignFields.get(i);
            if (ff.cardinalityUPB <= 1) {
                Object v;
                if (!this.getPresenceMaskBit(ff.absoluteID) || (v = ff.getValue(this)) == null) continue;
                this.updateObjectField(ff, null, false, false);
                continue;
            }
            Collection c = this.getCollectionValue(ff);
            if (c == null || c.size() <= 0) continue;
            ArrayList removed = new ArrayList(c);
            ArrayList added = null;
            this.processCollectionUpdates(ff, removed, added, null, false, false);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.preparetoupdateph3.exit");
        }
    }

    private void transitionPersistent(Object pc, HashSet phase3sms) {
        SQLStateManager sm = (SQLStateManager)this.persistenceManager.getStateManager(pc);
        if (sm != null && sm.state.isAutoPersistent()) {
            sm.state = sm.state.transitionMakePersistent();
            phase3sms.remove(sm);
            sm.prepareToUpdatePhaseII(phase3sms);
        }
    }

    private Collection getCollectionValue(ForeignFieldDesc ff) {
        SCOCollection sco;
        Collection c = null;
        if (ff.cardinalityUPB > 1 && (c = (Collection)ff.getValue(this)) != null && c instanceof SCOCollection && (sco = (SCOCollection)c).isDeferred()) {
            c = sco.getAdded();
        }
        return c;
    }

    private void getUpdateActions(ArrayList actions) {
        if ((this.stateFlags & 4) > 0) {
            return;
        }
        int action = this.state.getUpdateAction();
        if (action == 4 && this.updateDesc == null) {
            return;
        }
        this.getUpdateDesc();
        this.updateDesc.setObjectInfo(this.getBeforeImage(), this, action);
        if (action == 2 || action == 1 || this.updateDesc.hasUpdatedFields() || this.updateDesc.hasUpdatedJoinTableRelationships()) {
            actions.add(this.updateDesc);
        }
        this.stateFlags = (short)(this.stateFlags | 4);
        if (this.updatedForeignReferences != null) {
            Iterator iter = this.updatedForeignReferences.iterator();
            while (iter.hasNext()) {
                SQLStateManager sm = ((UpdatedForeignReference)iter.next()).getStateManager();
                if (sm.referenceCount == 1) {
                    sm.getUpdateActions(actions);
                }
                --sm.referenceCount;
            }
        }
    }

    public void release() {
        if (null != this.persistenceManager) {
            this.persistenceManager.setStateManager(this.persistentObject, null);
        }
        this.persistentObject = null;
        this.objectId = null;
        this.persistenceManager = null;
        this.beforeImage = null;
        this.hiddenValues = null;
        this.updatedForeignReferences = null;
        this.updateDesc = null;
        this.persistenceConfig = null;
        this.store = null;
        this.valid = false;
    }

    private void reset(boolean retainValues, boolean wasNew, boolean keepState) {
        boolean debug = logger.isLoggable();
        if (debug) {
            Object[] items = new Object[]{retainValues, wasNew, keepState};
            logger.fine("sqlstore.sqlstatemanager.reset", items);
        }
        if (this.state == null) {
            if (!keepState) {
                this.persistenceManager.clearFields(this.persistentObject);
            }
            this.persistenceManager.setFlags(this.persistentObject, (byte)0);
            if (this.needsVerifyAtDeregister) {
                this.persistenceManager.deregisterInstance(this.getObjectId(), this);
            } else {
                this.persistenceManager.deregisterInstance(this.getObjectId());
            }
            this.release();
        } else {
            this.stateFlags = 0;
            this.beforeImage = null;
            this.updatedForeignReferences = null;
            this.referenceCount = 0;
            if (this.updateDesc != null) {
                this.updateDesc.reset();
            }
            if (retainValues || this.state instanceof PersistentNonTransactional) {
                FieldDesc f = null;
                ArrayList fields = this.persistenceConfig.fields;
                for (int i = 0; i < fields.size(); ++i) {
                    f = (FieldDesc)fields.get(i);
                    Object v = f.getValue(this);
                    if (wasNew && f instanceof ForeignFieldDesc && v == null && ((ForeignFieldDesc)f).getInverseRelationshipField() == null) {
                        if (debug) {
                            logger.fine("sqlstore.sqlstatemanager.unsetmask", f.getName());
                        }
                        this.unsetMaskBit(f.absoluteID, 0);
                    }
                    if (v instanceof Collection && !(v instanceof SCOCollection) && !keepState) {
                        if (debug) {
                            logger.fine("sqlstore.sqlstatemanager.resettingcollection");
                        }
                        this.replaceCollection((ForeignFieldDesc)f, (Collection)v);
                        if (!debug) continue;
                        logger.fine("sqlstore.sqlstatemanager.newtype", f.getValue(this).getClass());
                        continue;
                    }
                    if (v instanceof SCOCollection) {
                        ((SCOCollection)v).reset();
                        continue;
                    }
                    if (!(v instanceof Date) || v instanceof SCODate || keepState) continue;
                    if (debug) {
                        logger.fine("sqlstore.sqlstatemanager.resettingdate");
                    }
                    v = f.convertValue(v, this);
                    f.setValue(this, v);
                    if (!debug) continue;
                    logger.fine("sqlstore.sqlstatemanager.newtype", f.getValue(this).getClass());
                }
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            } else {
                this.clearMask(0);
                this.persistenceManager.clearFields(this.persistentObject);
                this.markKeyFieldsPresent();
                this.persistenceManager.setFlags(this.persistentObject, (byte)1);
            }
            this.clearMask(1);
            this.isReplacementInstance = false;
            this.needsRegisterAtRollback = false;
            this.needsVerifyAtDeregister = false;
        }
    }

    public boolean isProcessed() {
        return this.referenceCount == 0;
    }

    public void flushed() {
        this.state = this.state.transitionFlushed();
        this.clearMask(1);
        this.stateFlags = (short)(this.stateFlags & 0xFFFFFFFB);
        this.stateFlags = (short)(this.stateFlags & 0xFFFFFFFE);
        this.stateFlags = (short)(this.stateFlags & 0xFFFFFFFD);
        this.persistenceManager.setFlags(this.persistentObject, (byte)1);
        if (this.updatedForeignReferences != null) {
            this.updatedForeignReferences.clear();
        }
        if (this.updateDesc != null) {
            this.updateDesc.reset();
        }
    }

    public void commit(boolean retainValues) {
        boolean wasNew = this.state.isNew() && !this.state.isDeleted();
        this.state = this.state.transitionCommit(retainValues);
        this.reset(retainValues, wasNew, false);
    }

    public void rollback(boolean retainValues) {
        boolean wasNew = this.state.isNew() && !this.state.isDeleted();
        boolean needsRestore = this.state.needsRestoreOnRollback(retainValues);
        this.state = this.state.transitionRollback(retainValues);
        boolean keepState = needsRestore;
        if (this.beforeImage != null && needsRestore) {
            this.copyFields(this.beforeImage, true, false);
            keepState = true;
        }
        if (this.needsRegisterAtRollback && !this.isReplacementInstance) {
            this.persistenceManager.registerInstance(this, this.getObjectId());
        }
        this.reset(retainValues, wasNew, keepState);
    }

    private void markKeyFieldsPresent() {
        ArrayList keyFields = this.persistenceConfig.getPrimaryTable().getKey().getFields();
        for (int i = 0; i < keyFields.size(); ++i) {
            LocalFieldDesc fd = (LocalFieldDesc)keyFields.get(i);
            if (fd == null) continue;
            this.setPresenceMaskBit(fd.absoluteID);
        }
    }

    public void prepareGetField(int fieldID) {
        FieldDesc fieldDesc = this.persistenceConfig.getField(fieldID);
        this.prepareGetField(fieldDesc, false, true);
    }

    private void prepareGetField(FieldDesc fieldDesc) {
        this.prepareGetField(fieldDesc, true, false);
    }

    private void prepareGetField(FieldDesc fieldDesc, boolean internal, boolean acquireShareLock) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.sqlstatemanager.preparegetfield", fieldDesc.getName());
        }
        if (acquireShareLock) {
            this.persistenceManager.acquireShareLock();
        }
        try {
            this.getLock();
            boolean xactActive = this.persistenceManager.isActiveTransaction();
            boolean optimistic = this.persistenceManager.isOptimisticTransaction();
            boolean nontransactionalRead = this.persistenceManager.isNontransactionalRead();
            if (this.state.needsReload(optimistic, nontransactionalRead, xactActive)) {
                this.reload(fieldDesc);
            }
            LifeCycleState oldstate = this.state;
            this.state = this.state.transitionReadField(optimistic, nontransactionalRead, xactActive);
            this.registerInstance(false, null, oldstate);
            if (!(!this.state.isNavigable() && internal || this.getPresenceMaskBit(fieldDesc.absoluteID))) {
                this.realizeField(fieldDesc);
            }
        }
        catch (JDOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(500, "sqlstore.exception.log", e);
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.getfieldfailed"), e);
        }
        finally {
            if (acquireShareLock) {
                this.persistenceManager.releaseShareLock();
            }
            this.releaseLock();
            if (debug) {
                logger.finest("sqlstore.sqlstatemanager.preparegetfield.exit");
            }
        }
    }

    private void realizeField(FieldDesc fieldDesc) {
        assert (fieldDesc != null);
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.realizefield", fieldDesc.getName());
        }
        if (!this.persistenceConfig.isNavigable()) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.notnavigable", fieldDesc.getName(), this.persistentObject.getClass().getName()));
        }
        boolean fieldRealized = false;
        if (fieldDesc instanceof ForeignFieldDesc) {
            ForeignFieldDesc ff = (ForeignFieldDesc)fieldDesc;
            if (ff.fetchGroup <= 0 && this.persistenceConfig.getFetchGroup(ff.fetchGroup).size() <= 1 && !ff.useJoinTable()) {
                fieldRealized = this.realizeForeignField(ff);
            }
        }
        if (!fieldRealized) {
            this.retrieve(fieldDesc);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.realizefield.exit");
        }
    }

    private boolean realizeForeignField(ForeignFieldDesc foreignField) {
        assert (foreignField != null);
        boolean isPresent = false;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.realizeforeignfield", foreignField.getName());
        }
        for (int i = 0; i < foreignField.localFields.size(); ++i) {
            LocalFieldDesc lf = (LocalFieldDesc)foreignField.localFields.get(i);
            isPresent = this.getPresenceMaskBit(lf.absoluteID);
            if (!isPresent) break;
        }
        if (isPresent) {
            this.populateForeignField(foreignField);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.realizeforeignfield.exit", isPresent);
        }
        return isPresent;
    }

    private void populateForeignField(ForeignFieldDesc foreignField) {
        Object pc;
        assert (foreignField != null);
        boolean foundInstance = false;
        if (foreignField.hasForeignKey() && foreignField.isMappedToPk() && (foundInstance = (pc = this.getObjectById(foreignField, null, null, true)) != null)) {
            foreignField.setValue(this, pc);
        }
        if (!foundInstance) {
            Collection result = this.retrieveForeign(foreignField);
            this.attachQueryResult(foreignField, result);
        }
        this.setPresenceMaskBit(foreignField.absoluteID);
    }

    private void attachQueryResult(ForeignFieldDesc foreignField, Collection queryResult) {
        assert (foreignField != null);
        if (foreignField.getComponentType() != null) {
            this.replaceCollection(foreignField, queryResult);
        } else if (queryResult == null || queryResult.size() == 0) {
            foreignField.setValue(this, null);
        } else {
            if (queryResult.size() > 1) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.persistencestore.toomanyobjforcard1", this.persistenceConfig.getName(), foreignField.getName(), "" + queryResult.size()));
            }
            Object v = queryResult.iterator().next();
            foreignField.setValue(this, v);
        }
    }

    private Collection retrieveForeign(ForeignFieldDesc foreignField) {
        assert (foreignField != null);
        Collection result = null;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.retrieveforeign", foreignField.getName());
        }
        Object[] values = new Object[foreignField.localFields.size()];
        boolean isValidForeignKey = true;
        for (int i = 0; i < foreignField.localFields.size(); ++i) {
            FieldDesc flf = (FieldDesc)foreignField.localFields.get(i);
            if (!this.getPresenceMaskBit(i)) {
                // empty if block
            }
            values[i] = this.getSetMaskBit(flf.absoluteID) ? flf.getValue(this.beforeImage) : flf.getValue(this);
            if (values[i] != null) continue;
            isValidForeignKey = false;
        }
        if (isValidForeignKey) {
            RetrieveDesc fdesc = this.persistenceConfig.getRetrieveDescForFKQuery(foreignField, this.store);
            result = (Collection)this.store.retrieve(this.persistenceManager, fdesc, new QueryValueFetcher(values));
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.retrieveforeign.exit");
        }
        return result;
    }

    private void retrieve(FieldDesc additionalField) {
        boolean debug = logger.isLoggable();
        if (debug) {
            String fieldName = additionalField != null ? additionalField.getName() : null;
            logger.fine("sqlstore.sqlstatemanager.retrieve", fieldName);
        }
        LocalFieldDesc[] keyFields = this.persistenceConfig.getKeyFieldDescs();
        Object[] values = new Object[keyFields.length];
        this.copyValues(values, keyFields, 0);
        RetrieveDesc rd = this.persistenceConfig.getRetrieveDescForPKQuery(additionalField, this.store);
        Collection result = (Collection)this.store.retrieve(this.persistenceManager, rd, new QueryValueFetcher(values));
        if (result.size() > 1) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.toomanyrows", this.persistenceConfig.getPersistenceCapableClass().getName()));
        }
        if (result.size() < 1 || result.iterator().next() != this.persistentObject) {
            throw new JDOObjectNotFoundException(I18NHelper.getMessage(messages, "core.statemanager.objectnotfound"), new Object[]{this.persistentObject});
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.retrieve.exit");
        }
    }

    private void copyValues(Object[] values, LocalFieldDesc[] fields, int startIndex) {
        assert (values.length - startIndex >= fields.length);
        for (int i = 0; i < fields.length; ++i) {
            LocalFieldDesc field = fields[i];
            values[i + startIndex] = field.getValue(this);
            assert (values[i + startIndex] != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStateManager getBeforeImage() {
        if (this.beforeImage == null && this.isBeforeImageRequired()) {
            boolean debug = logger.isLoggable();
            if (debug) {
                logger.fine("sqlstore.sqlstatemanager.getbeforeimage", this.persistenceConfig.getPersistenceCapableClass().getName());
            }
            try {
                this.getLock();
                this.beforeImage = this.copyPersistent();
            }
            finally {
                this.releaseLock();
            }
            if (debug) {
                logger.fine("sqlstore.sqlstatemanager.getbeforeimage.exit");
            }
        }
        return this.beforeImage;
    }

    public boolean isBeforeImageRequired() {
        boolean isBeforeImageRequired;
        Transaction t = this.persistenceManager.currentTransaction();
        boolean bl = isBeforeImageRequired = this.persistenceManager.isOptimisticTransaction() || this.getUpdateDesc().hasChangedRelationships() || t.getRetainValues() || t.getRestoreValues() || this.persistenceConfig.hasModifiedCheckAtCommitConsistency();
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sqlstatemanager.isbeforeimagerequired", isBeforeImageRequired);
        }
        return isBeforeImageRequired;
    }

    private SQLStateManager copyPersistent() {
        PersistenceManager pm = (PersistenceManager)this.getPersistenceManagerInternal();
        SQLStateManager newStateManager = (SQLStateManager)this.clone();
        pm.newInstance(newStateManager);
        newStateManager.copyFields(this, true, true);
        return newStateManager;
    }

    public void copyFields(StateManager source) {
        if (!(source instanceof SQLStateManager)) {
            String className = source != null ? source.getClass().getName() : null;
            throw new IllegalArgumentException(className);
        }
        SQLStateManager sqlSource = (SQLStateManager)source;
        if (this.persistenceConfig != sqlSource.getPersistenceConfig()) {
            Class thisPCClass = this.persistenceConfig.getPersistenceCapableClass();
            Class sourcePCClass = sqlSource.getPersistenceConfig().getPersistenceCapableClass();
            throw new IllegalArgumentException(I18NHelper.getMessage(messages, "core.statemanager.copyFields.mismatch", thisPCClass.getName(), sourcePCClass.getName()));
        }
        this.copyFields(sqlSource, false, true);
    }

    private void copyFields(SQLStateManager source, boolean copyRelationships, boolean clone) {
        ArrayList fields = null;
        this.clearMask(0);
        this.clearMask(1);
        for (int i = 0; i < 2; ++i) {
            fields = i == 0 ? this.persistenceConfig.fields : this.persistenceConfig.hiddenFields;
            for (int j = 0; fields != null && j < fields.size(); ++j) {
                FieldDesc f = (FieldDesc)fields.get(j);
                if (!copyRelationships && f.isRelationshipField() || !source.getPresenceMaskBit(f.absoluteID)) continue;
                Object value = f.getValue(source);
                f.setValue(this, clone ? this.cloneObjectMaybe(value) : value);
                this.setPresenceMaskBit(f.absoluteID);
            }
        }
    }

    private Object cloneObjectMaybe(Object source) {
        block11: {
            if (source != null) {
                if (source instanceof SCO) {
                    return ((SCO)source).cloneInternal();
                }
                if (!(source instanceof Number || source instanceof String || source instanceof Character || source instanceof Boolean || source instanceof com.sun.jdo.api.persistence.support.PersistenceCapable || source instanceof byte[])) {
                    try {
                        Class<?> type = source.getClass();
                        if (!type.isArray()) {
                            Method m = type.getMethod("clone", null);
                            if (m != null) {
                                return m.invoke(source, (Object[])null);
                            }
                            break block11;
                        }
                        Object[] srcArray = (Object[])source;
                        Object[] dstArray = (Object[])Array.newInstance(type.getComponentType(), srcArray.length);
                        for (int i = 0; i < srcArray.length; ++i) {
                            dstArray[i] = srcArray[i];
                        }
                        return dstArray;
                    }
                    catch (NoSuchMethodException e) {
                        if (logger.isLoggable()) {
                            Object[] items = new Object[]{e, source.getClass().getName()};
                            logger.fine("sqlstore.sqlstatemanager.nosuchmethodexcep.clone", items);
                        }
                    }
                    catch (InvocationTargetException e) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
        return source;
    }

    private void prepareUpdateField(FieldDesc fieldDesc, ArrayList newlyRegisteredSMs) {
        if (fieldDesc.isKeyField()) {
            return;
        }
        this.getUpdateDesc().markRelationshipChange(fieldDesc);
        boolean debug = logger.isLoggable();
        if (debug) {
            Object[] items = new Object[]{fieldDesc.getName(), this.state};
            logger.fine("sqlstore.sqlstatemanager.prepareupdatefield", items);
        }
        boolean optimistic = this.persistenceManager.isOptimisticTransaction();
        boolean xactActive = this.persistenceManager.isActiveTransaction();
        boolean nontransactionalRead = this.persistenceManager.isNontransactionalRead();
        if (this.state.needsReload(optimistic, nontransactionalRead, xactActive)) {
            this.reload(fieldDesc);
        }
        LifeCycleState oldstate = this.state;
        this.state = this.state.transitionWriteField(xactActive);
        this.registerInstance(false, newlyRegisteredSMs, oldstate);
        if (this.state == oldstate && this.getSetMaskBit(fieldDesc.absoluteID) && this.getPresenceMaskBit(fieldDesc.absoluteID)) {
            return;
        }
        if (this.state.isBeforeImageUpdatable()) {
            if (!this.getPresenceMaskBit(fieldDesc.absoluteID)) {
                this.prepareGetField(fieldDesc);
            }
            this.updateBeforeImage(fieldDesc, null);
        }
        this.recordUpdatedField(fieldDesc);
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.prepareupdatefield.exit");
        }
    }

    private void updateBeforeImage(FieldDesc fieldDesc, Object value) {
        this.getBeforeImage();
        if (this.beforeImage != null && !this.beforeImage.getPresenceMaskBit(fieldDesc.absoluteID) && (fieldDesc.sqlProperties & 2) > 0) {
            if (value == null) {
                value = fieldDesc.getValue(this);
            }
            if (value != null) {
                if (logger.isLoggable(300)) {
                    Object[] items = new Object[]{fieldDesc, value};
                    logger.finest("sqlstore.sqlstatemanager.updatebeforeimage", items);
                }
                fieldDesc.setValue(this.beforeImage, this.cloneObjectMaybe(value));
                this.beforeImage.setPresenceMaskBit(fieldDesc.absoluteID);
            }
        }
    }

    private void recordUpdatedField(FieldDesc fieldDesc) {
        boolean debug = logger.isLoggable(300);
        if (!fieldDesc.isRelationshipField() && (fieldDesc.sqlProperties & 8) > 0) {
            if (debug) {
                logger.finest("sqlstore.sqlstatemanager.recordingfield", fieldDesc);
            }
            this.getUpdateDesc().recordUpdatedField((LocalFieldDesc)fieldDesc);
        }
        if (debug) {
            logger.finest("sqlstore.sqlstatemanager.makedirtyfield", fieldDesc);
        }
        this.setSetMaskBit(fieldDesc.absoluteID);
    }

    public void addDependency(StateManager sm) {
        if (logger.isLoggable()) {
            Object[] items = new Object[]{this, sm};
            logger.fine("sqlstore.sqlstatemanager.adddependency", items);
        }
        SQLStateManager other = (SQLStateManager)sm;
        if (!this.state.isNew() || !this.state.isDeleted()) {
            this.addUpdatedForeignReference(null, other);
        } else if ((other.stateFlags & 2) == 0) {
            this.persistenceManager.registerInstance(other, other.getObjectId(), false, true);
            other.stateFlags = (short)(other.stateFlags | 2);
        }
    }

    public void resolveDependencies() {
        if (logger.isLoggable()) {
            logger.fine("sqlstore.sqlstatemanager.resolvedependencies", this.getPersistent());
        }
        if (this.updatedForeignReferences != null) {
            Iterator iter = this.updatedForeignReferences.iterator();
            while (iter.hasNext()) {
                SQLStateManager foreignSM;
                UpdatedForeignReference ufr = (UpdatedForeignReference)iter.next();
                ForeignFieldDesc fieldDesc = ufr.getFieldDesc();
                if (!this.resolveDependency(fieldDesc, foreignSM = ufr.getStateManager())) continue;
                foreignSM.removeDependency();
                iter.remove();
            }
        }
    }

    private boolean resolveDependency(ForeignFieldDesc fieldDesc, SQLStateManager foreignSM) {
        boolean removeDependency = false;
        Object pc = foreignSM.getPersistent();
        if (!this.state.isPersistentInDataStore()) {
            if (this.state.getUpdateAction() != 1) {
                removeDependency = true;
            } else if (!SQLStateManager.checkRelationship(this, fieldDesc, pc)) {
                removeDependency = true;
            }
        } else if (fieldDesc != null) {
            if (foreignSM.state.getUpdateAction() != 2) {
                removeDependency = true;
            } else if (fieldDesc.cardinalityUPB <= 1 && !SQLStateManager.checkRelationship(this.beforeImage, fieldDesc, pc)) {
                removeDependency = true;
            }
        }
        if (removeDependency && logger.isLoggable()) {
            Object[] items = new Object[]{this.getPersistent(), fieldDesc.getName(), pc};
            logger.fine("sqlstore.sqlstatemanager.resolvedependency", items);
        }
        return removeDependency;
    }

    private void removeDependency() {
        if (--this.referenceCount == 0) {
            this.stateFlags = (short)(this.stateFlags & 0xFFFFFFFE);
        }
    }

    private static boolean checkRelationship(SQLStateManager sm, ForeignFieldDesc fieldDesc, Object pc) {
        boolean related = false;
        if (fieldDesc != null && sm != null && sm.getPresenceMaskBit(fieldDesc.absoluteID)) {
            if (fieldDesc.cardinalityUPB > 1) {
                Collection c = sm.getCollectionValue(fieldDesc);
                related = c.contains(pc);
            } else {
                related = fieldDesc.getValue(sm) == pc;
            }
        }
        return related;
    }

    private void registerRemoveDependency(ForeignFieldDesc fieldDesc, SQLStateManager removedSM) {
        if (this.state.isPersistentInDataStore() && removedSM.state.isPersistentInDataStore()) {
            this.addUpdatedForeignReference(fieldDesc, removedSM);
        }
    }

    private void registerCreateDependency(ForeignFieldDesc inverseFieldDesc, SQLStateManager addedSM) {
        if (!addedSM.state.isPersistentInDataStore()) {
            addedSM.addUpdatedForeignReference(inverseFieldDesc, this);
        }
    }

    private void addUpdatedForeignReference(ForeignFieldDesc fieldDesc, SQLStateManager sm) {
        if (sm == this) {
            return;
        }
        if (this.updatedForeignReferences == null) {
            this.updatedForeignReferences = new HashSet();
            if ((this.stateFlags & 2) == 0) {
                this.persistenceManager.registerInstance(this, this.getObjectId(), false, true);
                this.stateFlags = (short)(this.stateFlags | 2);
            }
        }
        if (this.updatedForeignReferences.add(new UpdatedForeignReference(fieldDesc, sm))) {
            sm.stateFlags = (short)(sm.stateFlags | 1);
            ++sm.referenceCount;
            if (logger.isLoggable()) {
                String fieldName = fieldDesc != null ? fieldDesc.getName() : null;
                Object[] items = new Object[]{this.persistentObject, fieldName, sm.persistentObject, new Integer(sm.referenceCount)};
                logger.fine("sqlstore.sqlstatemanager.addupdate", items);
            }
            if ((sm.stateFlags & 2) == 0) {
                this.persistenceManager.registerInstance(sm, sm.getObjectId(), false, true);
                sm.stateFlags = (short)(sm.stateFlags | 2);
            }
        }
    }

    private void removeUpdatedForeignReference(ForeignFieldDesc fieldDesc, SQLStateManager sm) {
        if (this.updatedForeignReferences == null || this.updatedForeignReferences.size() == 0) {
            return;
        }
        if (this.updatedForeignReferences.remove(new UpdatedForeignReference(fieldDesc, sm))) {
            --sm.referenceCount;
            if (logger.isLoggable()) {
                String fieldName = fieldDesc != null ? fieldDesc.getName() : null;
                Object[] items = new Object[]{this.persistentObject, fieldName, sm.persistentObject, new Integer(sm.referenceCount)};
                logger.fine("sqlstore.sqlstatemanager.removeupdate", items);
            }
            if (sm.referenceCount == 0) {
                sm.stateFlags = (short)(sm.stateFlags & 0xFFFFFFFE);
            }
        }
    }

    private boolean updateObjectField(ForeignFieldDesc fieldDesc, Object addedObject, boolean updateInverseRelationshipField, boolean managedRelationshipInProgress) {
        Object removedObject;
        boolean debug = logger.isLoggable();
        if (debug) {
            Object[] items = new Object[]{fieldDesc.getName(), fieldDesc.getComponentType()};
            logger.fine("sqlstore.sqlstatemanager.updateobjfield", items);
        }
        if (addedObject != (removedObject = fieldDesc.getValue(this))) {
            SQLStateManager addedSM = this.getAddedSM(addedObject, null);
            SQLStateManager removedSM = this.getRemovedSM(removedObject);
            SQLStateManager addedInverseFieldSM = null;
            if (addedSM != null && addedSM.isDeleted()) {
                JDOUserException ex = new JDOUserException(I18NHelper.getMessage(messages, "jdo.lifecycle.deleted.accessField"));
                ex.addFailedObject(addedObject);
                throw ex;
            }
            ForeignFieldDesc inverseFieldDesc = fieldDesc.getInverseRelationshipField();
            this.updateRelationshipInDataStore(fieldDesc, addedSM, removedSM, inverseFieldDesc, managedRelationshipInProgress);
            if (updateInverseRelationshipField && inverseFieldDesc != null) {
                addedInverseFieldSM = this.manageRelationshipForObjectField(inverseFieldDesc, addedSM, removedSM, managedRelationshipInProgress);
            }
            this.manageDependencyForObjectField(fieldDesc, addedSM, removedSM, addedInverseFieldSM);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.updateobjfield.exit");
        }
        return true;
    }

    private void updateRelationshipInDataStore(ForeignFieldDesc fieldDesc, SQLStateManager addedSM, SQLStateManager removedSM, ForeignFieldDesc inverseFieldDesc, boolean managedRelationshipInProgress) {
        if (!fieldDesc.useJoinTable()) {
            this.processForeignKeys(fieldDesc, addedSM, removedSM, inverseFieldDesc, managedRelationshipInProgress);
        } else {
            this.processJoinTableEntries(fieldDesc, addedSM, removedSM, inverseFieldDesc, managedRelationshipInProgress);
        }
    }

    private void processForeignKeys(ForeignFieldDesc fieldDesc, SQLStateManager addedSM, SQLStateManager removedSM, ForeignFieldDesc inverseFieldDesc, boolean managedRelationshipInProgress) {
        boolean updateOtherSide;
        boolean bl = updateOtherSide = (fieldDesc.sqlProperties & 0x10) == 0;
        if (updateOtherSide) {
            if (removedSM != null) {
                removedSM.nullifyForeignKey(inverseFieldDesc, this, fieldDesc, false);
            }
            if (addedSM != null && !managedRelationshipInProgress) {
                addedSM.setForeignKey(inverseFieldDesc, this, fieldDesc);
            }
        } else {
            if (removedSM != null) {
                this.nullifyForeignKey(fieldDesc, removedSM, inverseFieldDesc, addedSM != null);
            }
            if (addedSM != null && !managedRelationshipInProgress) {
                this.setForeignKey(fieldDesc, addedSM, inverseFieldDesc);
            }
        }
    }

    private void processJoinTableEntries(ForeignFieldDesc fieldDesc, SQLStateManager addedSM, SQLStateManager removedSM, ForeignFieldDesc inverseFieldDesc, boolean managedRelationshipInProgress) {
        boolean updateOtherSide;
        boolean bl = updateOtherSide = (fieldDesc.sqlProperties & 0x10) == 0;
        if (updateOtherSide) {
            if (removedSM != null) {
                removedSM.removeJoinTableEntry(inverseFieldDesc, this, fieldDesc);
            }
            if (addedSM != null && !managedRelationshipInProgress) {
                addedSM.addJoinTableEntry(inverseFieldDesc, this, fieldDesc);
            }
        } else {
            if (removedSM != null) {
                this.removeJoinTableEntry(fieldDesc, removedSM, inverseFieldDesc);
            }
            if (addedSM != null && !managedRelationshipInProgress) {
                this.addJoinTableEntry(fieldDesc, addedSM, inverseFieldDesc);
            }
        }
    }

    private SQLStateManager manageRelationshipForObjectField(ForeignFieldDesc inverseFieldDesc, SQLStateManager addedSM, SQLStateManager removedSM, boolean managedRelationshipInProgress) {
        Object addedInverseFieldValue = null;
        SQLStateManager addedInverseFieldSM = null;
        if (removedSM != null) {
            removedSM.removeRelationship(inverseFieldDesc, this);
        }
        if (addedSM != null && !managedRelationshipInProgress && (addedInverseFieldValue = addedSM.addRelationship(inverseFieldDesc, this)) != null) {
            addedInverseFieldSM = (SQLStateManager)this.persistenceManager.getStateManager(addedInverseFieldValue);
        }
        return addedInverseFieldSM;
    }

    private void manageDependencyForObjectField(ForeignFieldDesc fieldDesc, SQLStateManager addedSM, SQLStateManager removedSM, SQLStateManager addedInverseFieldSM) {
        boolean updateOtherSide;
        boolean bl = updateOtherSide = (fieldDesc.sqlProperties & 0x10) == 0;
        if (updateOtherSide && removedSM != null && addedSM != null && removedSM.state.isPersistentInDataStore() && this.state.isPersistentInDataStore()) {
            removedSM.addUpdatedForeignReference(null, addedSM);
        }
        if (!updateOtherSide && addedInverseFieldSM != null && addedInverseFieldSM.state.isPersistentInDataStore() && addedSM.state.isPersistentInDataStore()) {
            addedInverseFieldSM.addUpdatedForeignReference(null, this);
        }
    }

    private SQLStateManager getAddedSM(Object addedObject, ArrayList newlyRegisteredSMs) {
        SQLStateManager addedSM = null;
        if (addedObject != null && (addedSM = (SQLStateManager)this.persistenceManager.getStateManager(addedObject)) == null) {
            this.makeAutoPersistent(addedObject);
            addedSM = (SQLStateManager)this.persistenceManager.getStateManager(addedObject);
            if (newlyRegisteredSMs != null && !newlyRegisteredSMs.contains(addedSM)) {
                newlyRegisteredSMs.add(addedSM);
            }
        }
        return addedSM;
    }

    private SQLStateManager getRemovedSM(Object removedObject) {
        SQLStateManager removedSM = null;
        if (removedObject != null) {
            removedSM = (SQLStateManager)this.persistenceManager.getStateManager(removedObject);
        }
        return removedSM;
    }

    private void processCollectionUpdates(ForeignFieldDesc fieldDesc, ArrayList removedList, ArrayList addedList, ArrayList newlyRegisteredSMs, boolean updateInverseRelationshipField, boolean managedRelationshipInProgress) {
        boolean debug = logger.isLoggable();
        ForeignFieldDesc inverseFieldDesc = fieldDesc.getInverseRelationshipField();
        if (debug) {
            Object[] items = new Object[]{removedList, addedList};
            logger.fine("sqlstore.sqlstatemanager.processcollectionupdate", items);
        }
        if (removedList != null) {
            this.removeCollectionRelationship(fieldDesc, removedList, inverseFieldDesc, updateInverseRelationshipField, managedRelationshipInProgress);
        }
        if (addedList != null) {
            this.addCollectionRelationship(fieldDesc, addedList, inverseFieldDesc, newlyRegisteredSMs, updateInverseRelationshipField, managedRelationshipInProgress);
        }
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.processcollectionupdate.exit");
        }
    }

    private void removeCollectionRelationship(ForeignFieldDesc fieldDesc, ArrayList removedList, ForeignFieldDesc inverseFieldDesc, boolean updateInverseRelationshipField, boolean managedRelationshipInProgress) {
        for (int i = 0; i < removedList.size(); ++i) {
            SQLStateManager removedSM = this.getRemovedSM(removedList.get(i));
            if (removedSM == null || managedRelationshipInProgress) continue;
            this.updateRelationshipInDataStore(fieldDesc, null, removedSM, inverseFieldDesc, false);
            if (!updateInverseRelationshipField || inverseFieldDesc == null) continue;
            removedSM.removeRelationship(inverseFieldDesc, this);
        }
    }

    private void nullifyForeignKey(ForeignFieldDesc fieldDesc, SQLStateManager removedSM, ForeignFieldDesc inverseFieldDesc, boolean setDependencyOnly) {
        if (!this.isDeleted() && !setDependencyOnly) {
            if (fieldDesc != null) {
                for (int i = 0; i < fieldDesc.localFields.size(); ++i) {
                    LocalFieldDesc la = (LocalFieldDesc)fieldDesc.localFields.get(i);
                    this.nullifyForeignKey(fieldDesc, la);
                }
            } else {
                for (int i = 0; i < inverseFieldDesc.foreignFields.size(); ++i) {
                    LocalFieldDesc la = (LocalFieldDesc)inverseFieldDesc.foreignFields.get(i);
                    this.nullifyForeignKey(fieldDesc, la);
                }
            }
        }
        this.registerRemoveDependency(fieldDesc, removedSM);
    }

    private void nullifyForeignKey(ForeignFieldDesc fieldDesc, LocalFieldDesc la) {
        if (!this.getSetMaskBit(la.absoluteID)) {
            this.prepareUpdateField(la, null);
        }
        JDOUserException pkUpdateEx = null;
        if (la.isKeyField()) {
            try {
                this.assertPKUpdate(la, null);
            }
            catch (JDOUserException e) {
                if ((this.stateFlags & 0x20) == 0) {
                    throw e;
                }
                pkUpdateEx = e;
            }
        }
        if (pkUpdateEx == null) {
            this.updateTrackedFields(la, null, fieldDesc);
            la.setValue(this, null);
        }
    }

    private void removeJoinTableEntry(ForeignFieldDesc fieldDesc, SQLStateManager removedSM, ForeignFieldDesc inverseFieldDesc) {
        if (removedSM.state.isAutoPersistent() || this.state.isAutoPersistent()) {
            removedSM.removeUpdatedForeignReference(inverseFieldDesc, this);
            this.removeUpdatedForeignReference(fieldDesc, removedSM);
        }
        if (fieldDesc != null && !this.getUpdateDesc().removeUpdatedJoinTableRelationship(fieldDesc, removedSM, 1)) {
            if (inverseFieldDesc == null || !removedSM.getUpdateDesc().removeUpdatedJoinTableRelationship(inverseFieldDesc, this, 1)) {
                this.getUpdateDesc().recordUpdatedJoinTableRelationship(fieldDesc, this, removedSM, 2);
                this.registerRemoveDependency(fieldDesc, removedSM);
            }
        } else if (fieldDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantschedulejointable", this.getPersistenceConfig().getPersistenceCapableClass().getName(), removedSM.getPersistenceConfig().getPersistenceCapableClass().getName()));
        }
    }

    private void removeRelationship(ForeignFieldDesc fieldDesc, SQLStateManager removedSM) {
        boolean isCollection;
        boolean bl = isCollection = fieldDesc.cardinalityUPB > 1;
        if (!isCollection) {
            this.prepareUpdateFieldSpecial(fieldDesc, removedSM.persistentObject, false);
            this.updateTrackedFields(fieldDesc, null, null);
            fieldDesc.setValue(this, null);
        } else {
            try {
                this.prepareUpdateFieldSpecial(fieldDesc, null, true);
                SCOCollection c = (SCOCollection)fieldDesc.getValue(this);
                c.removeInternal(removedSM.persistentObject);
                this.updateTrackedFields(fieldDesc, c, null);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
    }

    private void addCollectionRelationship(ForeignFieldDesc fieldDesc, ArrayList addedList, ForeignFieldDesc inverseFieldDesc, ArrayList newlyRegisteredSMs, boolean updateInverseRelationshipField, boolean managedRelationshipInProgress) {
        JDOException ex = null;
        for (int i = 0; i < addedList.size(); ++i) {
            Object addedObject = addedList.get(i);
            SQLStateManager addedSM = this.getAddedSM(addedObject, newlyRegisteredSMs);
            if (addedSM == null) continue;
            if (addedSM.isDeleted()) {
                if (inverseFieldDesc == null) continue;
                if (ex == null) {
                    ex = new JDOUserException(I18NHelper.getMessage(messages, "jdo.lifecycle.deleted.accessField"));
                }
                ex.addFailedObject(addedObject);
                continue;
            }
            if (managedRelationshipInProgress) continue;
            this.updateRelationshipInDataStore(fieldDesc, addedSM, null, inverseFieldDesc, false);
            if (!updateInverseRelationshipField || inverseFieldDesc == null) continue;
            addedSM.addRelationship(inverseFieldDesc, this);
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void setForeignKey(ForeignFieldDesc fieldDesc, SQLStateManager addedSM, ForeignFieldDesc inverseFieldDesc) {
        if (!this.isDeleted()) {
            if (fieldDesc != null) {
                for (int i = 0; i < fieldDesc.localFields.size(); ++i) {
                    LocalFieldDesc la = (LocalFieldDesc)fieldDesc.localFields.get(i);
                    LocalFieldDesc fa = (LocalFieldDesc)fieldDesc.foreignFields.get(i);
                    this.setForeignKey(fieldDesc, la, fa.getValue(addedSM));
                }
            } else {
                for (int i = 0; i < inverseFieldDesc.foreignFields.size(); ++i) {
                    LocalFieldDesc la = (LocalFieldDesc)inverseFieldDesc.foreignFields.get(i);
                    LocalFieldDesc fa = (LocalFieldDesc)inverseFieldDesc.localFields.get(i);
                    this.setForeignKey(fieldDesc, la, fa.getValue(addedSM));
                }
            }
        }
        this.registerCreateDependency(inverseFieldDesc, addedSM);
    }

    private void setForeignKey(ForeignFieldDesc fieldDesc, LocalFieldDesc la, Object faValue) {
        if (!this.getSetMaskBit(la.absoluteID)) {
            this.prepareUpdateField(la, null);
        }
        if (la.isKeyField()) {
            this.assertPKUpdate(la, faValue);
        }
        this.updateTrackedFields(la, faValue, fieldDesc);
        la.setValue(this, faValue);
    }

    private void addJoinTableEntry(ForeignFieldDesc fieldDesc, SQLStateManager addedSM, ForeignFieldDesc inverseFieldDesc) {
        if (fieldDesc != null && !this.getUpdateDesc().removeUpdatedJoinTableRelationship(fieldDesc, addedSM, 2)) {
            if (inverseFieldDesc == null || !addedSM.getUpdateDesc().removeUpdatedJoinTableRelationship(inverseFieldDesc, this, 2)) {
                this.getUpdateDesc().recordUpdatedJoinTableRelationship(fieldDesc, this, addedSM, 1);
                this.registerCreateDependency(inverseFieldDesc, addedSM);
            }
        } else if (fieldDesc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.cantschedulejointable", this.getPersistenceConfig().getPersistenceCapableClass().getName(), addedSM.getPersistenceConfig().getPersistenceCapableClass().getName()));
        }
    }

    private Object addRelationship(ForeignFieldDesc fieldDesc, SQLStateManager addedSM) {
        boolean isCollection;
        Object previousValue = null;
        boolean bl = isCollection = fieldDesc.cardinalityUPB > 1;
        if (!isCollection) {
            previousValue = this.prepareSetField(fieldDesc, addedSM.persistentObject, true);
        } else {
            try {
                this.prepareUpdateFieldSpecial(fieldDesc, null, true);
                SCOCollection c = (SCOCollection)fieldDesc.getValue(this);
                if (c == null) {
                    this.replaceCollection(fieldDesc, null);
                    c = (SCOCollection)fieldDesc.getValue(this);
                }
                c.addInternal(addedSM.persistentObject);
                this.updateTrackedFields(fieldDesc, c, null);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return previousValue;
    }

    private synchronized void prepareUpdateFieldSpecial(FieldDesc fieldDesc, Object beforeImageValue, boolean createDeferredCollection) {
        if (fieldDesc.isKeyField()) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.statemanager.nopkupdate"));
        }
        this.getUpdateDesc().markRelationshipChange(fieldDesc);
        boolean debug = logger.isLoggable();
        if (debug) {
            Object[] items = new Object[]{fieldDesc.getName(), this.state};
            logger.fine("sqlstore.sqlstatemanager.prepareupdatefieldspl", items);
        }
        boolean optimistic = this.persistenceManager.isOptimisticTransaction();
        boolean xactActive = this.persistenceManager.isActiveTransaction();
        boolean nontransactionalRead = this.persistenceManager.isNontransactionalRead();
        if (this.state.needsReload(optimistic, nontransactionalRead, xactActive)) {
            if (!optimistic) {
                this.persistenceManager.clearFields(this.persistentObject);
            }
            this.reload(null);
        }
        LifeCycleState oldstate = this.state;
        this.state = this.state.transitionWriteField(xactActive);
        this.registerInstance(false, null, oldstate);
        if (this.getSetMaskBit(fieldDesc.absoluteID)) {
            return;
        }
        if (!this.getPresenceMaskBit(fieldDesc.absoluteID)) {
            if (!createDeferredCollection) {
                if (!(beforeImageValue instanceof SCOCollection) || !((SCOCollection)beforeImageValue).isDeferred()) {
                    this.updateBeforeImage(fieldDesc, beforeImageValue);
                    this.setPresenceMaskBit(fieldDesc.absoluteID);
                }
            } else {
                if (!(fieldDesc instanceof ForeignFieldDesc) || ((ForeignFieldDesc)fieldDesc).cardinalityUPB <= 1) {
                    return;
                }
                Object value = fieldDesc.getValue(this);
                if (value == null) {
                    SCOCollection c = (SCOCollection)this.persistenceManager.newCollectionInstanceInternal(fieldDesc.getType(), this.persistentObject, fieldDesc.getName(), fieldDesc.getComponentType(), false, 10);
                    c.markDeferred();
                    fieldDesc.setValue(this, c);
                }
            }
        }
        this.recordUpdatedField(fieldDesc);
        if (debug) {
            logger.fine("sqlstore.sqlstatemanager.prepareupdatefieldspl.exit");
        }
    }

    private void updateTrackedFields(FieldDesc fieldDesc, Object value, ForeignFieldDesc fieldToIgnore) {
        ArrayList fieldsToIgnore;
        ArrayList trackedFields = fieldDesc.getTrackedFields();
        if (trackedFields == null) {
            return;
        }
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{fieldDesc.getName(), value, fieldToIgnore != null ? fieldToIgnore.getName() : null};
            logger.finest("sqlstore.sqlstatemanager.updatetrackedfields", items);
        }
        Object currentValue = fieldDesc.getValue(this);
        int size = trackedFields.size();
        ArrayList arrayList = fieldsToIgnore = fieldToIgnore != null ? fieldToIgnore.getTrackedFields() : null;
        if (fieldDesc instanceof ForeignFieldDesc) {
            for (int i = 0; i < size; ++i) {
                ForeignFieldDesc tf = (ForeignFieldDesc)trackedFields.get(i);
                this.prepareUpdateFieldSpecial(tf, currentValue, false);
                tf.setValue(this, value);
            }
        } else {
            Object[] previousValues = new Object[size];
            LocalFieldDesc primaryTrackedField = null;
            Object primaryTrackedFieldValue = null;
            if ((fieldDesc.sqlProperties & 0x20) > 0) {
                primaryTrackedField = (LocalFieldDesc)fieldDesc;
                primaryTrackedFieldValue = value;
            }
            for (int i = 0; i < size; ++i) {
                FieldDesc tf = (FieldDesc)trackedFields.get(i);
                if (tf instanceof LocalFieldDesc) {
                    Object convertedValue = null;
                    Object convertedCurrentValue = null;
                    try {
                        convertedValue = tf.convertValue(value, this);
                        convertedCurrentValue = tf.convertValue(currentValue, this);
                    }
                    catch (JDOUserException e) {
                        for (int j = 0; j < i; ++j) {
                            tf = (FieldDesc)trackedFields.get(j);
                            tf.setValue(this, previousValues[j]);
                        }
                        throw e;
                    }
                    if ((tf.sqlProperties & 0x20) > 0) {
                        primaryTrackedField = (LocalFieldDesc)tf;
                        primaryTrackedFieldValue = convertedValue;
                    }
                    this.prepareUpdateFieldSpecial(tf, convertedCurrentValue, false);
                    previousValues[i] = tf.getValue(this);
                    tf.setValue(this, convertedValue);
                    continue;
                }
                if ((this.stateFlags & 0x10) > 0 || tf == fieldToIgnore || fieldsToIgnore != null && fieldsToIgnore.contains(tf)) continue;
                ForeignFieldDesc ftf = (ForeignFieldDesc)tf;
                Object pc = null;
                if (primaryTrackedFieldValue != null) {
                    pc = this.getObjectById(ftf, primaryTrackedField, primaryTrackedFieldValue, false);
                }
                this.stateFlags = (short)(this.stateFlags | 0x10);
                this.prepareSetField(ftf, pc);
                this.stateFlags = (short)(this.stateFlags & 0xFFFFFFEF);
            }
        }
        if (debug) {
            logger.finest("sqlstore.sqlstatemanager.updatetrackedfields.exit");
        }
    }

    private Object getObjectById(ForeignFieldDesc ff, LocalFieldDesc updatedField, Object value, boolean forNavigation) {
        assert (ff.cardinalityUPB <= 1);
        assert (!forNavigation || updatedField == null && value == null);
        Object rc = null;
        Object oid = ff.createObjectId(this, updatedField, value);
        if (oid != null) {
            rc = this.persistenceManager.getObjectById(oid);
            LifeCycleState rcState = ((SQLStateManager)((PersistenceCapable)rc).jdoGetStateManager()).state;
            if (forNavigation && rcState instanceof Hollow) {
                rc = null;
            }
        }
        return rc;
    }

    private Object doUpdateField(FieldDesc fieldDesc, Object value, boolean managedRelationshipInProgress) {
        this.prepareUpdateField(fieldDesc, null);
        if (fieldDesc instanceof ForeignFieldDesc) {
            ForeignFieldDesc ff = (ForeignFieldDesc)fieldDesc;
            if (ff.cardinalityUPB > 1) {
                this.updateCollectionField(ff, (Collection)value, managedRelationshipInProgress);
            } else {
                this.updateObjectField(ff, value, true, managedRelationshipInProgress);
            }
        }
        this.updateTrackedFields(fieldDesc, value, null);
        Object currentValue = fieldDesc.getValue(this);
        fieldDesc.setValue(this, value);
        return currentValue;
    }

    private Object prepareSetField(int fieldID, Object value) {
        FieldDesc fieldDesc = this.persistenceConfig.getField(fieldID);
        return this.prepareSetField(fieldDesc, value, false, true);
    }

    private Object prepareSetField(FieldDesc fieldDesc, Object value) {
        return this.prepareSetField(fieldDesc, value, false, false);
    }

    private Object prepareSetField(FieldDesc fieldDesc, Object value, boolean managedRelationshipInProgress) {
        return this.prepareSetField(fieldDesc, value, managedRelationshipInProgress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object prepareSetField(FieldDesc fieldDesc, Object value, boolean managedRelationshipInProgress, boolean acquireShareLock) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.sqlstatemanager.preparesetfield", fieldDesc.getName());
        }
        if (acquireShareLock) {
            this.persistenceManager.acquireShareLock();
        }
        try {
            this.getLock();
            if ((fieldDesc.sqlProperties & 4) > 0) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "core.statemanager.readonly", fieldDesc.getName(), this.persistentObject.getClass().getName()));
            }
            if (fieldDesc.getTrackedFields() != null || fieldDesc instanceof ForeignFieldDesc) {
                this.persistenceManager.acquireFieldUpdateLock();
                Object object = this.doUpdateField(fieldDesc, value, managedRelationshipInProgress);
                return object;
            }
            Object object = this.doUpdateField(fieldDesc, value, managedRelationshipInProgress);
            return object;
        }
        catch (JDOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(500, "sqlstore.exception.log", e);
        }
        {
            finally {
                this.persistenceManager.releaseFieldUpdateLock();
            }
        }
        {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.statemanager.setfieldfailed"), e);
        }
        finally {
            if (acquireShareLock) {
                this.persistenceManager.releaseShareLock();
            }
            this.releaseLock();
            if (debug) {
                logger.finest("sqlstore.sqlstatemanager.preparesetfield.exit");
            }
        }
    }

    private void updateCollectionField(ForeignFieldDesc fieldDesc, Collection value, boolean managedRelationshipInProgress) {
        Object currVal;
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{value, value == null ? "NO" : value.getClass().getName()};
            logger.finest("sqlstore.sqlstatemanager.processforeignfield", items);
        }
        if ((currVal = fieldDesc.getValue(this)) != value) {
            Object owner = null;
            ArrayList added = null;
            ArrayList removed = null;
            if (value != null && value instanceof SCOCollection) {
                SCOCollection sco = (SCOCollection)value;
                owner = sco.getOwner();
                if (owner == null) {
                    sco.setOwner(this.persistentObject, fieldDesc.getName(), fieldDesc.getComponentType());
                } else if (owner != this.persistentObject || !fieldDesc.getName().equals(sco.getFieldName())) {
                    throw new JDOUserException(I18NHelper.getMessage(messages, "core.statemanager.anotherowner"), new Object[]{owner, sco.getFieldName()});
                }
                added = new ArrayList(value);
            }
            Object befrVal = fieldDesc.getValue(this.beforeImage);
            if (currVal != null) {
                if (debug) {
                    logger.finest("sqlstore.sqlstatemanager.processforeignfield.remove");
                }
                if (((Collection)currVal).size() > 0) {
                    removed = new ArrayList((Collection)currVal);
                }
                if (currVal instanceof SCOCollection) {
                    if (debug) {
                        logger.finest("sqlstore.sqlstatemanager.processforeignfield.reset");
                    }
                    ((SCO)currVal).unsetOwner();
                }
            } else if (!this.getSetMaskBit(fieldDesc.absoluteID) && befrVal != null) {
                if (debug) {
                    logger.finest("sqlstore.sqlstatemanager.processforeignfield.remove_from_bi");
                }
                if (((Collection)befrVal).size() > 0) {
                    removed = new ArrayList((Collection)befrVal);
                }
            }
            this.processCollectionUpdates(fieldDesc, removed, added, null, true, managedRelationshipInProgress);
        }
    }

    public Object clone() {
        SQLStateManager clone = new SQLStateManager(this.store, this.persistenceConfig);
        clone.persistenceManager = this.persistenceManager;
        return clone;
    }

    private void assertNotPK(int fieldNumber) {
        if (this.persistenceConfig.isPKField(fieldNumber)) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.statemanager.nopkupdate"));
        }
    }

    private void assertPKUpdate(FieldDesc f, Object value) {
        Object currentValue = f.getValue(this);
        boolean throwException = false;
        if (value != null && currentValue != null) {
            if (value.toString().compareTo(currentValue.toString()) != 0) {
                throwException = true;
            }
        } else if (value != currentValue) {
            throwException = true;
        }
        if (throwException) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.statemanager.nopkupdate"));
        }
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManagerInternal() {
        return this.persistenceManager;
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.persistenceManager == null ? null : this.persistenceManager.getCurrentWrapper();
    }

    public byte setFlags(byte flags) {
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadForRead() {
        boolean debug = logger.isLoggable(400);
        if (debug) {
            logger.finer("sqlstore.sqlstatemanager.loadforread");
        }
        this.persistenceManager.acquireShareLock();
        try {
            this.getLock();
            byte oldFlags = this.persistenceManager.getFlags(this.persistentObject);
            if (oldFlags != 1) {
                return;
            }
            try {
                boolean xactActive = this.persistenceManager.isActiveTransaction();
                boolean optimistic = this.persistenceManager.isOptimisticTransaction();
                boolean nontransactionalRead = this.persistenceManager.isNontransactionalRead();
                if (this.state.needsReload(optimistic, nontransactionalRead, xactActive)) {
                    this.reload(null);
                }
                LifeCycleState oldstate = this.state;
                this.state = this.state.transitionReadField(optimistic, nontransactionalRead, xactActive);
                this.persistenceManager.setFlags(this.persistentObject, (byte)-1);
                this.registerInstance(false, null, oldstate);
            }
            catch (JDOException e) {
                this.persistenceManager.setFlags(this.persistentObject, oldFlags);
                throw e;
            }
        }
        finally {
            this.persistenceManager.releaseShareLock();
            this.releaseLock();
            if (debug) {
                logger.finer("sqlstore.sqlstatemanager.loadforread.exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadForUpdate() {
        boolean debug = logger.isLoggable(400);
        if (debug) {
            logger.finer("sqlstore.sqlstatemanager.loadforupdate");
        }
        this.persistenceManager.acquireShareLock();
        try {
            this.getLock();
            byte oldFlags = this.persistenceManager.getFlags(this.persistentObject);
            if (oldFlags == 0) {
                return;
            }
            this.persistenceManager.setFlags(this.persistentObject, (byte)0);
            ArrayList fields = this.persistenceConfig.fields;
            try {
                for (int i = 0; i < fields.size(); ++i) {
                    FieldDesc f = (FieldDesc)fields.get(i);
                    if (f.fetchGroup != 1) continue;
                    this.prepareUpdateField(f, null);
                }
            }
            catch (JDOException e) {
                this.persistenceManager.setFlags(this.persistentObject, oldFlags);
                throw e;
            }
        }
        finally {
            this.persistenceManager.releaseShareLock();
            this.releaseLock();
            if (debug) {
                logger.finer("sqlstore.sqlstatemanager.loadforupdate.exit");
            }
        }
    }

    public synchronized void replaceCollection(ForeignFieldDesc ff, Collection c) {
        Collection collection = (Collection)ff.getValue(this);
        SCOCollection scoCollection = null;
        if (collection == null || !(collection instanceof SCO)) {
            scoCollection = (SCOCollection)this.persistenceManager.newCollectionInstanceInternal(ff.getType(), this.persistentObject, ff.getName(), ff.getComponentType(), false, c != null ? c.size() : 0);
            ff.setValue(this, scoCollection);
            scoCollection.addAllInternal(c);
        } else {
            scoCollection = (SCOCollection)collection;
            if (scoCollection.isDeferred()) {
                scoCollection.applyDeferredUpdates(c);
                ArrayList trackedFields = ff.getTrackedFields();
                if (trackedFields != null) {
                    for (int i = 0; i < trackedFields.size(); ++i) {
                        ForeignFieldDesc tf = (ForeignFieldDesc)trackedFields.get(i);
                        this.setPresenceMaskBit(tf.absoluteID);
                    }
                }
            } else {
                scoCollection.clearInternal();
                scoCollection.addAllInternal(c);
            }
        }
        if (c != null && c instanceof SCO) {
            ((SCO)((Object)c)).unsetOwner();
        }
    }

    protected LifeCycleState getCurrentState() {
        return this.state;
    }

    public boolean isDirty() {
        if (this.state != null) {
            return this.state.isDirty();
        }
        return false;
    }

    public boolean isTransactional() {
        if (this.state != null) {
            return this.state.isTransactional();
        }
        return false;
    }

    public boolean isNew() {
        if (this.state != null) {
            return this.state.isNew();
        }
        return false;
    }

    public boolean isDeleted() {
        if (this.state != null) {
            return this.state.isDeleted();
        }
        return false;
    }

    public boolean isPersistent() {
        if (this.state != null) {
            return this.state.isPersistent();
        }
        return false;
    }

    public boolean needsRegisterWithVersionConsistencyCache() {
        boolean rc = this.hasVersionConsistency();
        if (rc && this.state != null) {
            rc = this.state.isPersistent() && this.state.isTransactional() && !this.state.isNew() && !this.state.isDirty() && !this.state.isDeleted();
        }
        return rc;
    }

    public boolean needsUpdateInVersionConsistencyCache() {
        boolean rc = this.hasVersionConsistency();
        if (rc && this.state != null) {
            rc = (this.state.isDirty() || this.state.isNew() || this.persistenceConfig.hasLocalNonDFGFields()) && !this.state.isDeleted();
        }
        return rc;
    }

    public boolean setBooleanField(int fieldNumber, boolean value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)new Boolean(value));
        return value;
    }

    public boolean[] setBooleanArrayField(int fieldNumber, boolean[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public byte setByteField(int fieldNumber, byte value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)new Byte(value));
        return value;
    }

    public byte[] setByteArrayField(int fieldNumber, byte[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public short setShortField(int fieldNumber, short value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)new Short(value));
        return value;
    }

    public short[] setShortArrayField(int fieldNumber, short[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public int setIntField(int fieldNumber, int value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)new Integer(value));
        return value;
    }

    public int[] setIntArrayField(int fieldNumber, int[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public long setLongField(int fieldNumber, long value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)new Long(value));
        return value;
    }

    public long[] setLongArrayField(int fieldNumber, long[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public char setCharField(int fieldNumber, char value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public char setCharArrayField(int fieldNumber, char value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public float setFloatField(int fieldNumber, float value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)new Float(value));
        return value;
    }

    public float[] setFloatArrayField(int fieldNumber, float[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public double setDoubleField(int fieldNumber, double value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)new Double(value));
        return value;
    }

    public double[] setDoubleArrayField(int fieldNumber, double[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public String setStringField(int fieldNumber, String value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, (Object)value);
        return value;
    }

    public String[] setStringArrayField(int fieldNumber, String[] value) {
        this.prepareSetField(fieldNumber, null);
        return value;
    }

    public Object setObjectField(int fieldNumber, Object value) {
        this.assertNotPK(fieldNumber);
        this.prepareSetField(fieldNumber, value);
        return value;
    }

    public Object[] setObjectArrayField(int fieldNumber, Object[] value) {
        this.prepareSetField(fieldNumber, (Object)value);
        return value;
    }

    public boolean testIsLoaded(int fieldNumber) {
        return this.getPresenceMaskBit(fieldNumber);
    }

    public boolean testIsLoaded(String fieldName) {
        FieldDesc f = this.persistenceConfig.getField(fieldName);
        return this.testIsLoaded(f.absoluteID);
    }

    public boolean testIsAutoPersistent() {
        return this.state.isAutoPersistent();
    }

    public void markNotRegistered() {
        this.needsRegisterAtRollback = true;
    }

    public void markVerifyAtDeregister() {
        this.needsVerifyAtDeregister = true;
    }

    public void markReplacement() {
        this.isReplacementInstance = true;
    }

    public void getLock() {
        this.lock.acquire();
    }

    public void releaseLock() {
        this.lock.release();
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValid() {
        try {
            this.getLock();
            this.valid = true;
        }
        finally {
            this.releaseLock();
        }
    }

    private class UpdatedForeignReference {
        ForeignFieldDesc fieldDesc;
        SQLStateManager sm;

        private UpdatedForeignReference(ForeignFieldDesc fieldDesc, SQLStateManager sm) {
            this.fieldDesc = fieldDesc;
            this.sm = sm;
        }

        private ForeignFieldDesc getFieldDesc() {
            return this.fieldDesc;
        }

        private SQLStateManager getStateManager() {
            return this.sm;
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass().equals(obj.getClass())) {
                UpdatedForeignReference other = (UpdatedForeignReference)obj;
                return this.fieldDesc == other.fieldDesc && this.sm == other.sm;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.sm.hashCode();
            if (this.fieldDesc != null) {
                hashCode += this.fieldDesc.hashCode();
            }
            return hashCode;
        }
    }
}

