/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.KeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateJoinTableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateStatement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.TableElement;

public class UpdateQueryPlan
extends QueryPlan {
    private boolean batch = false;
    private UpdateObjectDescImpl updateDesc;

    public UpdateQueryPlan(ActionDesc desc, SQLStoreManager store) {
        super(desc, store);
        this.updateDesc = (UpdateObjectDescImpl)desc;
        this.action = UpdateQueryPlan.getAction(this.updateDesc.getUpdateAction());
    }

    private static int getAction(int updateAction) {
        if (updateAction == 1) {
            return 2;
        }
        if (updateAction == 2) {
            return 3;
        }
        if (updateAction == 3) {
            return 1;
        }
        return 5;
    }

    private void addColumn(LocalFieldDesc fieldDesc, Object value) {
        if ((fieldDesc.sqlProperties & 0x40) > 0) {
            return;
        }
        Iterator iter = fieldDesc.getColumnElements();
        while (iter.hasNext()) {
            ColumnElement columnElement = (ColumnElement)iter.next();
            TableElement tableElement = columnElement.getDeclaringTable();
            if (tableElement == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.fieldnotable", fieldDesc.getName()));
            }
            QueryTable t = this.findQueryTable(tableElement);
            UpdateStatement s = null;
            if (t == null) {
                t = this.addQueryTable(tableElement, null);
                s = (UpdateStatement)this.addStatement(t);
            } else {
                s = (UpdateStatement)this.getStatement(t);
            }
            if (fieldDesc.isVersion() && this.action == 1) {
                s.addVersionColumn(columnElement);
                continue;
            }
            s.addColumn(columnElement, value);
        }
    }

    public void build() {
        this.build(false);
    }

    public void build(boolean batch) {
        if ((this.status & 1) > 0) {
            return;
        }
        this.batch = batch;
        this.generateStatements();
        this.addColumns();
        if (this.statements.size() > 0) {
            this.processStatements();
        }
        this.processJoinTables();
        this.status |= 1;
    }

    private void generateStatements() {
        if (this.action == 3 || this.action == 2) {
            Iterator iter = this.config.getTables();
            while (iter.hasNext()) {
                TableDesc t = (TableDesc)iter.next();
                if (t.isJoinTable() || this.findQueryTable(t.getTableElement()) != null) continue;
                this.addStatement(this.addQueryTable(t));
            }
            if (this.action == 2) {
                int i = 0;
                for (int j = this.statements.size() - 1; i < j; ++i, --j) {
                    Statement s = (Statement)this.statements.get(i);
                    this.statements.set(i, this.statements.get(j));
                    this.statements.set(j, s);
                }
            }
        }
    }

    private void addColumns() {
        if (this.action == 1 || this.action == 2) {
            List updatedFields = this.updateDesc.getUpdatedFields();
            int size = updatedFields != null ? updatedFields.size() : 0;
            for (int i = 0; i < size; ++i) {
                LocalFieldDesc f = (LocalFieldDesc)updatedFields.get(i);
                LocalFieldDesc value = this.batch ? f : this.updateDesc.getAfterValue(f);
                this.addColumn(f, value);
            }
        }
    }

    private void addConstraints(UpdateStatement statement, ArrayList localFields, ArrayList foreignFields, ArrayList columns) {
        boolean isBeforeImageRequired = this.updateDesc.isBeforeImageRequired();
        for (int i = 0; i < localFields.size(); ++i) {
            LocalFieldDesc lf = (LocalFieldDesc)localFields.get(i);
            LocalFieldDesc ff = (LocalFieldDesc)foreignFields.get(i);
            ColumnElement ce = (ColumnElement)columns.get(i);
            this.addConstraint(statement, lf, ff, ce, isBeforeImageRequired);
        }
        if (this.getConfig().hasVersionConsistency() && this.action != 2) {
            QueryTable table = (QueryTable)statement.getQueryTables().get(0);
            LocalFieldDesc versionField = table.getTableDesc().getVersionField();
            ColumnElement ce = (ColumnElement)versionField.getColumnElements().next();
            this.addConstraint(statement, versionField, versionField, ce, false);
        }
        statement.markConstraintAdded();
    }

    private void addConstraint(UpdateStatement statement, LocalFieldDesc lf, LocalFieldDesc ff, ColumnElement ce, boolean isBeforeImageRequired) {
        if (this.action != 2) {
            if (this.batch) {
                statement.addConstraint(ce, lf, ff);
            } else {
                Object value = isBeforeImageRequired ? this.updateDesc.getBeforeValue(ff) : this.updateDesc.getAfterValue(ff);
                statement.addConstraint(lf, value);
            }
        } else {
            LocalFieldDesc value = this.batch ? ff : this.updateDesc.getAfterValue(ff);
            statement.addColumn(ce, value);
        }
    }

    private void addSecondaryTableConstraint(UpdateStatement statement) {
        QueryTable table = (QueryTable)statement.getQueryTables().get(0);
        ReferenceKeyDesc key = table.getTableDesc().getPrimaryTableKey();
        ArrayList localFields = key.getReferencingKey().getFields();
        ArrayList foreignFields = key.getReferencedKey().getFields();
        ArrayList columns = key.getReferencingKey().getColumns();
        this.addConstraints(statement, localFields, foreignFields, columns);
    }

    private void addBasetableConstraint(UpdateStatement statement) {
        QueryTable table = (QueryTable)statement.getQueryTables().get(0);
        KeyDesc key = table.getTableDesc().getKey();
        ArrayList localFields = key.getFields();
        ArrayList columns = key.getColumns();
        this.addConstraints(statement, localFields, localFields, columns);
    }

    private void processRelatedStatements(UpdateStatement statement) {
        ArrayList secondaryTableStatements = statement.getSecondaryTableStatements();
        if (secondaryTableStatements != null) {
            for (int i = 0; i < secondaryTableStatements.size(); ++i) {
                UpdateStatement secondaryTableStatement = (UpdateStatement)secondaryTableStatements.get(i);
                if (secondaryTableStatement.isConstraintAdded()) continue;
                this.processRelatedStatements(secondaryTableStatement);
                this.addSecondaryTableConstraint(secondaryTableStatement);
            }
        }
    }

    protected void processStatements() {
        int size = this.statements.size();
        if (size > 1) {
            super.processStatements();
            for (int i = 0; i < size; ++i) {
                UpdateStatement statement = (UpdateStatement)this.statements.get(i);
                if (statement.isConstraintAdded()) continue;
                this.processRelatedStatements(statement);
            }
        }
        UpdateStatement masterStatement = null;
        if (size == 1) {
            masterStatement = (UpdateStatement)this.statements.get(0);
        } else {
            for (int i = 0; i < size && (masterStatement = (UpdateStatement)this.statements.get(i)).isConstraintAdded(); ++i) {
            }
        }
        if (this.action != 2) {
            this.addBasetableConstraint(masterStatement);
        }
        if (this.action != 2 && this.updateDesc.getConcurrency() != null) {
            this.updateDesc.getConcurrency().update(this);
        }
    }

    private void processJoinTables() {
        Collection fields = this.updateDesc.getUpdatedJoinTableFields();
        if (fields == null) {
            return;
        }
        Iterator fieldIter = fields.iterator();
        ArrayList<UpdateStatement> deleteStatements = new ArrayList<UpdateStatement>();
        ArrayList<UpdateStatement> insertStatements = new ArrayList<UpdateStatement>();
        while (fieldIter.hasNext()) {
            ForeignFieldDesc f = (ForeignFieldDesc)fieldIter.next();
            Collection descs = this.updateDesc.getUpdateJoinTableDescs(f);
            Iterator descIter = descs.iterator();
            ColumnElement c = (ColumnElement)f.assocLocalColumns.get(0);
            QueryTable t = this.addQueryTable(this.config.findTableDesc(c.getDeclaringTable()));
            while (descIter.hasNext()) {
                UpdateJoinTableDesc desc = (UpdateJoinTableDesc)descIter.next();
                int action = UpdateQueryPlan.getAction(desc.getAction());
                UpdateStatement s = (UpdateStatement)this.createStatement(t);
                s.setAction(action);
                if (action == 2) {
                    insertStatements.add(s);
                } else if (action == 3) {
                    s.minAffectedRows = 0;
                    deleteStatements.add(s);
                }
                s.addLocalConstraints(action, f, desc.getParentStateManager());
                s.addForeignConstraints(action, f, desc.getForeignStateManager());
            }
        }
        ArrayList oldStatements = this.statements;
        this.statements = deleteStatements;
        this.statements.addAll(oldStatements);
        this.statements.addAll(insertStatements);
    }

    protected Statement newStatement() {
        return new UpdateStatement(this.store.getVendorType(), this, this.batch);
    }

    public boolean checkBatchThreshold(Transaction tran) {
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            UpdateStatement updateStatement = (UpdateStatement)this.statements.get(i);
            if (!updateStatement.exceedsBatchThreshold(tran)) continue;
            return true;
        }
        return false;
    }
}

