/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class HtmlResponseWriter
extends ResponseWriter {
    private String contentType = "text/html";
    private String encoding = null;
    private Writer writer = null;
    private boolean closeStart;
    private boolean dontEscape;
    private boolean writingCdata;
    private boolean isScript;
    private boolean isStyle;
    private boolean scriptOrStyleSrc;
    private boolean isXhtml;
    private Writer origWriter;
    private FastStringWriter scriptBuffer;
    private Boolean isScriptHidingEnabled;
    private char[] buffer = new char[1028];
    private char[] charHolder = new char[1];
    static final Pattern CDATA_START_SLASH_SLASH = Pattern.compile("^//\\s*\\Q<![CDATA[\\E");
    static final Pattern CDATA_END_SLASH_SLASH = Pattern.compile("//\\s*\\Q]]>\\E$");
    static final Pattern CDATA_START_SLASH_STAR = Pattern.compile("^/\\*\\s*\\Q<![CDATA[\\E\\s*\\*/");
    static final Pattern CDATA_END_SLASH_STAR = Pattern.compile("/\\*\\s*\\Q]]>\\E\\s*\\*/$");

    public HtmlResponseWriter(Writer writer, String contentType, String encoding) throws FacesException {
        this(writer, contentType, encoding, true);
    }

    public HtmlResponseWriter(Writer writer, String contentType, String encoding, Boolean isScriptHidingEnabled) throws FacesException {
        this.writer = writer;
        if (null != contentType) {
            this.contentType = contentType;
        }
        this.encoding = encoding;
        this.isScriptHidingEnabled = isScriptHidingEnabled;
        if (!HtmlUtils.validateEncoding(encoding)) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.ENCODING_ERROR", new Object[0]));
        }
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
    }

    public String getContentType() {
        return this.contentType;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            return new HtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding(), this.isScriptHidingEnabled);
        }
        catch (FacesException e) {
            throw new IllegalStateException();
        }
    }

    public void endDocument() throws IOException {
        this.writer.flush();
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        this.dontEscape = false;
        this.isXhtml = this.getContentType().equals("application/xhtml+xml");
        FacesContext context = FacesContext.getCurrentInstance();
        HtmlResponseWriter writerFromContext = null != context ? context.getResponseWriter() : this;
        HtmlResponseWriter htmlResponseWriter = writerFromContext = null == writerFromContext ? this : writerFromContext;
        if (this.isScriptOrStyle(name) && !this.scriptOrStyleSrc) {
            String result = ((FastStringWriter)this.writer).getBuffer().toString();
            this.writer = this.origWriter;
            if (result != null) {
                String trim = result.trim();
                if (this.isXhtml) {
                    if (this.isScript) {
                        Matcher cdataStartSlashSlash = CDATA_START_SLASH_SLASH.matcher(trim);
                        Matcher cdataEndSlashSlash = CDATA_END_SLASH_SLASH.matcher(trim);
                        Matcher cdataStartSlashStar = CDATA_START_SLASH_STAR.matcher(trim);
                        Matcher cdataEndSlashStar = CDATA_END_SLASH_STAR.matcher(trim);
                        int trimLen = trim.length();
                        if (cdataStartSlashSlash.find() && cdataEndSlashSlash.find()) {
                            int start = cdataStartSlashSlash.end() - cdataStartSlashSlash.start();
                            int end = trimLen - (cdataEndSlashSlash.end() - cdataEndSlashSlash.start());
                            writerFromContext.write(trim.substring(start, end));
                        } else if (null != cdataStartSlashSlash.reset() && cdataStartSlashSlash.find() && cdataEndSlashStar.find()) {
                            int start = cdataStartSlashSlash.end() - cdataStartSlashSlash.start();
                            int end = trimLen - (cdataEndSlashStar.end() - cdataEndSlashStar.start());
                            writerFromContext.write(trim.substring(start, end));
                        } else if (cdataStartSlashStar.find() && null != cdataEndSlashStar.reset() && cdataEndSlashStar.find()) {
                            int start = cdataStartSlashStar.end() - cdataStartSlashStar.start();
                            int end = trimLen - (cdataEndSlashStar.end() - cdataEndSlashStar.start());
                            writerFromContext.write(trim.substring(start, end));
                        } else if (null != cdataStartSlashStar.reset() && cdataStartSlashStar.find() && null != cdataEndSlashStar.reset() && cdataEndSlashSlash.find()) {
                            int start = cdataStartSlashStar.end() - cdataStartSlashStar.start();
                            int end = trimLen - (cdataEndSlashSlash.end() - cdataEndSlashSlash.start());
                            writerFromContext.write(trim.substring(start, end));
                        } else {
                            writerFromContext.write(result);
                        }
                    } else if (trim.startsWith("<![CDATA[") && trim.endsWith("]]>")) {
                        writerFromContext.write(trim.substring(9, trim.length() - 3));
                    } else {
                        writerFromContext.write(result);
                    }
                } else if (trim.startsWith("<!--") && trim.endsWith("//-->")) {
                    writerFromContext.write(trim.substring(4, trim.length() - 5));
                } else {
                    writerFromContext.write(result);
                }
            }
            if (this.isXhtml) {
                if (this.isScript) {
                    writerFromContext.write("\n//]]>\n");
                } else {
                    writerFromContext.write("\n]]>\n");
                }
            } else if (this.isScriptHidingEnabled.booleanValue()) {
                writerFromContext.write("\n//-->\n");
            }
        }
        this.isScript = false;
        this.isStyle = false;
        if ("cdata".equalsIgnoreCase(name)) {
            writerFromContext.write("]]>");
            this.writingCdata = false;
            return;
        }
        if (this.closeStart) {
            boolean isEmptyElement = HtmlUtils.isEmptyElement(name);
            if (isEmptyElement) {
                this.writer.write(" />");
                this.closeStart = false;
                return;
            }
            this.writer.write(62);
            this.closeStart = false;
        }
        writerFromContext.write("</");
        writerFromContext.write(name);
        writerFromContext.write(62);
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        this.closeStartIfNecessary();
        this.isScriptOrStyle(name);
        this.scriptOrStyleSrc = false;
        if ("cdata".equalsIgnoreCase(name)) {
            this.writingCdata = true;
            this.dontEscape = true;
            this.writer.write("<![CDATA[");
            this.closeStart = false;
            return;
        }
        this.writer.write(60);
        this.writer.write(name);
        this.closeStart = true;
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cbuf);
    }

    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(c);
    }

    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(str);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cbuf, off, len);
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(str, off, len);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        Class<?> valueClass;
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if (value == null) {
            return;
        }
        if (this.writingCdata) {
            return;
        }
        if (name.equalsIgnoreCase("src") && this.isScriptOrStyle()) {
            this.scriptOrStyleSrc = true;
        }
        if ((valueClass = value.getClass()) == Boolean.class) {
            if (Boolean.TRUE.equals(value)) {
                this.writer.write(32);
                this.writer.write(name);
                this.writer.write("=\"");
                this.writer.write(name);
                this.writer.write(34);
            }
        } else {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            HtmlUtils.writeAttribute(this.writer, this.buffer, value.toString());
            this.writer.write(34);
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (comment == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (this.writingCdata) {
            return;
        }
        this.closeStartIfNecessary();
        this.writer.write("<!--");
        this.writer.write(comment.toString());
        this.writer.write("-->");
    }

    public void writeText(char text) throws IOException {
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            this.charHolder[0] = text;
            HtmlUtils.writeText(this.writer, this.buffer, this.charHolder);
        }
    }

    public void writeText(char[] text) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text);
        }
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text.toString());
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text.toString());
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        if (off < 0 || off > text.length || len < 0 || len > text.length) {
            throw new IndexOutOfBoundsException();
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text, off, len);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text, off, len);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if (value == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "value"));
        }
        if (this.writingCdata) {
            return;
        }
        if (name.equalsIgnoreCase("src") && this.isScriptOrStyle()) {
            this.scriptOrStyleSrc = true;
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        String stringValue = value.toString();
        if (stringValue.startsWith("javascript:")) {
            HtmlUtils.writeAttribute(this.writer, this.buffer, stringValue);
        } else {
            HtmlUtils.writeURL(this.writer, stringValue, this.encoding, this.getContentType());
        }
        this.writer.write(34);
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.writer.write(62);
            this.closeStart = false;
            if (this.isScriptOrStyle() && !this.scriptOrStyleSrc) {
                this.isXhtml = this.getContentType().equals("application/xhtml+xml");
                if (this.isXhtml) {
                    if (this.isScript) {
                        this.writer.write("\n//<![CDATA[\n");
                    } else {
                        this.writer.write("\n<![CDATA[\n");
                    }
                } else if (this.isScriptHidingEnabled.booleanValue()) {
                    this.writer.write("\n<!--\n");
                }
                this.origWriter = this.writer;
                if (this.scriptBuffer == null) {
                    this.scriptBuffer = new FastStringWriter(1024);
                }
                this.scriptBuffer.reset();
                this.writer = this.scriptBuffer;
                this.isScript = false;
                this.isStyle = false;
            }
        }
    }

    private boolean isScriptOrStyle(String name) {
        if ("script".equalsIgnoreCase(name)) {
            this.isScript = true;
            this.dontEscape = true;
        } else if ("style".equalsIgnoreCase(name)) {
            this.isStyle = true;
            this.dontEscape = true;
        } else {
            this.isScript = false;
            this.isStyle = false;
            this.dontEscape = false;
        }
        return this.isScript || this.isStyle;
    }

    private boolean isScriptOrStyle() {
        return this.isScript || this.isStyle;
    }
}

