/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.RIConstants;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class MenuRenderer
extends HtmlBasicInputRenderer {
    public Object convertSelectManyValue(FacesContext context, UISelectMany uiSelectMany, String[] newValues) throws ConverterException {
        ValueExpression valueExpression = uiSelectMany.getValueExpression("value");
        Object result = newValues;
        Class modelType = null;
        boolean throwException = false;
        if (null != valueExpression) {
            modelType = valueExpression.getType(context.getELContext());
            if (null != modelType) {
                if (modelType.isArray()) {
                    result = this.convertSelectManyValues(context, uiSelectMany, modelType, newValues);
                } else if (List.class.isAssignableFrom(modelType)) {
                    result = Arrays.asList((Object[])this.convertSelectManyValues(context, uiSelectMany, Object[].class, newValues));
                } else {
                    throwException = true;
                }
            } else {
                throwException = true;
            }
        } else {
            result = this.convertSelectManyValues(context, uiSelectMany, Object[].class, newValues);
        }
        if (throwException) {
            StringBuffer values = new StringBuffer();
            if (null != newValues) {
                for (int i = 0; i < newValues.length; ++i) {
                    if (i == 0) {
                        values.append(newValues[i]);
                        continue;
                    }
                    values.append(' ').append(newValues[i]);
                }
            }
            Object[] params = new Object[]{values.toString(), valueExpression.getExpressionString()};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectMany Component  " + uiSelectMany.getId() + " convertedValues " + result);
        }
        return result;
    }

    public Object convertSelectOneValue(FacesContext context, UISelectOne uiSelectOne, String newValue) throws ConverterException {
        Object convertedValue = null;
        if (RIConstants.NO_VALUE.equals(newValue)) {
            return null;
        }
        if (newValue == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No conversion necessary for SelectOne Component  " + uiSelectOne.getId() + " since the new value is null ");
            }
            return null;
        }
        convertedValue = super.getConvertedValue(context, (UIComponent)uiSelectOne, newValue);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectOne Component  " + uiSelectOne.getId() + " convertedValue " + convertedValue);
        }
        return convertedValue;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin decoding component " + component.getId());
        }
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = component.getClientId(context);
        assert (clientId != null);
        if (component instanceof UISelectMany) {
            Map requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap();
            if (requestParameterValuesMap.containsKey(clientId)) {
                String[] newValues = (String[])requestParameterValuesMap.get(clientId);
                this.setSubmittedValue(component, newValues);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted values for UISelectMany component " + component.getId() + " after decoding " + newValues);
                }
            } else {
                this.setSubmittedValue(component, new String[0]);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set empty array for UISelectMany component " + component.getId() + " after decoding ");
                }
            }
        } else {
            Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
            if (requestParameterMap.containsKey(clientId)) {
                String newValue = (String)requestParameterMap.get(clientId);
                this.setSubmittedValue(component, newValue);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted value for UISelectOne component " + component.getId() + " after decoding " + newValue);
                }
            } else {
                this.setSubmittedValue(component, RIConstants.NO_VALUE);
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        this.renderSelect(context, component);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (component instanceof UISelectMany) {
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put("com.sun.faces.ComponentForValue", component);
            return this.convertSelectManyValue(context, (UISelectMany)component, (String[])submittedValue);
        }
        return this.convertSelectOneValue(context, (UISelectOne)component, (String)submittedValue);
    }

    protected Object convertSelectManyValues(FacesContext context, UISelectMany uiSelectMany, Class arrayClass, String[] newValues) throws ConverterException {
        Object result = null;
        Converter converter = null;
        int len = null != newValues ? newValues.length : 0;
        Class<?> elementType = arrayClass.getComponentType();
        if (elementType.equals(String.class)) {
            return newValues;
        }
        try {
            result = Array.newInstance(elementType, len);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
        if (null == newValues) {
            return result;
        }
        converter = uiSelectMany.getConverter();
        if (null == converter && null == (converter = Util.getConverterForClass(elementType, context))) {
            if (elementType.equals(Object.class)) {
                return newValues;
            }
            StringBuffer valueStr = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    valueStr.append(newValues[i]);
                    continue;
                }
                valueStr.append(' ').append(newValues[i]);
            }
            Object[] params = new Object[]{valueStr.toString(), "null Converter"};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        assert (null != result);
        if (elementType.isPrimitive()) {
            for (int i = 0; i < len; ++i) {
                if (elementType.equals(Boolean.TYPE)) {
                    Array.setBoolean(result, i, (Boolean)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Byte.TYPE)) {
                    Array.setByte(result, i, (Byte)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Double.TYPE)) {
                    Array.setDouble(result, i, (Double)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Float.TYPE)) {
                    Array.setFloat(result, i, ((Float)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i])).floatValue());
                    continue;
                }
                if (elementType.equals(Integer.TYPE)) {
                    Array.setInt(result, i, (Integer)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Character.TYPE)) {
                    Array.setChar(result, i, ((Character)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i])).charValue());
                    continue;
                }
                if (elementType.equals(Short.TYPE)) {
                    Array.setShort(result, i, (Short)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (!elementType.equals(Long.TYPE)) continue;
                Array.setLong(result, i, (Long)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    Object converted = converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]);
                    logger.fine("String value: " + newValues[i] + " converts to : " + converted.toString());
                }
                Array.set(result, i, converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
            }
        }
        return result;
    }

    protected void renderOption(FacesContext context, UIComponent component, SelectItem curItem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.writeText((Object)"\t", component, null);
        writer.startElement("option", component);
        String valueString = this.getFormattedValue(context, component, curItem.getValue());
        writer.writeAttribute("value", (Object)valueString, "value");
        Object[] submittedValues = this.getSubmittedSelectedValues(context, component);
        Class type = String.class;
        Object valuesArray = null;
        Object itemValue = null;
        boolean isSelected = false;
        boolean containsValue = false;
        if (submittedValues != null) {
            containsValue = this.containsaValue(submittedValues);
            if (containsValue) {
                valuesArray = submittedValues;
                itemValue = valueString;
            } else {
                valuesArray = this.getCurrentSelectedValues(context, component);
                itemValue = curItem.getValue();
            }
        } else {
            valuesArray = this.getCurrentSelectedValues(context, component);
            itemValue = curItem.getValue();
        }
        if (valuesArray != null) {
            type = valuesArray.getClass().getComponentType();
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put("com.sun.faces.ComponentForValue", component);
        Object newValue = null;
        try {
            newValue = context.getApplication().getExpressionFactory().coerceToType(itemValue, type);
        }
        catch (Exception e) {
            newValue = null;
        }
        isSelected = this.isSelected(newValue, valuesArray);
        if (isSelected) {
            writer.writeAttribute("selected", (Object)true, "selected");
        }
        String labelClass = null;
        Boolean disabledAttr = (Boolean)component.getAttributes().get("disabled");
        boolean componentDisabled = false;
        if (disabledAttr != null && disabledAttr.equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        if (!componentDisabled && curItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)true, "disabled");
        }
        if ((labelClass = componentDisabled || curItem.isDisabled() ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass")) != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (curItem.isEscape()) {
            String label = curItem.getLabel();
            if (label == null) {
                label = curItem.getValue().toString();
            }
            writer.writeText((Object)label, component, "label");
        } else {
            writer.write(curItem.getLabel());
        }
        writer.endElement("option");
        writer.writeText((Object)"\n", component, null);
    }

    protected void writeDefaultSize(ResponseWriter writer, int itemCount) throws IOException {
        writer.writeAttribute("size", (Object)"1", "size");
    }

    boolean containsaValue(Object valueArray) {
        if (null != valueArray) {
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(valueArray, i);
                if (value == null || value.equals(RIConstants.NO_VALUE)) continue;
                return true;
            }
        }
        return false;
    }

    Object getCurrentSelectedValues(FacesContext context, UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            Object value = select.getValue();
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                int size = list.size();
                if (size > 0) {
                    return list.toArray((Object[])Array.newInstance(list.iterator().next().getClass(), size));
                }
                return ((Collection)value).toArray();
            }
            if (value != null && !value.getClass().isArray()) {
                logger.warning("The UISelectMany value should be an array or a collection type, the actual type is " + value.getClass().getName());
            }
            return value;
        }
        UISelectOne select = (UISelectOne)component;
        Object returnObject = select.getValue();
        if (null != returnObject) {
            Object ret = Array.newInstance(returnObject.getClass(), 1);
            Array.set(ret, 0, returnObject);
            return ret;
        }
        return null;
    }

    String getMultipleText(UIComponent component) {
        if (component instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    int getOptionNumber(FacesContext context, UIComponent component) {
        Iterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        int itemCount = 0;
        while (items.hasNext()) {
            ++itemCount;
            SelectItem item = items.next();
            if (!(item instanceof SelectItemGroup)) continue;
            int optionsLength = ((SelectItemGroup)item).getSelectItems().length;
            itemCount += optionsLength;
        }
        return itemCount;
    }

    Object[] getSubmittedSelectedValues(FacesContext context, UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            return (Object[])select.getSubmittedValue();
        }
        UISelectOne select = (UISelectOne)component;
        Object returnObject = select.getSubmittedValue();
        if (null != returnObject) {
            return new Object[]{returnObject};
        }
        return null;
    }

    boolean isSelected(Object itemValue, Object valueArray) {
        if (null != valueArray) {
            if (!valueArray.getClass().isArray()) {
                logger.warning("valueArray is not an array, the actual type is " + valueArray.getClass());
                return valueArray.equals(itemValue);
            }
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(valueArray, i);
                if (!(value == null ? itemValue == null : value.equals(itemValue))) continue;
                return true;
            }
        }
        return false;
    }

    void renderOptions(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        Iterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        SelectItem curItem = null;
        while (items.hasNext()) {
            curItem = items.next();
            if (curItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)curItem.getLabel(), "label");
                SelectItem[] itemsArray = ((SelectItemGroup)curItem).getSelectItems();
                for (int i = 0; i < itemsArray.length; ++i) {
                    this.renderOption(context, component, itemsArray[i]);
                }
                writer.endElement("optgroup");
                continue;
            }
            this.renderOption(context, component, curItem);
        }
    }

    void renderSelect(FacesContext context, UIComponent component) throws IOException {
        Integer size;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Rendering 'select'");
        }
        writer.startElement("select", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String styleClass = null;
        styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (!this.getMultipleText(component).equals("")) {
            writer.writeAttribute("multiple", (Object)true, "multiple");
        }
        int itemCount = this.getOptionNumber(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Rendering " + itemCount + " options");
        }
        if ((size = (Integer)component.getAttributes().get("size")) == null || size == Integer.MIN_VALUE) {
            size = itemCount;
        }
        this.writeDefaultSize(writer, size);
        RenderKitUtils.renderPassThruAttributes(context, writer, component, new String[]{"size"});
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        this.renderOptions(context, component);
        writer.endElement("select");
    }
}

