/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnElementHolder;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.ColumnPairElementHolder;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.DBMemoryCollection;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;

public final class TableElement
extends DBElement
implements ColumnElementHolder,
ColumnPairElementHolder {
    public static final boolean TABLE = true;
    public static final boolean VIEW = false;
    private transient SchemaElement declaringSchema;

    public TableElement() {
        this(new Memory(), null);
    }

    public TableElement(Impl impl, SchemaElement schemaElement) {
        super(impl);
        this.declaringSchema = schemaElement;
    }

    final Impl getTableImpl() {
        return (Impl)this.getElementImpl();
    }

    public static TableElement forName(String string, SchemaElement schemaElement) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        string = string.substring(n + 1);
        TableElement[] tableElementArray = schemaElement.getTables();
        for (int i = 0; i < tableElementArray.length; ++i) {
            if (!tableElementArray[i].getName().getName().trim().equals(string)) continue;
            return tableElementArray[i];
        }
        return null;
    }

    public static TableElement forName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("FullyQualifiedName"));
            }
            return null;
        }
        SchemaElement schemaElement = SchemaElement.forName(string.substring(0, n));
        if (schemaElement == null) {
            return null;
        }
        return TableElement.forName(string, schemaElement);
    }

    public void setTableOrView(boolean bl) throws DBException {
        this.getTableImpl().setTableOrView(bl);
    }

    public boolean isTableOrView() {
        return this.getTableImpl().isTableOrView();
    }

    public boolean isTable() {
        return this.getTableImpl().isTableOrView();
    }

    public boolean isView() {
        return !this.getTableImpl().isTableOrView();
    }

    public final SchemaElement getDeclaringSchema() {
        return this.declaringSchema;
    }

    public final void setDeclaringSchema(SchemaElement schemaElement) {
        if (this.declaringSchema == null) {
            this.declaringSchema = schemaElement;
        }
    }

    public void addColumn(ColumnElement columnElement) throws DBException {
        this.addColumns(new ColumnElement[]{columnElement});
    }

    public void addColumns(ColumnElement[] columnElementArray) throws DBException {
        for (int i = 0; i < columnElementArray.length; ++i) {
            if (this.getColumn(columnElementArray[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", columnElementArray[i]);
            }
            if (columnElementArray[i].getDeclaringTable() != null) continue;
            columnElementArray[i].setDeclaringTable(this);
        }
        this.getTableImpl().changeColumns(columnElementArray, 1);
    }

    public void removeColumn(ColumnElement columnElement) throws DBException {
        this.removeColumns(new ColumnElement[]{columnElement});
    }

    public void removeColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getTableImpl().changeColumns(columnElementArray, -1);
    }

    public void setColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getTableImpl().changeColumns(columnElementArray, 0);
    }

    public ColumnElement[] getColumns() {
        return this.getTableImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getColumn(dBIdentifier);
    }

    public void addIndex(IndexElement indexElement) throws DBException {
        this.addIndexes(new IndexElement[]{indexElement});
    }

    public void addIndexes(IndexElement[] indexElementArray) throws DBException {
        for (int i = 0; i < indexElementArray.length; ++i) {
            if (this.getIndex(indexElementArray[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", indexElementArray[i]);
            }
            if (indexElementArray[i].getDeclaringTable() != null) continue;
            indexElementArray[i].setDeclaringTable(this);
        }
        this.getTableImpl().changeIndexes(indexElementArray, 1);
    }

    public void removeIndex(IndexElement indexElement) throws DBException {
        this.removeIndexes(new IndexElement[]{indexElement});
    }

    public void removeIndexes(IndexElement[] indexElementArray) throws DBException {
        this.getTableImpl().changeIndexes(indexElementArray, -1);
    }

    public void setIndexes(IndexElement[] indexElementArray) throws DBException {
        this.getTableImpl().changeIndexes(indexElementArray, 0);
    }

    public IndexElement[] getIndexes() {
        return this.getTableImpl().getIndexes();
    }

    public IndexElement getIndex(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getIndex(dBIdentifier);
    }

    public void addKey(KeyElement keyElement) throws DBException {
        this.addKeys(new KeyElement[]{keyElement});
    }

    public void addKeys(KeyElement[] keyElementArray) throws DBException {
        for (int i = 0; i < keyElementArray.length; ++i) {
            if (this.getKey(keyElementArray[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", keyElementArray[i]);
            }
            if (keyElementArray[i].getDeclaringTable() == null) {
                keyElementArray[i].setDeclaringTable(this);
            }
            if (!(keyElementArray[i] instanceof UniqueKeyElement) || ((UniqueKeyElement)keyElementArray[i]).getAssociatedIndex() != null) continue;
            IndexElement indexElement = new IndexElement();
            try {
                indexElement.setName(keyElementArray[i].getName());
                indexElement.setColumns(keyElementArray[i].getColumns());
                this.addIndex(indexElement);
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
            ((UniqueKeyElement)keyElementArray[i]).setAssociatedIndex(indexElement);
        }
        this.getTableImpl().changeKeys(keyElementArray, 1);
    }

    public void removeKey(KeyElement keyElement) throws DBException {
        this.removeKeys(new KeyElement[]{keyElement});
    }

    public void removeKeys(KeyElement[] keyElementArray) throws DBException {
        this.getTableImpl().changeKeys(keyElementArray, -1);
    }

    public void setKeys(KeyElement[] keyElementArray) throws DBException {
        this.getTableImpl().changeKeys(keyElementArray, 0);
    }

    public KeyElement[] getKeys() {
        return this.getTableImpl().getKeys();
    }

    public KeyElement getKey(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getKey(dBIdentifier);
    }

    private ArrayList getKeys(Class clazz) {
        KeyElement[] keyElementArray = this.getKeys();
        if (keyElementArray == null) {
            return null;
        }
        int n = keyElementArray.length;
        ArrayList<KeyElement> arrayList = new ArrayList<KeyElement>(n);
        for (int i = 0; i < n; ++i) {
            KeyElement keyElement = keyElementArray[i];
            if (!clazz.isInstance(keyElement)) continue;
            arrayList.add(keyElement);
        }
        return arrayList;
    }

    public ForeignKeyElement[] getForeignKeys() {
        ArrayList arrayList = this.getKeys(ForeignKeyElement.class);
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        return arrayList.toArray(new ForeignKeyElement[n]);
    }

    public ForeignKeyElement getForeignKey(DBIdentifier dBIdentifier) {
        ForeignKeyElement[] foreignKeyElementArray = this.getForeignKeys();
        int n = foreignKeyElementArray.length;
        for (int i = 0; i < n; ++i) {
            ForeignKeyElement foreignKeyElement = foreignKeyElementArray[i];
            if (!dBIdentifier.equals(foreignKeyElement.getName())) continue;
            return foreignKeyElement;
        }
        return null;
    }

    public UniqueKeyElement[] getUniqueKeys() {
        ArrayList arrayList = this.getKeys(UniqueKeyElement.class);
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new UniqueKeyElement[arrayList.size()]);
    }

    public UniqueKeyElement getUniqueKey(DBIdentifier dBIdentifier) {
        UniqueKeyElement[] uniqueKeyElementArray = this.getUniqueKeys();
        int n = uniqueKeyElementArray.length;
        for (int i = 0; i < n; ++i) {
            UniqueKeyElement uniqueKeyElement = uniqueKeyElementArray[i];
            if (!dBIdentifier.equals(uniqueKeyElement.getName())) continue;
            return uniqueKeyElement;
        }
        return null;
    }

    public UniqueKeyElement getPrimaryKey() {
        UniqueKeyElement[] uniqueKeyElementArray = this.getUniqueKeys();
        if (uniqueKeyElementArray == null) {
            return null;
        }
        for (int i = 0; i < uniqueKeyElementArray.length; ++i) {
            UniqueKeyElement uniqueKeyElement = uniqueKeyElementArray[i];
            if (!uniqueKeyElement.isPrimaryKey()) continue;
            return uniqueKeyElement;
        }
        return null;
    }

    private void throwAddException(String string, DBMemberElement dBMemberElement) throws DBException {
        String string2 = dBMemberElement.getName().getName();
        throw new DBException(string2);
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName().toString();
        }
        return null;
    }

    public void addColumnPair(ColumnPairElement columnPairElement) throws DBException {
        this.addColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void addColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        for (int i = 0; i < columnPairElementArray.length; ++i) {
            if (this.getColumnPair(columnPairElementArray[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", columnPairElementArray[i]);
            }
            if (columnPairElementArray[i].getDeclaringTable() != null) continue;
            columnPairElementArray[i].setDeclaringTable(this);
        }
        this.getTableImpl().changeColumnPairs(columnPairElementArray, 1);
    }

    public void removeColumnPair(ColumnPairElement columnPairElement) throws DBException {
        this.removeColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void removeColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        this.getTableImpl().changeColumnPairs(columnPairElementArray, -1);
    }

    public void setColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        this.getTableImpl().changeColumnPairs(columnPairElementArray, 0);
    }

    public ColumnPairElement[] getColumnPairs() {
        return this.getTableImpl().getColumnPairs();
    }

    public ColumnPairElement getColumnPair(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getColumnPair(dBIdentifier);
    }

    public DBMemberElement getMember(DBIdentifier dBIdentifier) {
        int n = dBIdentifier.getName().indexOf(";");
        if (n == -1) {
            return this.getColumn(dBIdentifier);
        }
        return this.getColumnPair(dBIdentifier);
    }

    static final class Memory
    extends DBElement.Memory
    implements Impl {
        private boolean _isTable;
        private DBMemoryCollection.Column columns;
        private DBMemoryCollection.Index indexes;
        private DBMemoryCollection.Key keys;
        private DBMemoryCollection.ColumnPair pairs;

        public Memory() {
            this._isTable = true;
        }

        public Memory(TableElement tableElement) {
            super(tableElement);
            this._isTable = tableElement.isTableOrView();
        }

        public void setTableOrView(boolean bl) {
            boolean bl2 = this._isTable;
            this._isTable = bl;
            this.firePropertyChange("tableOrView", bl2, bl);
        }

        public boolean isTableOrView() {
            return this._isTable;
        }

        public synchronized void changeColumns(ColumnElement[] columnElementArray, int n) throws DBException {
            this.initColumns();
            this.columns.change(columnElementArray, n);
        }

        public synchronized ColumnElement[] getColumns() {
            this.initColumns();
            return (ColumnElement[])this.columns.getElements();
        }

        public synchronized ColumnElement getColumn(DBIdentifier dBIdentifier) {
            this.initColumns();
            return (ColumnElement)this.columns.getElement(dBIdentifier);
        }

        void initColumns() {
            if (this.columns == null) {
                this.columns = new DBMemoryCollection.Column(this);
            }
        }

        public synchronized void changeIndexes(IndexElement[] indexElementArray, int n) throws DBException {
            this.initIndexes();
            this.indexes.change(indexElementArray, n);
        }

        public synchronized IndexElement[] getIndexes() {
            this.initIndexes();
            return (IndexElement[])this.indexes.getElements();
        }

        public synchronized IndexElement getIndex(DBIdentifier dBIdentifier) {
            this.initIndexes();
            return (IndexElement)this.indexes.getElement(dBIdentifier);
        }

        void initIndexes() {
            if (this.indexes == null) {
                this.indexes = new DBMemoryCollection.Index(this);
            }
        }

        public synchronized void changeKeys(KeyElement[] keyElementArray, int n) throws DBException {
            this.initKeys();
            this.keys.change(keyElementArray, n);
        }

        public synchronized KeyElement[] getKeys() {
            this.initKeys();
            return (KeyElement[])this.keys.getElements();
        }

        public synchronized KeyElement getKey(DBIdentifier dBIdentifier) {
            this.initKeys();
            return (KeyElement)this.keys.getElement(dBIdentifier);
        }

        void initKeys() {
            if (this.keys == null) {
                this.keys = new DBMemoryCollection.Key(this);
            }
        }

        final TableElement getTableElement() {
            return (TableElement)this._element;
        }

        public synchronized ColumnPairElement[] getColumnPairs() {
            this.initColumnPairs();
            return (ColumnPairElement[])this.pairs.getElements();
        }

        public synchronized ColumnPairElement getColumnPair(DBIdentifier dBIdentifier) {
            this.initColumnPairs();
            return (ColumnPairElement)this.pairs.getElement(dBIdentifier);
        }

        public synchronized void changeColumnPairs(ColumnPairElement[] columnPairElementArray, int n) throws DBException {
            this.initColumnPairs();
            this.pairs.change(columnPairElementArray, n);
        }

        void initColumnPairs() {
            if (this.pairs == null) {
                this.pairs = new DBMemoryCollection.ColumnPair(this);
            }
        }
    }

    public static interface Impl
    extends DBElement.Impl {
        public void setTableOrView(boolean var1) throws DBException;

        public boolean isTableOrView();

        public void changeColumns(ColumnElement[] var1, int var2) throws DBException;

        public ColumnElement[] getColumns();

        public ColumnElement getColumn(DBIdentifier var1);

        public void changeIndexes(IndexElement[] var1, int var2) throws DBException;

        public IndexElement[] getIndexes();

        public IndexElement getIndex(DBIdentifier var1);

        public void changeKeys(KeyElement[] var1, int var2) throws DBException;

        public KeyElement[] getKeys();

        public KeyElement getKey(DBIdentifier var1);

        public void changeColumnPairs(ColumnPairElement[] var1, int var2) throws DBException;

        public ColumnPairElement[] getColumnPairs();

        public ColumnPairElement getColumnPair(DBIdentifier var1);
    }
}

