/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DDLBridge;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.SortedListModel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class DBSchemaTablesPanel
extends JPanel
implements ListDataListener {
    private final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private LinkedList tables;
    private LinkedList views;
    private ConnectionProvider cp;
    private String schema;
    private DatabaseConnection dbconnOld;
    private DBSchemaWizardData data;
    private int tablesCount;
    private ArrayList list;
    private JScrollPane jScrollPaneSelectedTables;
    private JLabel jLabelNote;
    private JButton jButtonAddAll;
    private JList jListSelectedTables;
    private JButton jButtonAdd;
    private JPanel jPanelButtons;
    private JButton jButtonRemoveAll;
    private JLabel jLabelSelectedTables;
    private JList jListAvailableTables;
    private JButton jButtonRemove;
    private JScrollPane jScrollPaneAvailableTables;
    private JLabel jLabelAvailableTables;

    public DBSchemaTablesPanel(DBSchemaWizardData dBSchemaWizardData, ArrayList arrayList) {
        this.list = arrayList;
        this.data = dBSchemaWizardData;
        this.tables = new LinkedList();
        this.views = new LinkedList();
        this.cp = null;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
        this.setName(this.bundle.getString("TablesChooser"));
        this.initComponents();
        this.initAccessibility();
        this.jLabelAvailableTables.setDisplayedMnemonic(this.bundle.getString("AvailableTables_Mnemonic").charAt(0));
        this.jLabelSelectedTables.setDisplayedMnemonic(this.bundle.getString("SelectedTables_Mnemonic").charAt(0));
        this.jButtonAdd.setMnemonic(this.bundle.getString("AddButton_Mnemonic").charAt(0));
        this.jButtonRemove.setMnemonic(this.bundle.getString("RemoveButton_Mnemonic").charAt(0));
        this.jButtonAddAll.setMnemonic(this.bundle.getString("AddAllButton_Mnemonic").charAt(0));
        this.jButtonRemoveAll.setMnemonic(this.bundle.getString("RemoveAllButton_Mnemonic").charAt(0));
        this.jListAvailableTables.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jListAvailableTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(84, 8), 2);
        this.jListSelectedTables.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jListSelectedTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(83, 8), 2);
        this.jListSelectedTables.getModel().addListDataListener(this);
        this.jListAvailableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DBSchemaTablesPanel.this.jButtonAdd.setEnabled(DBSchemaTablesPanel.this.jListAvailableTables.getSelectedIndex() != -1);
            }
        });
        this.jListSelectedTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DBSchemaTablesPanel.this.jButtonRemove.setEnabled(DBSchemaTablesPanel.this.jListSelectedTables.getSelectedIndex() != -1);
            }
        });
    }

    protected boolean init() {
        String string = null;
        Connection connection = null;
        boolean bl = true;
        if (this.data.getConnectionProvider() != null) {
            if (this.data.getDatabaseConnection() == this.dbconnOld) {
                bl = false;
            }
            if (bl) {
                this.cp = this.data.getConnectionProvider();
                this.uninit();
            }
        }
        if (bl) {
            int n;
            Object object;
            this.data.setConnected(false);
            if (this.data.isExistingConn()) {
                object = this.data.getDatabaseConnection();
                connection = object.getJDBCConnection();
                if (connection != null) {
                    try {
                        connection.getCatalog();
                    }
                    catch (SQLException sQLException) {
                        connection = null;
                    }
                }
                if (connection == null) {
                    ConnectionManager.getDefault().showConnectionDialog((DatabaseConnection)object);
                    connection = object.getJDBCConnection();
                    if (connection != null) {
                        try {
                            connection.getCatalog();
                        }
                        catch (SQLException sQLException) {
                            connection = null;
                            this.data.setConnected(false);
                            return false;
                        }
                    }
                    this.data.setConnected(true);
                }
                this.schema = object.getSchema();
                string = object.getDriverClass();
                this.dbconnOld = object;
            }
            try {
                if (connection == null) {
                    return false;
                }
                this.cp = new ConnectionProvider(connection, string);
                this.cp.setSchema(this.schema);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.data.setConnectionProvider(this.cp);
            this.tables.clear();
            this.views.clear();
            try {
                object = new DDLBridge(this.cp.getConnection(), this.cp.getSchema(), this.cp.getDatabaseMetaData());
                ((DDLBridge)object).getDriverSpecification().getTables("%", new String[]{"TABLE"});
                ResultSet resultSet = ((DDLBridge)object).getDriverSpecification().getResultSet();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        this.tables.add(resultSet.getString("TABLE_NAME").trim());
                    }
                    resultSet.close();
                }
                resultSet = null;
                if (((DDLBridge)object).getDriverSpecification().areViewsSupported()) {
                    ((DDLBridge)object).getDriverSpecification().getTables("%", new String[]{"VIEW"});
                    resultSet = ((DDLBridge)object).getDriverSpecification().getResultSet();
                }
                if (resultSet != null) {
                    while (resultSet.next()) {
                        this.views.add(resultSet.getString("TABLE_NAME").trim());
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ErrorManager.getDefault().notify((Throwable)sQLException);
            }
            ((SortedListModel)this.jListAvailableTables.getModel()).clear();
            ((SortedListModel)this.jListSelectedTables.getModel()).clear();
            this.tablesCount = this.tables.size();
            for (n = 0; n < this.tables.size(); ++n) {
                ((SortedListModel)this.jListAvailableTables.getModel()).add(this.bundle.getString("TablePrefix") + " " + this.tables.get(n).toString());
            }
            for (n = 0; n < this.views.size(); ++n) {
                ((SortedListModel)this.jListAvailableTables.getModel()).add(this.bundle.getString("ViewPrefix") + " " + this.views.get(n).toString());
            }
            if (this.jListAvailableTables.getModel().getSize() > 0) {
                this.jListAvailableTables.setSelectedIndex(0);
            }
            this.tables.clear();
            this.views.clear();
        }
        this.updateButtons();
        return true;
    }

    public void uninit() {
        try {
            if (this.cp != null && this.data.isConnected()) {
                if (this.data.isExistingConn()) {
                    ConnectionManager.getDefault().disconnect(this.dbconnOld);
                } else if (this.dbconnOld.getJDBCConnection() != null) {
                    ConnectionManager.getDefault().disconnect(this.dbconnOld);
                } else {
                    this.cp.closeConnection();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_TablesPanelA11yDesc"));
        this.jLabelAvailableTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_AvailableTablesA11yDesc"));
        this.jListAvailableTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_AvailableTablesListA11yName"));
        this.jLabelSelectedTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_SelectedTablesA11yDesc"));
        this.jListSelectedTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_SelectedTablesListA11yName"));
        this.jLabelNote.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_FKReferenceNoteA11yDesc"));
    }

    private void initComponents() {
        this.jLabelAvailableTables = new JLabel();
        this.jScrollPaneAvailableTables = new JScrollPane();
        this.jListAvailableTables = new JList();
        this.jPanelButtons = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonRemoveAll = new JButton();
        this.jLabelSelectedTables = new JLabel();
        this.jScrollPaneSelectedTables = new JScrollPane();
        this.jListSelectedTables = new JList();
        this.jLabelNote = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabelAvailableTables.setText(this.bundle.getString("AvailableTables"));
        this.jLabelAvailableTables.setLabelFor(this.jListAvailableTables);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabelAvailableTables, gridBagConstraints);
        this.jListAvailableTables.setToolTipText(this.bundle.getString("ACS_AvailableTablesListA11yDesc"));
        this.jListAvailableTables.setModel(new SortedListModel());
        this.jScrollPaneAvailableTables.setViewportView(this.jListAvailableTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.jScrollPaneAvailableTables, gridBagConstraints);
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jButtonAdd.setToolTipText(this.bundle.getString("ACS_AddButtonA11yDesc"));
        this.jButtonAdd.setText(this.bundle.getString("AddButton"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jButtonAddActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanelButtons.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonRemove.setToolTipText(this.bundle.getString("ACS_RemoveButtonA11yDesc"));
        this.jButtonRemove.setText(this.bundle.getString("RemoveButton"));
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jButtonRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemove, gridBagConstraints);
        this.jButtonAddAll.setToolTipText(this.bundle.getString("ACS_AddAllButtonA11yDesc"));
        this.jButtonAddAll.setText(this.bundle.getString("AddAllButton"));
        this.jButtonAddAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jButtonAddAllActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonAddAll, gridBagConstraints);
        this.jButtonRemoveAll.setToolTipText(this.bundle.getString("ACS_RemoveAllButtonA11yDesc"));
        this.jButtonRemoveAll.setText(this.bundle.getString("RemoveAllButton"));
        this.jButtonRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jButtonRemoveAllActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemoveAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(12, 11, 0, 11);
        this.add((Component)this.jPanelButtons, gridBagConstraints);
        this.jLabelSelectedTables.setText(this.bundle.getString("SelectedTables"));
        this.jLabelSelectedTables.setLabelFor(this.jListSelectedTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.add((Component)this.jLabelSelectedTables, gridBagConstraints);
        this.jListSelectedTables.setToolTipText(this.bundle.getString("ACS_SelectedTablesListA11yDesc"));
        this.jListSelectedTables.setModel(new SortedListModel());
        this.jScrollPaneSelectedTables.setViewportView(this.jListSelectedTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.jScrollPaneSelectedTables, gridBagConstraints);
        this.jLabelNote.setText(this.bundle.getString("FKReferenceNote"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.jLabelNote, gridBagConstraints);
    }

    private void jButtonRemoveAllActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = sortedListModel2.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel.add(objectArray[i]);
            sortedListModel2.remove(objectArray[i]);
        }
        this.tables.clear();
        this.views.clear();
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel.indexOf(objectArray[i]);
        }
        this.jListAvailableTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddAllActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = sortedListModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel2.add(objectArray[i]);
            sortedListModel.remove(objectArray[i]);
            String string = objectArray[i].toString();
            if (string.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(string.substring(string.indexOf(" ") + 1));
                continue;
            }
            this.views.add(string.substring(string.indexOf(" ") + 1));
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel2.indexOf(objectArray[i]);
        }
        this.jListSelectedTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonRemoveActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = this.jListSelectedTables.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel.add(objectArray[i]);
            sortedListModel2.remove(objectArray[i]);
            String string = objectArray[i].toString();
            string = string.substring(string.indexOf(" ")).trim();
            if (this.tables.contains(string)) {
                this.tables.remove(string);
                continue;
            }
            this.views.remove(string);
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel.indexOf(objectArray[i]);
        }
        this.jListAvailableTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = this.jListAvailableTables.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel2.add(objectArray[i]);
            sortedListModel.remove(objectArray[i]);
            String string = objectArray[i].toString();
            if (string.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(string.substring(string.indexOf(" ") + 1));
                continue;
            }
            this.views.add(string.substring(string.indexOf(" ") + 1));
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel2.indexOf(objectArray[i]);
        }
        this.jListSelectedTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void setSelection() {
        this.data.setTables(this.tables);
        this.data.setViews(this.views);
        if (this.tablesCount == this.tables.size()) {
            this.data.setAllTables(true);
        } else {
            this.data.setAllTables(false);
        }
    }

    private void updateButtons() {
        this.jButtonAdd.setEnabled(this.jListAvailableTables.getSelectedIndex() != -1);
        this.jButtonAddAll.setEnabled(!((SortedListModel)this.jListAvailableTables.getModel()).isEmpty());
        this.jButtonRemove.setEnabled(this.jListSelectedTables.getSelectedIndex() != -1);
        this.jButtonRemoveAll.setEnabled(!((SortedListModel)this.jListSelectedTables.getModel()).isEmpty());
    }

    public boolean isValid() {
        return this.jListSelectedTables.getModel().getSize() > 0;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object object) {
        ArrayList arrayList;
        Serializable serializable = this;
        synchronized (serializable) {
            arrayList = (ArrayList)this.list.clone();
        }
        serializable = new ChangeEvent(object);
        for (int i = 0; i < arrayList.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)arrayList.get(i);
            changeListener.stateChanged((ChangeEvent)serializable);
        }
    }
}

