/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.filter;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.CacheManagerListener;
import com.sun.appserv.web.cache.filter.CachingResponseWrapper;
import com.sun.appserv.web.cache.filter.HttpCacheEntry;
import com.sun.enterprise.web.logging.pwc.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CachingFilter
implements Filter,
CacheManagerListener {
    String filterName;
    String servletName;
    String urlPattern;
    CacheManager manager;
    CacheHelper helper;
    Cache cache;
    boolean isEnabled = false;
    private static Logger _logger = null;
    private static boolean _isTraceEnabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterName = filterConfig.getFilterName();
        this.servletName = filterConfig.getInitParameter("servletName");
        this.urlPattern = filterConfig.getInitParameter("URLPattern");
        ServletContext context = filterConfig.getServletContext();
        this.manager = (CacheManager)context.getAttribute("com.sun.appserv.web.CacheManager");
        if (this.manager != null && this.manager.isEnabled()) {
            this.cache = this.manager.getDefaultCache();
            this.helper = this.manager.getCacheHelperByFilterName(this.filterName);
            this.manager.addCacheManagerListener(this);
            this.isEnabled = true;
        }
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web.pwc");
            _isTraceEnabled = _logger.isLoggable(Level.FINE);
        }
        if (_isTraceEnabled) {
            _logger.fine("CachingFilter " + this.filterName + " ready; isEnabled = " + this.isEnabled + " manager = " + this.manager);
        }
    }

    public void doFilter(ServletRequest srequest, ServletResponse sresponse, FilterChain chain) throws IOException, ServletException {
        String key;
        HttpServletRequest request = (HttpServletRequest)srequest;
        HttpServletResponse response = (HttpServletResponse)sresponse;
        request.setAttribute("com.sun.ias.web.cachingFilterName", (Object)this.filterName);
        request.setAttribute("com.sun.appserv.web.cachedServletName", (Object)this.servletName);
        request.setAttribute("com.sun.appserv.web.cachedURLPattern", (Object)this.urlPattern);
        if (this.isEnabled && this.helper.isCacheable(request) && (key = this.helper.getCacheKey(request)) != null) {
            int index = this.cache.getIndex(key);
            if (_isTraceEnabled) {
                _logger.fine("CachingFilter " + request.getServletPath() + " request is cacheable; key " + key + " index = " + index);
            }
            HttpCacheEntry entry = null;
            boolean entryReady = false;
            boolean waitForRefresh = true;
            if (!this.helper.isRefreshNeeded(request)) {
                do {
                    if ((entry = (HttpCacheEntry)this.cache.get(key)) == null || !entry.isValid()) continue;
                    entryReady = true;
                    break;
                } while (waitForRefresh = this.cache.waitRefresh(index));
            } else if (_isTraceEnabled) {
                _logger.fine("CachingFilter " + request.getServletPath() + " request needs a refresh; key " + key);
            }
            if (entryReady) {
                if (_isTraceEnabled) {
                    _logger.fine("CachingFilter " + request.getServletPath() + " serving response from the cache " + key);
                }
                this.sendCachedResponse(entry, response);
            } else {
                CachingResponseWrapper wrapper = new CachingResponseWrapper(response);
                try {
                    chain.doFilter(srequest, (ServletResponse)wrapper);
                }
                catch (ServletException se) {
                    wrapper.clear();
                    throw se;
                }
                catch (IOException ioe) {
                    wrapper.clear();
                    throw ioe;
                }
                if (!wrapper.isError()) {
                    int timeout = this.helper.getTimeout(request);
                    entry = wrapper.cacheResponse();
                    if (timeout == -2) {
                        Long lval = wrapper.getExpiresDateHeader();
                        if (lval == null) {
                            timeout = this.manager.getDefaultTimeout();
                            entry.computeExpireTime(timeout);
                        } else {
                            long expireTime = lval;
                            entry.setExpireTime(expireTime);
                        }
                    } else {
                        entry.computeExpireTime(timeout);
                    }
                    HttpCacheEntry oldEntry = (HttpCacheEntry)this.cache.put(key, entry, entry.getSize());
                    this.cache.notifyRefresh(index);
                    this.writeBody(entry, response);
                } else {
                    HttpCacheEntry oldEntry = (HttpCacheEntry)this.cache.remove(key);
                }
                wrapper.clear();
            }
        } else {
            if (_isTraceEnabled) {
                _logger.fine("CachingFilter " + request.getServletPath() + " pass thru; isEnabled = " + this.isEnabled);
            }
            request.removeAttribute("com.sun.ias.web.cachingFilterName");
            request.removeAttribute("com.sun.appserv.web.cachedServletName");
            request.removeAttribute("com.sun.appserv.web.cachedURLPattern");
            chain.doFilter(srequest, sresponse);
        }
    }

    private void sendCachedResponse(HttpCacheEntry entry, HttpServletResponse response) throws IOException {
        int i;
        ArrayList values;
        if (entry.statusCode != -1) {
            response.setStatus(entry.statusCode);
        }
        for (String name : entry.responseHeaders.keySet()) {
            values = (ArrayList)entry.responseHeaders.get(name);
            for (i = 0; i < values.size(); ++i) {
                response.addHeader(name, (String)values.get(i));
            }
        }
        for (String name : entry.dateHeaders.keySet()) {
            values = (ArrayList)entry.dateHeaders.get(name);
            for (i = 0; i < values.size(); ++i) {
                response.addDateHeader(name, ((Long)values.get(i)).longValue());
            }
        }
        for (int i2 = 0; i2 < entry.cookies.size(); ++i2) {
            response.addCookie((Cookie)entry.cookies.get(i2));
        }
        if (entry.contentLength != -1) {
            response.setContentLength(entry.contentLength);
        }
        if (entry.contentType != null) {
            response.setContentType(entry.contentType);
        }
        if (entry.locale != null) {
            response.setLocale(entry.locale);
        }
        this.writeBody(entry, response);
    }

    private void writeBody(HttpCacheEntry entry, HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        out.write(entry.bytes);
    }

    public void cacheManagerEnabled() {
        if (_isTraceEnabled) {
            _logger.fine("CachingFilter " + this.filterName + " received cacheManager enabled event.");
        }
        this.isEnabled = true;
    }

    public void cacheManagerDisabled() {
        if (_isTraceEnabled) {
            _logger.fine("CachingFilter " + this.filterName + " received cacheManager disabled event.");
        }
        this.isEnabled = false;
    }

    public void destroy() {
    }
}

