/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject.newreflect;

import com.sun.corba.ee.impl.copyobject.newreflect.CachingClassCopierFactory;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopier;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactory;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierOrdinaryImpl;
import com.sun.corba.ee.impl.copyobject.newreflect.DefaultClassCopierFactories;
import com.sun.corba.ee.impl.copyobject.newreflect.DefaultClassCopiers;
import com.sun.corba.ee.impl.copyobject.newreflect.PipelineClassCopierFactory;
import com.sun.corba.ee.spi.copyobject.ReflectiveCopyException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCopierFactoryPipelineImpl
implements PipelineClassCopierFactory {
    private Class[] notCopyable = new Class[]{Thread.class, ThreadGroup.class, ProcessBuilder.class};
    private Class[] immutable = new Class[]{Process.class, Class.class, ClassLoader.class, SecurityManager.class, Runtime.class, System.class, Package.class, Field.class, Method.class, Constructor.class, AccessControlContext.class, Object.class, String.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class};
    private CachingClassCopierFactory cacheFactory = DefaultClassCopierFactories.makeCachingClassCopierFactory();
    private ClassCopierFactory specialFactory = DefaultClassCopierFactories.getNullClassCopierFactory();
    private ClassCopierFactory arrayFactory = DefaultClassCopierFactories.makeArrayClassCopierFactory(this);
    private ClassCopierFactory ordinaryFactory = DefaultClassCopierFactories.makeOrdinaryClassCopierFactory(this);
    private ClassCopier errorCopier = DefaultClassCopiers.getErrorClassCopier();

    public ClassCopierFactoryPipelineImpl() {
        for (Class cls : this.immutable) {
            this.registerImmutable(cls);
        }
        ClassCopier mapCopier = DefaultClassCopiers.makeMapClassCopier(this);
        if (!ClassCopierOrdinaryImpl.jdkSupportsUnsafe()) {
            this.cacheFactory.put(LinkedHashMap.class, mapCopier);
            this.cacheFactory.put(HashMap.class, mapCopier);
            this.cacheFactory.put(Hashtable.class, mapCopier);
            this.cacheFactory.put(TreeMap.class, mapCopier);
            this.cacheFactory.put(Properties.class, this.errorCopier);
        }
        this.cacheFactory.put(IdentityHashMap.class, mapCopier);
        for (Class cls : this.notCopyable) {
            this.cacheFactory.put(cls, this.errorCopier);
        }
    }

    @Override
    public boolean reflectivelyCopyable(Class<?> cls) {
        for (Class cl : this.notCopyable) {
            if (cls != cl) continue;
            return false;
        }
        return true;
    }

    public ClassCopier lookupInCache(Class cls) {
        try {
            return this.cacheFactory.getClassCopier(cls);
        }
        catch (ReflectiveCopyException exc) {
            return null;
        }
    }

    public synchronized void registerImmutable(Class cls) {
        this.cacheFactory.put(cls, DefaultClassCopiers.getIdentityClassCopier());
    }

    @Override
    public void setSpecialClassCopierFactory(ClassCopierFactory ccf) {
        this.specialFactory = ccf;
    }

    @Override
    public synchronized ClassCopier getClassCopier(Class cls) throws ReflectiveCopyException {
        if (cls.isInterface()) {
            throw new IllegalArgumentException("Cannot create a ClassCopier for an interface.");
        }
        ClassCopier result = this.cacheFactory.getClassCopier(cls);
        if (result == null) {
            if (Enum.class.isAssignableFrom(cls)) {
                result = DefaultClassCopiers.getIdentityClassCopier();
            }
            if (result == null) {
                result = this.specialFactory.getClassCopier(cls);
            }
            if (result == null) {
                result = this.arrayFactory.getClassCopier(cls);
            }
            if (result == null) {
                result = this.ordinaryFactory.getClassCopier(cls);
            }
            if (result == null) {
                throw new IllegalStateException("Could not find ClassCopier for " + cls.getClass());
            }
            this.cacheFactory.put(cls, result);
        }
        if (result == this.errorCopier) {
            throw new ReflectiveCopyException("Cannot copy class " + cls);
        }
        return result;
    }
}

