/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.fsm;

import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.Guard;
import com.sun.corba.ee.spi.orbutil.fsm.Input;
import com.sun.corba.ee.spi.orbutil.fsm.InputImpl;
import com.sun.corba.ee.spi.orbutil.fsm.MyFSM;
import com.sun.corba.ee.spi.orbutil.fsm.State;
import com.sun.corba.ee.spi.orbutil.fsm.StateEngine;
import com.sun.corba.ee.spi.orbutil.fsm.StateEngineFactory;
import com.sun.corba.ee.spi.orbutil.fsm.StateImpl;
import com.sun.corba.ee.spi.orbutil.fsm.TestAction1;
import com.sun.corba.ee.spi.orbutil.fsm.TestAction2;
import com.sun.corba.ee.spi.orbutil.fsm.TestAction3;
import com.sun.corba.ee.spi.orbutil.fsm.TestInput;

public class FSMTest {
    public static final State STATE1 = new StateImpl("1");
    public static final State STATE2 = new StateImpl("2");
    public static final State STATE3 = new StateImpl("3");
    public static final State STATE4 = new StateImpl("4");
    public static final Input INPUT1 = new InputImpl("1");
    public static final Input INPUT2 = new InputImpl("2");
    public static final Input INPUT3 = new InputImpl("3");
    public static final Input INPUT4 = new InputImpl("4");
    private Guard counterGuard = new Guard(){

        public Guard.Result evaluate(FSM fsm, Input in) {
            MyFSM mfsm = (MyFSM)fsm;
            return Guard.Result.convert(mfsm.counter < 3);
        }
    };

    private static void add1(StateEngine se, State oldState, Input in, State newState) {
        se.add(oldState, in, new TestAction1(oldState, in, newState), newState);
    }

    private static void add2(StateEngine se, State oldState, State newState) {
        se.setDefault(oldState, new TestAction2(oldState, newState), newState);
    }

    public static void main(String[] args) {
        TestAction3 ta3 = new TestAction3(STATE3, INPUT1);
        StateEngine se = StateEngineFactory.create();
        FSMTest.add1(se, STATE1, INPUT1, STATE1);
        FSMTest.add2(se, STATE1, STATE2);
        FSMTest.add1(se, STATE2, INPUT1, STATE2);
        FSMTest.add1(se, STATE2, INPUT2, STATE2);
        FSMTest.add1(se, STATE2, INPUT3, STATE1);
        FSMTest.add1(se, STATE2, INPUT4, STATE3);
        se.add(STATE3, INPUT1, ta3, STATE3);
        se.add(STATE3, INPUT1, ta3, STATE4);
        FSMTest.add1(se, STATE3, INPUT2, STATE1);
        FSMTest.add1(se, STATE3, INPUT3, STATE2);
        FSMTest.add1(se, STATE3, INPUT4, STATE2);
        MyFSM fsm = new MyFSM(se);
        TestInput in11 = new TestInput(INPUT1, "1.1");
        TestInput in12 = new TestInput(INPUT1, "1.2");
        TestInput in21 = new TestInput(INPUT2, "2.1");
        TestInput in22 = new TestInput(INPUT2, "2.2");
        TestInput in31 = new TestInput(INPUT3, "3.1");
        TestInput in32 = new TestInput(INPUT3, "3.2");
        TestInput in33 = new TestInput(INPUT3, "3.3");
        TestInput in41 = new TestInput(INPUT4, "4.1");
        fsm.doIt(in11.getInput());
        fsm.doIt(in12.getInput());
        fsm.doIt(in41.getInput());
        fsm.doIt(in11.getInput());
        fsm.doIt(in22.getInput());
        fsm.doIt(in31.getInput());
        fsm.doIt(in33.getInput());
        fsm.doIt(in41.getInput());
        fsm.doIt(in41.getInput());
        fsm.doIt(in41.getInput());
        fsm.doIt(in22.getInput());
        fsm.doIt(in32.getInput());
        fsm.doIt(in41.getInput());
        fsm.doIt(in11.getInput());
        fsm.doIt(in12.getInput());
        fsm.doIt(in11.getInput());
        fsm.doIt(in11.getInput());
        fsm.doIt(in11.getInput());
        fsm.doIt(in11.getInput());
        fsm.doIt(in11.getInput());
    }
}

