/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.stats;

import com.sun.enterprise.admin.monitor.stats.MutableTimeStatisticImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class MethodMonitor {
    private String methodName;
    private boolean monitorOn = true;
    private static ThreadLocal execThreadLocal = new ThreadLocal();
    private Object lock = new Object();
    private int successCount = 0;
    private int errorCount = 0;
    private int invocationCount = 0;
    private long totalExecutionTime = 0L;
    private MutableTimeStatisticImpl methodStat;

    public MethodMonitor(Method method) {
        this.methodName = this.constructMethodName(method);
        this.monitorOn = true;
    }

    void setMutableTimeStatisticImpl(MutableTimeStatisticImpl methodStat) {
        this.methodStat = methodStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvoke() {
        if (this.monitorOn) {
            ArrayList<Long> list = (ArrayList<Long>)execThreadLocal.get();
            if (list == null) {
                list = new ArrayList<Long>(5);
                execThreadLocal.set(list);
            }
            list.add(new Long(System.currentTimeMillis()));
            Object object = this.lock;
            synchronized (object) {
                ++this.invocationCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(Throwable th) {
        ArrayList list;
        if (this.monitorOn && (list = (ArrayList)execThreadLocal.get()) != null && list.size() > 0) {
            int index = list.size();
            Long startTime = (Long)list.remove(index - 1);
            Object object = this.lock;
            synchronized (object) {
                if (th == null) {
                    ++this.successCount;
                } else {
                    ++this.errorCount;
                }
                if (startTime != null) {
                    long diff;
                    this.totalExecutionTime = diff = System.currentTimeMillis() - startTime;
                    this.methodStat.incrementCount(diff);
                }
            }
        }
    }

    public void resetAllStats(boolean monitorOn) {
        this.successCount = 0;
        this.errorCount = 0;
        this.invocationCount = 0;
        this.totalExecutionTime = 0L;
        this.monitorOn = monitorOn;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getTotalInvocations() {
        return this.invocationCount;
    }

    public long getExecutionTime() {
        return this.totalExecutionTime;
    }

    public int getTotalNumErrors() {
        return this.errorCount;
    }

    public int getTotalNumSuccess() {
        return this.successCount;
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("\n\t[Method ").append("name=").append(this.methodName).append("; ").append("invCount=").append(this.invocationCount).append("; ").append("success=").append(this.successCount).append("; ").append("errors=").append(this.errorCount).append("; ").append("totalTime=").append(this.totalExecutionTime).append("]");
    }

    private String constructMethodName(Method method) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(method.getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        int sz = paramTypes.length;
        if (sz > 0) {
            String dash = "-";
            for (int i = 0; i < sz; ++i) {
                sbuf.append(dash).append(paramTypes[i].getName());
            }
        }
        return sbuf.toString();
    }
}

