/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class CallbackInterceptor {
    protected int index;
    protected Method method;

    CallbackInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
    }

    Object intercept(final CallbackInvocationContext invContext) throws Throwable {
        try {
            EJBContextImpl ejbContextImpl = (EJBContextImpl)invContext.getEJBContext();
            final Object[] interceptors = ejbContextImpl.getInterceptorInstances();
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!CallbackInterceptor.this.method.isAccessible()) {
                        CallbackInterceptor.this.method.setAccessible(true);
                    }
                    return CallbackInterceptor.this.method.invoke(interceptors[CallbackInterceptor.this.index], invContext);
                }
            });
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    public String toString() {
        return "callback[" + this.index + "]: " + this.method;
    }
}

