/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.config;

import com.sun.enterprise.admin.MBeanHelper;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.meta.MBeanMetaHelper;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.meta.naming.MBeanNamingDescriptor;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;

public class ConfigMBeanHelper
extends MBeanHelper {
    private static final String XPATH_SEPARATOR = "/";
    public static final String PROPERTY_NAME_PREFIX = "property.";
    public static final String PROPERTY_SPECIAL_EMPTY_VALUE = "()";
    private ConfigBean m_baseConfigBean;
    private BaseConfigMBean m_mbean;

    public ConfigMBeanHelper(BaseConfigMBean mbean, ConfigBean cb) {
        this.m_baseConfigBean = cb;
        this.m_mbean = mbean;
    }

    public static Object converConfigBeansToObjectNames(MBeanRegistry registry, ModelMBeanInfo parentInfo, Object ret) throws Exception {
        if (ret != null) {
            if (ret instanceof ConfigBean) {
                return ConfigMBeanHelper.getChildObjectName(registry, parentInfo, (ConfigBean)ret);
            }
            if (ret instanceof ConfigBean[]) {
                return ConfigMBeanHelper.getChildObjectNames(registry, parentInfo, (ConfigBean[])ret);
            }
        }
        return ret;
    }

    public static Class getConfigBeanClass(String xPath) {
        String beanName = ConfigBeansFactory.getConfigBeanNameByXPath(xPath);
        try {
            Class<?> cl = Class.forName("com.sun.enterprise.config.serverbeans." + beanName);
            return cl;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static AttributeList getDefaultAttributeValues(MBeanNamingDescriptor descr, String[] attrNames) throws Exception {
        if (attrNames == null || attrNames.length < 1) {
            return null;
        }
        AttributeList attrs = new AttributeList();
        Class cl = ConfigMBeanHelper.getConfigBeanClass(descr.getXPathPattern());
        if (cl == null) {
            return null;
        }
        Method method = cl.getDeclaredMethod("getDefaultAttributeValue", Class.forName("java.lang.String"));
        for (int i = 0; i < attrNames.length; ++i) {
            try {
                String value = (String)method.invoke(null, MBeanMetaHelper.mapToConfigBeanAttributeName(attrNames[i]));
                if (value == null) continue;
                attrs.add(new Attribute(attrNames[i], value));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attrs;
    }

    public static ObjectName getOwnObjectName(MBeanRegistry registry, ModelMBeanInfo parentInfo) throws Exception {
        Descriptor descr = parentInfo.getMBeanDescriptor();
        String type = (String)descr.getFieldValue("namingType");
        Object[] location = (String[])descr.getFieldValue("namingLocation");
        MBeanRegistryEntry entry = registry.findMBeanRegistryEntryByType(type);
        MBeanNamingDescriptor namingDescr = entry.getNamingDescriptor();
        return namingDescr.createObjectName(location);
    }

    public static ObjectName[] getChildObjectNames(MBeanRegistry registry, ModelMBeanInfo parentInfo, ConfigBean[] children) throws Exception {
        Descriptor descr = parentInfo.getMBeanDescriptor();
        return ConfigMBeanHelper.getConfigBeansObjectNames(registry, (String)descr.getFieldValue("domainName"), children);
    }

    public static ObjectName getChildObjectName(MBeanRegistry registry, ModelMBeanInfo parentInfo, ConfigBean childBean) throws Exception {
        Descriptor descr = parentInfo.getMBeanDescriptor();
        return ConfigMBeanHelper.getConfigBeanObjectName(registry, (String)descr.getFieldValue("domainName"), childBean);
    }

    public static ObjectName[] getConfigBeansObjectNames(MBeanRegistry registry, String domainName, ConfigBean[] beans) throws Exception {
        ObjectName[] objNames = new ObjectName[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            objNames[i] = ConfigMBeanHelper.getConfigBeanObjectName(registry, domainName, beans[i]);
        }
        return objNames;
    }

    public static ObjectName getConfigBeanObjectName(MBeanRegistry registry, String domainName, ConfigBean childBean) throws Exception {
        String xpath = childBean.getAbsoluteXPath("");
        MBeanRegistryEntry entry = registry.findMBeanRegistryEntryByXPath(xpath);
        MBeanNamingDescriptor namingDescr = entry.getNamingDescriptor();
        String[] location = namingDescr.extractParmListFromXPath(xpath);
        location[0] = domainName;
        return namingDescr.createObjectName(location);
    }

    public static String[] getChildNamesList(ConfigBean[] beans) throws Exception {
        String[] names = new String[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            String xpath = beans[i].getAbsoluteXPath("");
            names[i] = MBeanMetaHelper.getMultipleElementKeyValue(xpath);
        }
        return names;
    }

    protected static void debug(String s) {
        System.out.println(s);
    }

    protected static void info(String s) {
        System.out.println(s);
    }

    protected static void error(String s) {
        System.out.println(s);
    }

    public ConfigBean getChildElementByName(String methodName, String name) throws MBeanException, AttributeNotFoundException {
        Class<?> cl = this.m_baseConfigBean.getClass();
        try {
            Method method = cl.getDeclaredMethod(methodName, Class.forName("java.lang.String"));
            return (ConfigBean)method.invoke((Object)this.m_baseConfigBean, name);
        }
        catch (Exception e) {
            String msg = "admin.server.core.mbean.config.getattribute.undefined_childelement_in_base_element" + name;
            throw new MBeanException(new MBeanConfigException(msg));
        }
    }

    public Object getPropertyElementValue(String propertyName) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        Class<?> cl = this.m_baseConfigBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)this.m_baseConfigBean, propertyName);
        }
        catch (Exception e) {
            String msg = "admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element" + propertyName;
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null) {
            String msg = "admin.server.core.mbean.config.getattribute_properties_not_found_in_base_element" + propertyName;
            throw new MBeanException(new MBeanConfigException(msg));
        }
        return prop.getValue();
    }

    public void setPropertyElementValue(Attribute attr, boolean bAllowsEmptyValue) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        Method method;
        String propertyName = attr.getName();
        String value = (String)attr.getValue();
        Class<?> cl = this.m_baseConfigBean.getClass();
        try {
            method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)this.m_baseConfigBean, propertyName);
        }
        catch (Exception e) {
            String msg = "admin.server.core.mbean.config.setattribute_undefined_properties_in_base_element" + propertyName;
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null && value != null && (bAllowsEmptyValue || !value.equals(""))) {
            prop = new ElementProperty();
            prop.setName(propertyName);
            prop.setValue(value);
            try {
                method = cl.getDeclaredMethod("addElementProperty", prop.getClass());
                method.invoke((Object)this.m_baseConfigBean, prop);
            }
            catch (Exception e) {
                String msg = "admin.server.core.mbean.config.setproperty_invoke_error" + propertyName;
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else if (value == null || !bAllowsEmptyValue && value.equals("")) {
            try {
                method = cl.getDeclaredMethod("removeElementProperty", prop.getClass());
                method.invoke((Object)this.m_baseConfigBean, prop);
            }
            catch (Exception e) {
                String msg = "admin.server.core.mbean.config.setproperty_could_not_remove_propery" + propertyName;
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else {
            prop.setValue(value);
        }
    }

    public static String convertTagName(String name) {
        StringBuffer n = new StringBuffer();
        boolean up = true;
        boolean keepCase = false;
        StringCharacterIterator ci = new StringCharacterIterator(name);
        char c = ci.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                keepCase = true;
                break;
            }
            c = ci.next();
        }
        c = ci.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_') {
                up = true;
            } else {
                if (up) {
                    c = Character.toUpperCase(c);
                } else if (!keepCase) {
                    c = Character.toLowerCase(c);
                }
                n.append(c);
                up = false;
            }
            c = ci.next();
        }
        return n.toString();
    }
}

