/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.AuditModuleEvent;
import com.sun.enterprise.admin.event.AuthRealmEvent;
import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.admin.event.DependencyResolver;
import com.sun.enterprise.admin.event.ElementChangeHelper;
import com.sun.enterprise.admin.event.EventBuilder;
import com.sun.enterprise.admin.event.LogLevelChangeEvent;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEvent;
import com.sun.enterprise.admin.event.ResourceDeployEvent;
import com.sun.enterprise.admin.event.SecurityServiceEvent;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.impl.ConfigUpdateImpl;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ElementChangeEventsFactory {
    static final String RESOURCE_REF_TYPE_NAME = "resource-ref";
    static final String APPLICATION_REF_TYPE_NAME = "application-ref";
    static final String MBEAN_TYPE_NAME = "mbean";

    static ArrayList createEvents(String event_type, String instanceName, String element_type, ArrayList changeList, ConfigContext ctx, ArrayList globalChangeList) throws Exception {
        int action = ElementChangeHelper.getActionCodeForChanges(changeList);
        if (action == 0) {
            return null;
        }
        ArrayList events = null;
        AdminEvent event = null;
        String element_xpath = ElementChangeHelper.getElementXPath(changeList);
        String targetName = ElementChangeHelper.getConfigElementTargetName(element_xpath, ctx);
        String element_id = ElementChangeHelper.getConfigElementPrimaryKey(element_xpath);
        if (event_type.equals(ApplicationDeployEvent.eventType) && APPLICATION_REF_TYPE_NAME.equals(element_type)) {
            try {
                if (ElementChangeEventsFactory.isMBeanReference(ctx, element_id, globalChangeList) && (events = ElementChangeEventsFactory.buildSelfConstructingEvent(event_type = "com.sun.enterprise.admin.event.MBeanElementChangeEvent", instanceName, element_type, changeList, ctx)) != null && (action == 1 || action == 2)) {
                    String actionCode = action == 1 ? "deploy" : "undeploy";
                    for (int i = 0; i < events.size(); ++i) {
                        AdminEvent ae = (AdminEvent)events.get(i);
                        String effective = ae.getEffectiveDestination();
                        DependencyResolver dr = new DependencyResolver(ctx, effective);
                        List list = dr.resolveApplications(element_id, actionCode);
                        ae.addDependentConfigChange(list);
                    }
                }
            }
            catch (Exception ce) {
                events = null;
            }
        }
        if ((events = ElementChangeEventsFactory.buildSelfConstructingEvent(event_type, instanceName, element_type, changeList, ctx)) != null) {
            return events;
        }
        boolean bMustSetChangeList = true;
        if (event_type.equals(SecurityServiceEvent.eventType)) {
            event = ElementChangeEventsFactory.createSecurityServiceEvent(instanceName, element_id, action);
        } else if (event_type.equals(AuditModuleEvent.eventType)) {
            event = ElementChangeEventsFactory.createAuditModuleEvent(instanceName, element_id, action);
        } else if (event_type.equals(AuthRealmEvent.eventType)) {
            event = ElementChangeEventsFactory.createAuthRealmEvent(instanceName, element_id, action);
        } else if (event_type.equals(LogLevelChangeEvent.eventType)) {
            events = ElementChangeEventsFactory.createLogLevelEvents(instanceName, element_id, action, changeList);
            bMustSetChangeList = false;
        } else if (event_type.equals(MonitoringLevelChangeEvent.eventType)) {
            events = ElementChangeEventsFactory.createMonitoringLevelEvents(instanceName, element_id, action, changeList);
            bMustSetChangeList = false;
        } else if (event_type.equals(ResourceDeployEvent.eventType)) {
            event = ElementChangeEventsFactory.createResourceDeployEvent(instanceName, element_type, element_id, action, changeList, targetName, ctx);
            bMustSetChangeList = false;
        } else if (event_type.equals(ModuleDeployEvent.eventType) || event_type.equals(ApplicationDeployEvent.eventType)) {
            event = ElementChangeEventsFactory.createModAppDeployEvent(instanceName, element_type, element_id, action, changeList, targetName, ctx);
            bMustSetChangeList = false;
        } else {
            return null;
        }
        if (event != null && (events == null || events.size() == 0)) {
            events = new ArrayList();
            events.add(event);
        }
        if (events == null || events.size() == 0) {
            return null;
        }
        ElementChangeEventsFactory.setTargetDestinationAndConfigChange(events, targetName, changeList, bMustSetChangeList);
        return events;
    }

    private static ArrayList buildSelfConstructingEvent(String event_type, String instanceName, String element_type, ArrayList changeList, ConfigContext ctx) throws Exception {
        try {
            Class<?> cl = Class.forName(event_type);
            Method m = cl.getMethod("getEventInstances", String.class, String.class, String.class, ArrayList.class, ConfigContext.class);
            return (ArrayList)m.invoke(null, event_type, instanceName, element_type, changeList, ctx);
        }
        catch (Exception e) {
            if (!(e instanceof ClassNotFoundException) && !(e instanceof NoSuchMethodException)) {
                throw e;
            }
            return null;
        }
    }

    private static boolean isMBeanReference(ConfigContext ctx, String element_id, ArrayList globalChangeList) {
        String typeInDomain = null;
        try {
            typeInDomain = ApplicationHelper.getApplicationType(ctx, element_id);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (typeInDomain != null) {
            return "Mbean".equals(typeInDomain);
        }
        String toCompare = "/mbean[@name='" + element_id + "']";
        for (int i = 0; i < globalChangeList.size(); ++i) {
            String xpath;
            ConfigChange change = (ConfigChange)globalChangeList.get(i);
            if (change == null || (xpath = change.getXPath()) == null || !xpath.endsWith(toCompare)) continue;
            return true;
        }
        return false;
    }

    private static void setTargetDestinationAndConfigChange(ArrayList events, String targetName, ArrayList changeList, boolean bSetChanges) {
        if (events != null) {
            for (int i = 0; i < events.size(); ++i) {
                AdminEvent event = (AdminEvent)events.get(i);
                event.setTargetDestination(targetName);
                if (!bSetChanges || changeList == null) continue;
                event.addConfigChange(changeList);
            }
        }
    }

    private static SecurityServiceEvent createSecurityServiceEvent(String instanceName, String id, int action) {
        if (action == 1) {
            action = 1;
        } else if (action == 2) {
            action = 2;
        } else if (action == 3) {
            action = 3;
        }
        return new SecurityServiceEvent(instanceName, action);
    }

    private static AuditModuleEvent createAuditModuleEvent(String instanceName, String id, int action) {
        if (action == 1) {
            action = 1;
        } else if (action == 2) {
            action = 2;
        } else if (action == 3) {
            action = 3;
        }
        return new AuditModuleEvent(instanceName, id, action);
    }

    private static AuthRealmEvent createAuthRealmEvent(String instanceName, String id, int action) {
        if (action == 1) {
            action = 1;
        } else if (action == 2) {
            action = 2;
        } else if (action == 3) {
            action = 3;
        }
        return new AuthRealmEvent(instanceName, id, action);
    }

    private static ArrayList createLogLevelEvents(String instanceName, String id, int action, ArrayList changeList) {
        Object chg;
        int i;
        ArrayList<LogLevelChangeEvent> events = new ArrayList<LogLevelChangeEvent>();
        for (i = 0; i < changeList.size(); ++i) {
            chg = changeList.get(i);
            if (!ElementChangeHelper.isPropertyChange((ConfigChange)chg)) continue;
            LogLevelChangeEvent event = new LogLevelChangeEvent(instanceName);
            event.setPropertyChanged(true);
            String xpath = ((ConfigChange)chg).getXPath();
            event.setPropertyName(ElementChangeHelper.getConfigElementPrimaryKey(xpath));
            event.addConfigChange((ConfigChange)chg);
            events.add(event);
        }
        if (action != 3) {
            return events;
        }
        for (i = 0; i < changeList.size(); ++i) {
            ConfigUpdate update;
            Set attrs;
            chg = changeList.get(i);
            if (!(chg instanceof ConfigUpdate) || ElementChangeHelper.isPropertyChange((ConfigChange)chg) || (attrs = (update = (ConfigUpdate)chg).getAttributeSet()) == null) continue;
            for (String compName : attrs) {
                String oldValue = update.getOldValue(compName);
                String newValue = update.getNewValue(compName);
                LogLevelChangeEvent event = new LogLevelChangeEvent(instanceName);
                event.setModuleName(compName);
                event.setOldLogLevel(oldValue);
                event.setNewLogLevel(newValue);
                events.add(event);
                ConfigUpdateImpl upd = new ConfigUpdateImpl(update.getXPath(), compName, oldValue, newValue);
                event.addConfigChange(upd);
            }
        }
        return events;
    }

    private static ArrayList createMonitoringLevelEvents(String instanceName, String id, int action, ArrayList changeList) {
        if (action != 3) {
            return null;
        }
        ArrayList<MonitoringLevelChangeEvent> events = new ArrayList<MonitoringLevelChangeEvent>();
        for (int i = 0; i < changeList.size(); ++i) {
            ConfigUpdate update;
            Set attrs;
            Object chg = changeList.get(i);
            if (!(chg instanceof ConfigUpdate) || ElementChangeHelper.isPropertyChange((ConfigChange)chg) || (attrs = (update = (ConfigUpdate)chg).getAttributeSet()) == null) continue;
            for (String compName : attrs) {
                String oldValue = update.getOldValue(compName);
                String newValue = update.getNewValue(compName);
                MonitoringLevelChangeEvent event = new MonitoringLevelChangeEvent(instanceName);
                event.setComponentName(compName);
                event.setOldMonitoringLevel(oldValue);
                event.setNewMonitoringLevel(newValue);
                events.add(event);
                ConfigUpdateImpl upd = new ConfigUpdateImpl(update.getXPath(), compName, oldValue, newValue);
                event.addConfigChange(upd);
            }
        }
        return events;
    }

    private static ResourceDeployEvent createResourceDeployEvent(String instanceName, String elemType, String id, int action, ArrayList changeList, String targetName, ConfigContext ctx) throws Exception {
        ResourceDeployEvent rde = null;
        if ("security-map".equals(elemType)) {
            String actionCode = null;
            if (action == 1 || action == 2) {
                actionCode = "redeploy";
                String element_xpath = ElementChangeHelper.getElementXPath(changeList);
                int endNewXpath = element_xpath.lastIndexOf("security-map");
                String new_element_xpath = element_xpath.substring(0, endNewXpath - 1);
                id = ElementChangeHelper.getConfigElementPrimaryKey(new_element_xpath);
            }
            EventBuilder builder = new EventBuilder();
            if (actionCode != null) {
                rde = builder.createResourceDeployEvent(actionCode, id, ctx, changeList, targetName);
            }
            return rde;
        }
        if (RESOURCE_REF_TYPE_NAME.equals(elemType)) {
            String actionCode = null;
            if (action == 1) {
                actionCode = "reference-added";
            } else if (action == 2) {
                actionCode = "reference-removed";
            } else if (action == 3) {
                Boolean bEnabled = null;
                bEnabled = ElementChangeHelper.findEnabledChange(changeList);
                if (bEnabled != null) {
                    actionCode = bEnabled != false ? "enable" : "disable";
                }
            }
            EventBuilder builder = new EventBuilder();
            if (actionCode != null) {
                rde = builder.createResourceDeployEvent(actionCode, id, ctx, changeList, targetName);
            }
        } else {
            String actionCode = null;
            if (action != 1 && action != 2 && action == 3) {
                Boolean bEnabled = null;
                actionCode = changeList.size() == 1 && (bEnabled = ElementChangeHelper.findEnabledChange(changeList)) != null ? (bEnabled != false ? "enable" : "disable") : "redeploy";
            }
            EventBuilder builder = new EventBuilder();
            if (actionCode != null) {
                rde = builder.createResourceDeployEvent(actionCode, id, ctx, changeList, targetName);
            }
        }
        return rde;
    }

    private static BaseDeployEvent createModAppDeployEvent(String instanceName, String elemType, String id, int action, ArrayList changeList, String targetName, ConfigContext ctx) throws Exception {
        BaseDeployEvent bde = null;
        String actionCode = null;
        if (APPLICATION_REF_TYPE_NAME.equals(elemType)) {
            if (action != 1 && action != 2 && action == 3) {
                Boolean bEnabled = null;
                bEnabled = ElementChangeHelper.findEnabledChange(changeList);
                if (bEnabled != null) {
                    actionCode = bEnabled != false ? "enable" : "disable";
                }
            }
            EventBuilder builder = new EventBuilder();
            if (actionCode != null) {
                bde = builder.createModAppDeployEvent(actionCode, id, ctx, changeList, targetName);
            }
        } else {
            if (action != 1 && action != 2 && action == 3) {
                Boolean bEnabled = null;
                actionCode = changeList.size() == 1 && (bEnabled = ElementChangeHelper.findEnabledChange(changeList)) != null ? (bEnabled != false ? "enable" : "disable") : "redeploy";
            }
            EventBuilder builder = new EventBuilder();
            if (actionCode != null) {
                bde = builder.createModAppDeployEvent(actionCode, id, ctx, changeList, targetName);
            }
        }
        return bde;
    }
}

