/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.EjbTimerEvent;
import com.sun.enterprise.admin.mbeanapi.IEJBTimerManagementMBean;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EJBTimerManagementMBean
extends BaseConfigMBean
implements IEJBTimerManagementMBean {
    private static final StringManager _strMgr = StringManager.getManager(EJBTimerManagementMBean.class);
    private static Logger _logger;

    private Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public String[] listTimers(String target) throws ConfigException, InstanceException {
        this.fine("Entering list Timers");
        String server = this.getServerName();
        this.fine("List Timers: Sending Notification to server" + server);
        String[] resStr = this.sendListTimerEvent(server, new String[]{server});
        this.fine("RESULT: " + resStr);
        if (resStr == null || resStr.length == 0) {
            resStr = new String[]{"There are no Ejb Timers."};
        }
        resStr[0] = server + ": " + resStr[0];
        return resStr;
    }

    protected String[] sendListTimerEvent(String server, String[] allServers) {
        EjbTimerEvent event = new EjbTimerEvent(server, 2, server, allServers);
        event.setTargetDestination(server);
        AdminEventResult res = this.forwardEvent(event);
        return (String[])res.getAttribute(server, "ejb_timer_call_result");
    }

    protected AdminEventResult forwardEvent(AdminEvent e) {
        AdminEventResult result = null;
        result = AdminEventMulticaster.multicastEvent(e);
        return result;
    }

    private void fine(String s) {
        this.getLogger().log(Level.INFO, s);
    }

    private String getServerName() {
        return ApplicationServer.getServerContext().getInstanceName();
    }
}

