/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class HttpListenerVirtualServerAssociationMgr {
    private static final StringManager strMgr = StringManager.getManager(HttpListenerVirtualServerAssociationMgr.class);
    private final Config config;

    public HttpListenerVirtualServerAssociationMgr(ConfigContext cctx, String configRef) throws ConfigException {
        this.checkArg(cctx, strMgr.getString("http_listener_vs_assoc_mgr.null_context"));
        this.checkArg(configRef, strMgr.getString("http_listener_vs_assoc_mgr.null_config_ref"));
        Domain domain = (Domain)cctx.getRootConfigBean();
        this.config = domain.getConfigs().getConfigByName(configRef);
        this.checkArg(this.config, strMgr.getString("http_listener_vs_assoc_mgr.no_such_element", configRef));
    }

    public void addHttpListenerRef(String listenerId) throws ConfigException {
        String defaultVS = this.getHttpListener(listenerId).getDefaultVirtualServer();
        Set s = this.getHttpListeners(defaultVS);
        s.add(listenerId);
        this.setHttpListeners(defaultVS, s);
    }

    public void deleteHttpListenerRef(String listenerId) throws ConfigException {
        VirtualServer[] servers = this.config.getHttpService().getVirtualServer();
        if (servers != null) {
            for (int i = 0; i < servers.length; ++i) {
                Set httpListeners = this.getHttpListeners(servers[i].getId());
                if (!httpListeners.contains(listenerId)) continue;
                httpListeners.remove(listenerId);
                servers[i].setHttpListeners(this.setToStr(httpListeners));
            }
        }
    }

    public void changeHttpListenerRef(String listenerId, String oldVs, String newVs) throws ConfigException {
        Set s = this.getHttpListeners(oldVs);
        s.remove(listenerId);
        this.setHttpListeners(oldVs, s);
        s = this.getHttpListeners(newVs);
        s.add(listenerId);
        this.setHttpListeners(newVs, s);
    }

    Set getHttpListeners(String vsID) throws ConfigException {
        return this.strToSet(this.getVirtualServer(vsID).getHttpListeners());
    }

    void setHttpListeners(String vsID, Set httpListeners) throws ConfigException {
        this.getVirtualServer(vsID).setHttpListeners(this.setToStr(httpListeners));
    }

    protected HttpListener getHttpListener(String id) throws ConfigException {
        HttpListener listener = this.config.getHttpService().getHttpListenerById(id);
        this.checkArg(listener, strMgr.getString("http_listener_vs_assoc_mgr.no_such_element", id));
        return listener;
    }

    protected VirtualServer getVirtualServer(String id) throws ConfigException {
        VirtualServer vs = this.config.getHttpService().getVirtualServerById(id);
        this.checkArg(vs, strMgr.getString("http_listener_vs_assoc_mgr.no_such_element", id));
        return vs;
    }

    private Set strToSet(String httpListeners) {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        if (null != httpListeners) {
            StringTokenizer strTok = new StringTokenizer(httpListeners, ",");
            while (strTok.hasMoreTokens()) {
                s.add(strTok.nextToken());
            }
        }
        return s;
    }

    private String setToStr(Set httpListeners) {
        String s = null;
        Iterator it = httpListeners.iterator();
        if (it.hasNext()) {
            StringBuffer sb = new StringBuffer();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            s = sb.toString();
        }
        return s;
    }

    private void checkArg(Object o, Object msg) throws ConfigException {
        if (null == o) {
            throw new ConfigException(msg.toString());
        }
    }
}

