/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.appserv.management.base.Util;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class LogEventFilter
implements NotificationFilter {
    private static StringManager sm = StringManager.getManager(LogEventFilter.class);
    private boolean anyLogger = false;
    private ArrayList<String> loggerNames;
    private Level level;

    public List getLoggerNames() {
        return this.loggerNames;
    }

    public void setLoggerNames(String loggers) {
        if (loggers == null) {
            return;
        }
        this.loggerNames = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(loggers, ",");
        while (tokenizer.hasMoreTokens()) {
            String loggerName = tokenizer.nextToken();
            if ("*".equals(loggerName)) {
                this.anyLogger = true;
                this.loggerNames.add(loggerName);
                return;
            }
            this.loggerNames.add(loggerName);
        }
    }

    public String getLevel() {
        return this.level.toString();
    }

    public void setLevel(String level) {
        this.level = Level.parse(level);
    }

    public boolean isNotificationEnabled(Notification notification) {
        boolean loggerNameMatched = false;
        boolean logLevelMatched = false;
        if (this.anyLogger) {
            loggerNameMatched = true;
        } else {
            String loggerNameFromNotification = (String)((Object)Util.getAMXNotificationValue(notification, "LogRecord.LoggerName"));
            for (String loggerNameFromList : this.loggerNames) {
                if (!loggerNameFromNotification.startsWith(loggerNameFromList)) continue;
                loggerNameMatched = true;
                break;
            }
        }
        Level logLevelFromNotification = (Level)Util.getAMXNotificationValue(notification, "LogRecord.Level");
        if (logLevelFromNotification.intValue() >= this.level.intValue()) {
            logLevelMatched = true;
        }
        return loggerNameMatched && logLevelMatched;
    }
}

