/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class MailResourceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        Object value = ccce.getObject();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            return this.testSave(name, (String)value);
        }
        MailResource res = (MailResource)value;
        String ip = res.getHost();
        String id = res.getJndiName();
        if (!StaticTest.checkObjectName(id, result)) {
            result.failed("Mail Resource Jndi-Name Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        try {
            InetAddress.getByName(ip).getHostName();
            result.passed("Valid Mail Resource IP");
        }
        catch (UnknownHostException e) {
            result.failed("Host name not resolvable - " + ip);
            return result;
        }
        return result;
    }

    public Result testSave(String name, String value) {
        Result result = new Result();
        result.passed("Passed **");
        if (name.equals("host")) {
            try {
                InetAddress.getByName(value).getHostName();
                result.passed("Valid Mail Resource IP");
            }
            catch (UnknownHostException e) {
                result.failed("Host name not resolvable - " + value);
            }
        }
        return result;
    }
}

