/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.AppclientContentOrigin;
import com.sun.enterprise.appclient.jws.AppclientJWSSupportManager;
import com.sun.enterprise.appclient.jws.ApplicationContentOrigin;
import com.sun.enterprise.appclient.jws.AppserverContentOrigin;
import com.sun.enterprise.appclient.jws.AppserverStaticContent;
import com.sun.enterprise.appclient.jws.Content;
import com.sun.enterprise.appclient.jws.ContentOrigin;
import com.sun.enterprise.appclient.jws.DynamicContent;
import com.sun.enterprise.appclient.jws.ExtensionFileManager;
import com.sun.enterprise.appclient.jws.JWSAdHocServletInfo;
import com.sun.enterprise.appclient.jws.NamingConventions;
import com.sun.enterprise.appclient.jws.NestedAppclientContentOrigin;
import com.sun.enterprise.appclient.jws.SignedStaticContent;
import com.sun.enterprise.appclient.jws.StaticContent;
import com.sun.enterprise.appclient.jws.TemplateCache;
import com.sun.enterprise.appclient.jws.UserContentOrigin;
import com.sun.enterprise.appclient.jws.Util;
import com.sun.enterprise.appclient.jws.WebPath;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.web.WebContainer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.ModuleType;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppclientJWSSupportInfo {
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String XML_MIME_TYPE = "application/xml";
    private static AppclientJWSSupportInfo instance = null;
    private static final String REQUEST_PATH_INFO_PATTERN = "/(__appclient|__application|__appserver|)/(.*?)(?:/(.*(?:$|\\z)))?";
    private static final int PATTERN_CATEGORY_GROUP_NUMBER = 1;
    private static final int PATTERN_REGNAME_GROUP_NUMBER = 2;
    private static final int PATTERN_RELATIVEPATH_GROUP_NUMBER = 3;
    private static final Pattern requestPathInfoPattern = Pattern.compile("/(__appclient|__application|__appserver|)/(.*?)(?:/(.*(?:$|\\z)))?");
    private static final String SERVER_RETAIN_TEMP_FILES_PROPERTYNAME = "com.sun.aas.jws.retainTempFiles";
    private static final String IIOP_ENDPOINT_TYPE_PREFIX_IGNORE = "SSL";
    private static final String APPCLIENT_JAR_SECURITY_ELEMENT_PROPERTYNAME = "appclient.jar.security.setting";
    private StringManager localStrings = StringManager.getManager(this.getClass());
    private Map<String, ContentOrigin> appclients;
    private Map<String, ContentOrigin> applications;
    private Map<String, ContentOrigin> appserverOrigins;
    private Map<String, ContentOrigin> signedAppserverOrigins;
    private Map<String, ContentOrigin> extJarAppserverOrigins;
    private Map<String, Content> contentMap;
    private Map<String, Map<String, ContentOrigin>> originTypes;
    protected ServerContext appServerContext;
    protected InstanceEnvironment instEnv;
    protected AppsManager appsManager;
    protected AppclientModulesManager appclientModulesManager;
    private static final String lineSep = System.getProperty("line.separator");
    private Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private TemplateCache templateCache;
    private URI installRootURI;
    private File installRootDir;
    private File libRoot;
    private File tempJarDirectory;
    private File j2eeModulesDir;
    private File j2eeApplicationsDir;
    private ExtensionFileManager extensionFileManager = new ExtensionFileManager();
    private String UNSIGNED_JWSACC_JARFILE_NAME = "appserv-jwsacc.jar";
    private String SIGNED_JWSACC_JARFILE_NAME = "appserv-jwsacc-signed.jar";

    public static AppclientJWSSupportInfo getInstance() throws IOException, Exception {
        if (instance == null) {
            instance = new AppclientJWSSupportInfo();
            AppclientJWSSupportManager.getInstance();
        }
        return instance;
    }

    private AppclientJWSSupportInfo() throws IOException, Exception {
        this.appclients = Collections.synchronizedMap(new HashMap());
        this.applications = Collections.synchronizedMap(new HashMap());
        this.appserverOrigins = Collections.synchronizedMap(new HashMap());
        this.signedAppserverOrigins = Collections.synchronizedMap(new HashMap());
        this.extJarAppserverOrigins = Collections.synchronizedMap(new HashMap());
        this.contentMap = Collections.synchronizedMap(new HashMap());
        this.originTypes = new HashMap<String, Map<String, ContentOrigin>>();
        this.originTypes.put("__appclient", this.appclients);
        this.originTypes.put("__application", this.applications);
        this.originTypes.put("__appserver", this.appserverOrigins);
        this.originTypes.put("__appserver", this.signedAppserverOrigins);
        this.originTypes.put("extjar", this.extJarAppserverOrigins);
        this.findAppServerObjects();
        String installRootDirSpec = System.getProperty("com.sun.aas.installRoot");
        this.installRootDir = new File(installRootDirSpec).getCanonicalFile();
        this.installRootURI = this.installRootDir.toURI();
        this.templateCache = new TemplateCache();
        String instanceRootDirSpec = this.instEnv.getInstancesRoot();
        File instanceRootDir = new File(instanceRootDirSpec);
        this.libRoot = new File(this.installRootDir, "lib");
        this.preloadAppserverContent();
    }

    public void startJWSServicesForAppclient(Application application, ModuleDescriptor moduleDescr) throws IOException, URISyntaxException, ConfigException, SAXParseException, ConfigException, Exception {
        String appclientMapKey;
        AppclientContentOrigin origin;
        String regName = application.getRegistrationName();
        if (!this.appclientModulesManager.isRegistered(regName)) {
            this.findAppServerObjects();
            if (!this.appclientModulesManager.isRegistered(regName)) {
                throw new ConfigException("Cannot locate config information for app client " + regName);
            }
        }
        if ((origin = this.findAppclient(appclientMapKey = NamingConventions.TopLevelAppclient.actualContextRoot(application))) != null) {
            this._logger.warning("Attempted to start Java Web Start services for stand-alone app client " + regName + " when they were already started; ignoring the duplicate request");
            return;
        }
        this._logger.fine("Starting Java Web Start services for stand-alone app client " + application.getRegistrationName());
        origin = this.prepareTopLevelAppclient(application, moduleDescr);
        if (origin != null) {
            this.startJWSServices(origin);
            this.appclients.put(appclientMapKey, origin);
            String logOutput = this._logger.isLoggable(Level.FINE) ? origin.toLongString() : origin.toString();
            this._logger.info("Java Web Start services started for stand-alone app client " + logOutput);
        }
    }

    public void endJWSServicesForAppclient(Application application, ModuleDescriptor moduleDescr) {
        this._logger.fine("Ending Java Web Start services for stand-alone app client " + application.getRegistrationName());
        String appclientMapKey = NamingConventions.TopLevelAppclient.actualContextRoot(application);
        AppclientContentOrigin origin = this.findAppclient(appclientMapKey);
        if (origin != null) {
            this.endJWSServices(origin);
            this.appclients.remove(appclientMapKey);
            this._logger.info("Java Web Start services ended for stand-alone app client " + origin);
        }
    }

    public void startJWSServicesForApplication(Application application, ModuleDescriptor[] moduleDescriptors) throws IOException, URISyntaxException, SAXParseException, ConfigException, Exception {
        String applicationMapKey = NamingConventions.TopLevelApplication.contextRoot(application);
        String regName = application.getRegistrationName();
        if (!this.appsManager.isRegistered(regName)) {
            this.findAppServerObjects();
            if (!this.appsManager.isRegistered(regName)) {
                throw new ConfigException("Cannot locate config information for application " + regName);
            }
        }
        this._logger.fine("Starting Java Web Start services for application " + regName);
        ApplicationContentOrigin origin = this.findApplication(applicationMapKey);
        if (origin != null) {
            this._logger.warning("Attempt to start Java Web Start services for application " + regName + " when they were already started; ignoring the duplicate request");
            return;
        }
        origin = this.prepareApplication(application, moduleDescriptors);
        this.startJWSServices(origin);
        this.applications.put(applicationMapKey, origin);
        String logOutput = this._logger.isLoggable(Level.FINE) ? origin.toLongString() : origin.toString();
        this._logger.info("Java Web Start services started for application " + logOutput);
    }

    public void endJWSServicesForApplication(Application application, ModuleDescriptor[] moduleDescrs) {
        String applicationMapKey = NamingConventions.TopLevelApplication.contextRoot(application);
        ApplicationContentOrigin origin = this.findApplication(applicationMapKey);
        if (origin != null) {
            this._logger.fine("Ending Java Web Start services for application " + origin.getTopLevelRegistrationName());
            this.endJWSServices(origin);
            this._logger.info("Java Web Start services ended for application: " + origin);
            this.applications.remove(applicationMapKey);
        }
    }

    public boolean isEnabled(UserContentOrigin origin) {
        boolean result = false;
        String regName = origin.getApplication().getRegistrationName();
        try {
            result = origin instanceof ApplicationContentOrigin ? this.appsManager.isJavaWebStartEnabled(regName) : this.appclientModulesManager.isJavaWebStartEnabled(regName);
            return result;
        }
        catch (ConfigException ce) {
            this._logger.log(Level.SEVERE, "Error checking if Java Web Start access enabled for app client " + origin.getApplication().getRegistrationName(), ce);
            return false;
        }
    }

    public boolean isEnabled(ApplicationContentOrigin origin) {
        try {
            return this.appsManager.isJavaWebStartEnabled(origin.getApplication().getRegistrationName());
        }
        catch (ConfigException ce) {
            this._logger.log(Level.SEVERE, "Error checking if Java Web Start access enabled for application " + origin.getApplication().getRegistrationName(), ce);
            return false;
        }
    }

    public Content getContent(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        String contentKey = NamingConventions.pathToContentKey(pathInfo);
        Content result = this.contentMap.get(contentKey);
        if (result != null) {
            ContentOrigin origin = result.getOrigin();
            if (!origin.isEnabled()) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Located requested document with content key " + contentKey + " but reporting 'not found' because the administrator has disabled Java Web Start access for the application or app client");
                }
                result = null;
            }
        } else if (this._logger.isLoggable(Level.WARNING) && result == null) {
            this._logger.warning("Attempt failed to find Java Web Start content at path " + pathInfo + "; content is available at these paths:" + this.contentMap.keySet());
        }
        return result;
    }

    public void startJWSServicesForDeployedAppclients() {
        for (ContentOrigin origin : this.appclients.values()) {
            AppclientContentOrigin acOrigin = (AppclientContentOrigin)origin;
            if (acOrigin.isAdhocPathRegistered()) continue;
            this.startJWSServices(acOrigin);
        }
        for (ContentOrigin origin : this.applications.values()) {
            ApplicationContentOrigin aOrigin = (ApplicationContentOrigin)origin;
            if (aOrigin.isAdhocPathRegistered()) continue;
            this.startJWSServices(aOrigin);
        }
    }

    private AppclientContentOrigin findAppclient(String regName) {
        AppclientContentOrigin result = (AppclientContentOrigin)this.appclients.get(regName);
        return result;
    }

    private AppclientContentOrigin findAppclient(Application application, ModuleDescriptor moduleDescr) {
        return this.findAppclient(application.getRegistrationName());
    }

    private ApplicationContentOrigin findApplication(String regName) {
        ApplicationContentOrigin result = (ApplicationContentOrigin)this.applications.get(regName);
        return result;
    }

    private ApplicationContentOrigin findApplication(Application application) {
        return this.findApplication(application.getRegistrationName());
    }

    private void startJWSServices(AppclientContentOrigin origin) {
        WebContainer container = WebContainer.getInstance();
        if (container != null) {
            String targetPathString = origin.getTargetPath();
            WebPath targetPath = new WebPath(targetPathString);
            JWSAdHocServletInfo info = new JWSAdHocServletInfo(targetPath.path(), targetPath.contextRoot());
            String virtualContextRoot = origin.getVirtualPath();
            WebPath virtualPath = new WebPath(virtualContextRoot);
            this._logger.info("Registering ad hoc servlet: " + virtualPath);
            container.registerAdHocPath(virtualPath.path(), virtualPath.contextRoot(), origin.getTopLevelRegistrationName(), info);
            origin.adhocPathRegistered();
        }
    }

    private void endJWSServices(AppclientContentOrigin origin) {
        for (Content c : origin.getContents()) {
            this.contentMap.remove(c.getContentKey());
        }
        WebPath path = new WebPath(origin.getVirtualPath());
        this._logger.fine("Unregistering ad hoc servlet: " + path);
        WebContainer container = WebContainer.getInstance();
        if (container != null) {
            container.unregisterAdHocPath(path.path(), path.contextRoot());
        }
    }

    private void startJWSServices(ApplicationContentOrigin origin) {
        WebContainer container = WebContainer.getInstance();
        if (container != null) {
            for (AppclientContentOrigin appclient : origin.getAppclientOrigins()) {
                this.startJWSServices(appclient);
            }
            origin.adhocPathRegistered();
        }
    }

    private void endJWSServices(ApplicationContentOrigin origin) {
        for (AppclientContentOrigin appclient : origin.getAppclientOrigins()) {
            this.endJWSServices(appclient);
        }
        for (Content c : origin.getContents()) {
            this.contentMap.remove(c.getContentKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAppServerObjects() throws IllegalStateException {
        block10: {
            StringBuilder failedObjects = new StringBuilder();
            Exception relatedException = null;
            this.appServerContext = ApplicationServer.getServerContext();
            if (this.appServerContext == null) {
                failedObjects.append(lineSep).append(" ApplicationServer.getServerContext()");
            }
            if ((this.instEnv = this.appServerContext.getInstanceEnvironment()) == null) {
                failedObjects.append(lineSep).append(" appServerContext.getInstanceEnvironment()");
            }
            try {
                this.appsManager = new AppsManager(this.instEnv, false);
            }
            catch (ConfigException ce) {
                relatedException = ce;
                failedObjects.append(lineSep).append(" AppsManager(instEnv)");
            }
            try {
                this.appclientModulesManager = new AppclientModulesManager(this.instEnv, false);
            }
            catch (ConfigException ce) {
                relatedException = ce;
                failedObjects.append(lineSep).append(" AppclientModulesManager(instEnv)");
            }
            finally {
                if (failedObjects.length() <= 0) break block10;
                if (relatedException == null) {
                    relatedException = new IllegalStateException("Null returned");
                }
                throw new IllegalStateException("The following utility objects could not be initialized: " + failedObjects.toString(), relatedException);
            }
        }
    }

    private void preloadAppserverContent() throws IOException, Exception {
        AppserverContentOrigin signedLibFilesOrigin = new AppserverContentOrigin("__appserver", "aslib");
        this.addJWSACCStaticContent(signedLibFilesOrigin);
        this.signedAppserverOrigins.put("aslib", signedLibFilesOrigin);
        AppserverContentOrigin libFilesOrigin = new AppserverContentOrigin("__appserver", "aslib");
        this.addAppserverStaticContent(this.libRoot, libFilesOrigin, false, "appserv-rt.jar", "appserv-cmp.jar", "appserv-admin.jar", "appserv-deployment-client.jar", "javaee.jar", "appserv-ext.jar", "mail.jar", "activation.jar", "appserv-ws.jar", "toplink-essentials.jar", "dbschema.jar");
        this.appserverOrigins.put("aslib", libFilesOrigin);
        AppserverContentOrigin derbyLibFilesOrigin = new AppserverContentOrigin("__appserver", "aslib");
        File derbyRoot = new File(this.installRootDir, "javadb");
        File derbyLib = new File(derbyRoot, "lib");
        this.addAppserverStaticContent(derbyLib, derbyLibFilesOrigin, false, "derbyclient.jar");
        this.appserverOrigins.put("derby", derbyLibFilesOrigin);
        AppserverContentOrigin mqlibFilesOrigin = new AppserverContentOrigin("__appserver", "aslib");
        File mqRoot = new File(this.installRootDir, "imq");
        File mqlibRoot = new File(mqRoot, "lib");
        this.addAppserverStaticContent(mqlibRoot, mqlibFilesOrigin, false, "fscontext.jar");
        this.appserverOrigins.put("mqlib", mqlibFilesOrigin);
        AppserverContentOrigin jmsraFilesOrigin = new AppserverContentOrigin("__appserver", "aslib");
        File installRoot = new File(this.libRoot, "install");
        File appsRoot = new File(installRoot, "applications");
        File jmsraRoot = new File(appsRoot, "jmsra");
        this.addAppserverStaticContent(jmsraRoot, jmsraFilesOrigin, false, "imqjmsra.jar");
        this.appserverOrigins.put("jmsralib", jmsraFilesOrigin);
        AppserverContentOrigin extJarsOrigin = new AppserverContentOrigin("__appserver", "aslib");
        Map<ExtensionFileManager.ExtensionKey, ExtensionFileManager.Extension> extFileInfo = this.extensionFileManager.getExtensionFileEntries();
        for (ExtensionFileManager.Extension e : extFileInfo.values()) {
            File f = e.getFile();
            String path = NamingConventions.extJarFilePath(e.getExtDirectoryNumber(), f);
            String contentKey = extJarsOrigin.getContentKeyPrefix() + path;
            AppserverStaticContent extContent = new AppserverStaticContent(extJarsOrigin, contentKey, path, f, this.installRootURI, false);
            extJarsOrigin.pathToContent.put(extContent.getContentKey(), extContent);
            this.contentMap.put(extContent.getContentKey(), extContent);
        }
        this.extJarAppserverOrigins.put("extjar", extJarsOrigin);
    }

    private void addJWSACCStaticContent(AppserverContentOrigin origin) throws Exception {
        String signedJarFileName = NamingConventions.SignedJar.signedJarPath(this.UNSIGNED_JWSACC_JARFILE_NAME);
        String path = "/" + signedJarFileName;
        String contentKey = origin.getContentKeyPrefix() + path;
        File unsignedJar = new File(this.installRootDir, "lib" + File.separator + this.UNSIGNED_JWSACC_JARFILE_NAME);
        File signedJar = new File(this.instEnv.getJavaWebStartPath(), signedJarFileName);
        SignedStaticContent content = new SignedStaticContent(origin, contentKey, path, signedJar, unsignedJar, this.installRootURI, this.localStrings, true);
        this.addAppserverStaticContent(origin, content);
    }

    private void addAppserverStaticContent(File dir, AppserverContentOrigin origin, boolean isMain, String ... fileName) {
        for (String fn : fileName) {
            String path = "/" + fn;
            String contentKey = origin.getContentKeyPrefix() + path;
            AppserverStaticContent content = new AppserverStaticContent(origin, contentKey, path, new File(dir, fn), this.installRootURI, isMain);
            this.addAppserverStaticContent(origin, content);
        }
    }

    private void addAppserverStaticContent(AppserverContentOrigin origin, StaticContent content) {
        origin.pathToContent.put(content.getContentKey(), content);
        this.contentMap.put(content.getContentKey(), content);
    }

    protected Properties prepareInitPlaceholders(AppclientContentOrigin origin, String mainClassName) {
        String appclientRegName = origin.getTopLevelRegistrationName();
        Properties answer = new Properties();
        answer.setProperty("appserver.codebase.path", NamingConventions.appServerCodebasePath());
        answer.setProperty("appclient.codebase.path", NamingConventions.appclientCodebasePath(origin));
        answer.setProperty("appclient.context-root", origin.getContextRoot());
        String vendor = origin.getVendor();
        answer.setProperty("appclient.vendor", vendor == null || vendor.length() == 0 ? this.localStrings.getString("jws.defaultVendorName") : vendor);
        answer.setProperty("appclient.client.jnlp.filename", NamingConventions.Client.JNLPFilename(appclientRegName));
        answer.setProperty("appclient.client.html.filepath", NamingConventions.Client.HTMLPath(appclientRegName));
        answer.setProperty("appclient.mainext.jnlp.filename", NamingConventions.Main.JNLPExtFilename(appclientRegName));
        this.prepareIIOPProperties(answer);
        boolean retainTempFiles = Boolean.getBoolean(SERVER_RETAIN_TEMP_FILES_PROPERTYNAME);
        answer.setProperty("appclient.retainTempFiles.propertyName", SERVER_RETAIN_TEMP_FILES_PROPERTYNAME);
        answer.setProperty("appclient.retainTempFiles", String.valueOf(retainTempFiles));
        String displayName = origin.getDisplayName();
        String jnlpInformationTitle = displayName != null && displayName.length() > 0 ? displayName : "Application Client " + appclientRegName;
        answer.setProperty("appclient.information.title", jnlpInformationTitle);
        String jnlpInformationHomepageFilepath = NamingConventions.Main.HTMLPath(appclientRegName);
        answer.setProperty("appclient.information.homepage.filepath", jnlpInformationHomepageFilepath);
        answer.setProperty("appclient.information.description.one-line", jnlpInformationTitle);
        String description = origin.getDescription();
        String jnlpInformationShortDescription = description != null && description.length() > 0 ? description : jnlpInformationTitle;
        answer.setProperty("appclient.information.description.short", jnlpInformationShortDescription);
        this.prepareAppserverPlaceholders(answer);
        String mainClassArgsValue = "";
        if (mainClassName != null && !mainClassName.equals("")) {
            mainClassArgsValue = "        <argument>-mainclass</argument>" + lineSep + "        <argument>" + mainClassName + "</argument>";
        }
        answer.setProperty("appclient.main.class.arguments", mainClassArgsValue);
        answer.setProperty("appclient.isJWS.propertyName", "com.sun.aas.jws.isJWS");
        answer.setProperty("appclient.download.host.propertyName", "com.sun.aas.jws.download.host");
        answer.setProperty("appclient.user.code.is.signed.propertyName", "com.sun.aas.user.code.signed");
        return answer;
    }

    private void prepareIIOPProperties(Properties props) {
        props.setProperty("appclient.iiop.defaultHost.propertyName", "com.sun.aas.jws.iiop.defaultHost");
        props.setProperty("appclient.iiop.defaultPort.propertyName", "com.sun.aas.jws.iiop.defaultPort");
        props.setProperty("appclient.iiop.defaultPort", String.valueOf(ORBManager.getORBInitialPort()));
        String failoverEndpoints = this.getIIOPEndpoints();
        String failoverEndpointsSetting = "";
        if (failoverEndpoints != null) {
            failoverEndpointsSetting = "<property name=\"com.sun.aas.jws.iiop.failover.endpoints\" value=\"" + failoverEndpoints + "\"/>";
        }
        props.setProperty("appclient.iiop.failover.endpoints", failoverEndpointsSetting);
    }

    private String getIIOPEndpoints() {
        String result = null;
        return result;
    }

    private void prepareAppserverPlaceholders(Properties p) {
        p.setProperty("appserver.information.title", this.localStrings.getString("jws.appserver.information.title"));
        p.setProperty("appserver.information.vendor", this.localStrings.getString("jws.appserver.information.vendor"));
        p.setProperty("appserver.information.description.one-line", this.localStrings.getString("jws.appserver.information.description.one-line"));
        p.setProperty("appserver.information.description.short", this.localStrings.getString("jws.appserver.information.description.short"));
    }

    private ApplicationContentOrigin prepareApplication(Application application, ModuleDescriptor[] moduleDescrs) throws IOException, URISyntaxException, SAXParseException, ConfigException, Exception {
        this.refreshConfigContextForManagers();
        ApplicationContentOrigin result = new ApplicationContentOrigin(application);
        SignedStaticContent jarFileContent = this.addAppclientJarContent(result);
        String jarHrefs = jarFileContent.asJNLPJarElement();
        String earDirectory = this.appsManager.getLocation(application.getRegistrationName());
        for (ModuleDescriptor md : moduleDescrs) {
            Manifest mf = this.getManifest(earDirectory, md);
            Attributes mainAttrs = mf.getMainAttributes();
            String mainClassName = mainAttrs.getValue(Attributes.Name.MAIN_CLASS);
            String appclientJarURI = md.getArchiveUri();
            File appclientJar = new File(appclientJarURI);
            File appclientJarDir = appclientJar.getParentFile();
            if (!appclientJar.isAbsolute()) {
                appclientJar = new File(earDirectory, appclientJarURI);
            }
            NestedAppclientContentOrigin nestedAppclient = this.prepareNestedAppclient(result, md, jarHrefs, mainClassName, mainAttrs, appclientJar.getParent(), jarFileContent);
            result.addNestedOrigin(nestedAppclient);
        }
        return result;
    }

    private Manifest getManifest(String earDirectoryPath, ModuleDescriptor md) {
        String submoduleDirSpec = FileUtils.makeFriendlyFileName(md.getArchiveUri());
        File submoduleDir = new File(earDirectoryPath, submoduleDirSpec);
        Manifest mf = EJBClassPathUtils.getManifest(submoduleDir.getAbsolutePath());
        return mf;
    }

    private AppclientContentOrigin prepareTopLevelAppclient(Application application, ModuleDescriptor moduleDescr) throws IOException, URISyntaxException, ConfigException, FileNotFoundException, SAXParseException, Exception {
        this.refreshConfigContextForManagers();
        String contextRoot = NamingConventions.TopLevelAppclient.defaultVirtualContextRoot(application);
        AppclientContentOrigin result = new AppclientContentOrigin(application, moduleDescr, contextRoot);
        String regName = result.getTopLevelRegistrationName();
        String appclientJarPath = result.getAppclientJarPath();
        SignedStaticContent jarFileContent = this.addAppclientJarContent(result);
        String jarHrefs = jarFileContent.asJNLPJarElement();
        String dirPath = this.appclientModulesManager.getLocation(regName);
        Manifest mf = EJBClassPathUtils.getManifest(dirPath);
        Attributes mainAttrs = mf.getMainAttributes();
        String mainClassName = mainAttrs.getValue(Attributes.Name.MAIN_CLASS);
        this.prepareAppclient(result, application, moduleDescr, this.appclientModulesManager, jarHrefs, regName, mainClassName, mainAttrs, dirPath, jarFileContent);
        return result;
    }

    private void prepareAppclient(AppclientContentOrigin origin, Application application, ModuleDescriptor moduleDescr, BaseManager mgr, String jarHRefs, String modName, String mainClassName, Attributes mainAttrs, String dirPathForRelativeClassPathEntries, StaticContent appclientJarContent) throws FileNotFoundException, IOException, URISyntaxException, ConfigException {
        Properties tokenValues = this.prepareInitPlaceholders(origin, mainClassName);
        StringBuilder appserverJarElements = this.buildJarElements(this.appserverOrigins);
        StringBuilder signedAppserverJarElements = this.buildJarElements(this.signedAppserverOrigins);
        Set<ExtensionFileManager.Extension> earExtJars = this.findExtensions(mainAttrs, dirPathForRelativeClassPathEntries);
        String earJarHrefs = this.prepareHrefsForFiles(earExtJars);
        tokenValues.setProperty("appserver.jar.elements", appserverJarElements.toString());
        tokenValues.setProperty("appserver.jar.elements.signed", signedAppserverJarElements.toString());
        tokenValues.put("appclient.jar.elements", jarHRefs);
        String mainJNLPPath = NamingConventions.Main.JNLPPath(modName);
        this.addDynamicContent(origin, mainJNLPPath, "appclientMainDocumentTemplate.jnlp", tokenValues, JNLP_MIME_TYPE, true);
        String mainExtJNLPPath = NamingConventions.Main.JNLPExtPath(modName);
        this.addDynamicContent(origin, mainExtJNLPPath, "appclientMainExtDocumentTemplate.jnlp", tokenValues, JNLP_MIME_TYPE);
        String mainHTMLPath = NamingConventions.Main.HTMLPath(modName);
        this.addDynamicContent(origin, mainHTMLPath, "appclientMainDocumentTemplate.html", tokenValues, HTML_MIME_TYPE);
        String clientHTMLPath = NamingConventions.Client.HTMLPath(modName);
        this.addDynamicContent(origin, clientHTMLPath, "appclientClientDocumentTemplate.html", tokenValues, HTML_MIME_TYPE);
        String clientJNLPPath = NamingConventions.Client.JNLPPath(modName);
        String contentKey = origin.getContentKeyPrefix() + clientJNLPPath;
        String docText = Util.replaceTokens(this.templateCache.getTemplate("appclientClientDocumentTemplate.jnlp"), tokenValues);
        DynamicContent clientJNLPContent = new DynamicContent(origin, contentKey, clientJNLPPath, docText, JNLP_MIME_TYPE, true);
        this.addDynamicContent(origin, clientJNLPContent);
    }

    private NestedAppclientContentOrigin prepareNestedAppclient(ApplicationContentOrigin parent, ModuleDescriptor moduleDescr, String jarHRefs, String mainClassName, Attributes mainAttrs, String dirPathForRelativeClassPathEntries, StaticContent appclienJarContent) throws FileNotFoundException, IOException, URISyntaxException, ConfigException {
        String contextRoot = NamingConventions.NestedAppclient.defaultVirtualContextRoot(parent.getApplication(), moduleDescr);
        NestedAppclientContentOrigin result = new NestedAppclientContentOrigin(parent, moduleDescr, contextRoot);
        this.prepareAppclient(result, parent.getApplication(), moduleDescr, this.appsManager, jarHRefs, result.getName(), mainClassName, mainAttrs, dirPathForRelativeClassPathEntries, appclienJarContent);
        return result;
    }

    private void refreshConfigContextForManagers() throws ConfigException {
        this.appsManager.refreshConfigContext();
        this.appclientModulesManager.refreshConfigContext();
    }

    private Set<ExtensionFileManager.Extension> findExtensions(Attributes attrs, String appDirPath) throws IOException, ConfigException {
        Set<ExtensionFileManager.Extension> result = null;
        File appDir = new File(appDirPath);
        result = this.extensionFileManager.findExtensionTransitiveClosure(appDir, attrs);
        return result;
    }

    private Attributes getMainAttributesForApplication(Application application) throws ConfigException, IOException {
        Attributes result = null;
        ModuleType type = application.getModuleType();
        BaseManager mgr = null;
        mgr = type.equals(ModuleType.EAR) ? this.appsManager : this.appclientModulesManager;
        String dirPath = mgr.getLocation(application.getRegistrationName());
        Manifest mf = this.loadManifestFromFile(dirPath);
        result = mf.getMainAttributes();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest loadManifestFromFile(String dirPath) throws IOException {
        Manifest result = null;
        InputStream is = null;
        try {
            File manifestFile = new File(dirPath, "META-INF/MANIFEST.MF");
            if (manifestFile.exists() && manifestFile.canRead()) {
                is = new FileInputStream(manifestFile);
                result = new Manifest(is);
            }
            Manifest manifest = result;
            return manifest;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private String prepareHrefsForFiles(Set<ExtensionFileManager.Extension> extJarInfo) {
        ContentOrigin extJarsOrigin = this.extJarAppserverOrigins.get("extjar");
        StringBuilder result = new StringBuilder();
        for (ExtensionFileManager.Extension e : extJarInfo) {
            String path = NamingConventions.extJarFilePath(e.getExtDirectoryNumber(), e.getFile());
            String contentKey = extJarsOrigin.getContentKeyPrefix() + path;
            StaticContent content = (StaticContent)extJarsOrigin.getContent(contentKey);
            result.append(content.asJNLPJarElement()).append(lineSep);
        }
        return result.toString();
    }

    private DynamicContent addDynamicContent(ContentOrigin origin, String path, String templateName, Properties tokenValues, String mimeType, boolean requiresElevatedPrivs) throws IOException {
        DynamicContent content = origin.addDynamicContent(path, this.templateCache.getTemplate(templateName), tokenValues, mimeType, requiresElevatedPrivs);
        this.contentMap.put(content.getContentKey(), content);
        return content;
    }

    private DynamicContent addDynamicContent(ContentOrigin origin, String path, String templateName, Properties tokenValues, String mimeType) throws IOException {
        return this.addDynamicContent(origin, path, templateName, tokenValues, mimeType, false);
    }

    private DynamicContent addDynamicContent(ContentOrigin origin, DynamicContent content) {
        origin.addDynamicContent(content);
        this.contentMap.put(content.getContentKey(), content);
        return content;
    }

    private StaticContent addStaticContent(ContentOrigin origin, String path, File file) throws URISyntaxException {
        StaticContent content = origin.addStaticContent(path, this.installRootURI, file);
        this.contentMap.put(content.getContentKey(), content);
        return content;
    }

    private StaticContent addStaticContent(ContentOrigin origin, StaticContent content) throws URISyntaxException {
        origin.addStaticContent(content);
        this.contentMap.put(content.getContentKey(), content);
        return content;
    }

    private SignedStaticContent addAppclientJarContent(ApplicationContentOrigin origin) throws FileNotFoundException, URISyntaxException, Exception {
        return this.addAppclientJarContent(origin, origin.getAppclientJarPath(), this.appsManager);
    }

    private SignedStaticContent addAppclientJarContent(AppclientContentOrigin origin) throws FileNotFoundException, URISyntaxException, Exception {
        return this.addAppclientJarContent(origin, origin.getAppclientJarPath(), this.appclientModulesManager);
    }

    private SignedStaticContent addAppclientJarContent(UserContentOrigin origin, String appclientJarPath, BaseManager manager) throws FileNotFoundException, URISyntaxException, Exception {
        File generatedJar = origin.locateGeneratedAppclientJarFile(manager);
        File signedGeneratedJar = NamingConventions.SignedJar.signedGeneratedAppclientJarFile(origin, this.instEnv, generatedJar);
        String contentKey = origin.getContentKeyPrefix() + "/" + signedGeneratedJar.getName();
        SignedStaticContent content = new SignedStaticContent(origin, contentKey, appclientJarPath, signedGeneratedJar, generatedJar, this.installRootURI, this.localStrings, false);
        this.addAppclientJarContent(origin, content);
        return content;
    }

    private SignedStaticContent addAppclientJarContent(UserContentOrigin origin, SignedStaticContent content) throws URISyntaxException {
        this.addStaticContent(origin, content);
        return content;
    }

    private StringBuilder buildJarElements(Map<String, ContentOrigin> origins) {
        StringBuilder appserverJarElements = new StringBuilder();
        for (ContentOrigin origin : origins.values()) {
            for (Content c : origin.pathToContent.values()) {
                if (!(c instanceof StaticContent)) continue;
                StaticContent sc = (StaticContent)c;
                appserverJarElements.append(sc.asJNLPJarElement());
            }
        }
        return appserverJarElements;
    }
}

