/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextFactory;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.pluggable.ConfigEnvironment;
import com.sun.enterprise.config.pluggable.EnvironmentFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFactory {
    public static ConfigContext createConfigContext(String fileUrl, DefaultHandler dh) throws ConfigException {
        ConfigEnvironment ce = ConfigFactory.getConfigEnvironment(fileUrl, false, false, true, true);
        ce.setHandler(dh.getClass().getName());
        return ConfigContextFactory.createConfigContext(ce);
    }

    public static ConfigContext createConfigContext(String fileUrl) throws ConfigException {
        return ConfigFactory.createConfigContext(fileUrl, false, false);
    }

    public static ConfigContext createConfigContext(String fileUrl, boolean readOnly) throws ConfigException {
        return ConfigFactory.createConfigContext(fileUrl, readOnly, false);
    }

    public static ConfigContext createConfigContext(String fileUrl, boolean readOnly, boolean autoCommit) throws ConfigException {
        return ConfigFactory.createConfigContext(fileUrl, readOnly, autoCommit, true);
    }

    public static ConfigContext createConfigContext(String fileUrl, boolean readOnly, boolean autoCommit, boolean cache) throws ConfigException {
        return ConfigFactory.createConfigContext(fileUrl, readOnly, autoCommit, cache, true);
    }

    public static ConfigContext createConfigContext(String fileUrl, boolean readOnly, boolean autoCommit, boolean cache, boolean resolvePath) throws ConfigException {
        return ConfigContextFactory.createConfigContext(ConfigFactory.getConfigEnvironment(fileUrl, readOnly, autoCommit, cache, resolvePath));
    }

    public static ConfigContext createConfigContext(String fileUrl, boolean readOnly, boolean autoCommit, boolean cache, Class rootClass) throws ConfigException {
        ConfigEnvironment ce = ConfigFactory.getConfigEnvironment(fileUrl, readOnly, autoCommit, cache, true);
        ce.setRootClass(rootClass.getName());
        return ConfigContextFactory.createConfigContext(ce);
    }

    public static synchronized ConfigContext createConfigContext(String fileUrl, boolean readOnly, boolean autoCommit, boolean cache, Class rootClass, DefaultHandler dh) throws ConfigException {
        ConfigEnvironment ce = ConfigFactory.getConfigEnvironment(fileUrl, readOnly, autoCommit, cache, true);
        ce.setRootClass(rootClass.getName());
        ce.setHandler(dh.getClass().getName());
        return ConfigContextFactory.createConfigContext(ce);
    }

    public static void removeConfigContext(ConfigContext ctx) {
        ConfigContextFactory.removeConfigContext(ctx);
    }

    public static synchronized void removeConfigContext(String fileUrl) {
        ConfigContextFactory.removeConfigContext(fileUrl);
    }

    public static synchronized void replaceConfigContext(ConfigContext oldCtx, ConfigContext newCtx) throws ConfigException {
        ConfigContextFactory.replaceConfigContext(oldCtx, newCtx);
    }

    public static boolean enableLastModifiedCheck(ConfigContext ctx, boolean value) {
        return ConfigContextFactory.enableLastModifiedCheck(ctx, value);
    }

    private static ConfigEnvironment getConfigEnvironment(String fileUrl, boolean readOnly, boolean autoCommit, boolean cache, boolean resolvePath) {
        ConfigEnvironment ce = EnvironmentFactory.getEnvironmentFactory().getConfigEnvironment();
        ce.setUrl(fileUrl);
        ce.setReadOnly(readOnly);
        ce.setCachingEnabled(cache);
        ce.getConfigBeanInterceptor().setResolvingPaths(resolvePath);
        return ce;
    }
}

