/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.resource.AbstractConnectorAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorAllocator;
import com.sun.enterprise.resource.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.NoTxConnectorAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.security.auth.Subject;

public class ConnectionManagerImpl
implements ConnectionManager,
Serializable {
    protected String jndiName;
    protected String poolName;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    protected String rarName;
    protected ResourcePrincipal defaultPrin = null;

    public ConnectionManagerImpl(String poolName) {
        this.poolName = poolName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public Object allocateNonTxConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        String localJndiName = this.jndiName;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Allocating NonTxConnection");
        }
        if (!this.jndiName.endsWith("__nontx")) {
            localJndiName = this.jndiName + "__nontx";
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Adding __nontx to jndiname");
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("lookup happened from a __nontx datasource directly");
        }
        return this.allocateConnection(mcf, cxRequestInfo, localJndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.allocateConnection(mcf, cxRequestInfo, this.jndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo, String jndiNameToUse) throws ResourceException {
        return this.allocateConnection(mcf, cxRequestInfo, jndiNameToUse, null);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo, String jndiNameToUse, Object conn) throws ResourceException {
        AuthenticationService authService;
        this.validatePool();
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        boolean resourceShareable = true;
        ResourceReferenceDescriptor ref = poolmgr.getResourceReference(jndiNameToUse);
        if (ref != null) {
            String shareableStr = ref.getSharingScope();
            if (shareableStr.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
                resourceShareable = false;
            }
        }
        if (ref == null) {
            _logger.log(Level.FINE, "poolmgr.no_resource_reference", jndiNameToUse);
            return this.internalGetConnection(mcf, this.defaultPrin, cxRequestInfo, resourceShareable, jndiNameToUse, conn, true);
        }
        String auth = ref.getAuthorization();
        if (auth.equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) {
            if (cxRequestInfo == null) {
                StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
                String msg = localStrings.getString("con_mgr.null_userpass");
                throw new ResourceException(msg);
            }
            ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolName);
            return this.internalGetConnection(mcf, null, cxRequestInfo, resourceShareable, jndiNameToUse, conn, false);
        }
        ResourcePrincipal prin = null;
        Set principalSet = null;
        Principal callerPrincipal = null;
        SecurityContext securityContext = null;
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        if (connectorRuntime.isServer() && (securityContext = SecurityContext.getCurrent()) != null && (callerPrincipal = securityContext.getCallerPrincipal()) != null && (principalSet = securityContext.getPrincipalSet()) != null && (authService = connectorRuntime.getAuthenticationService(this.rarName, this.poolName)) != null) {
            prin = (ResourcePrincipal)authService.mapPrincipal(callerPrincipal, principalSet);
        }
        if (prin == null) {
            prin = ref.getResourcePrincipal();
            if (prin == null) {
                _logger.log(Level.FINE, "default-resource-principal notspecified for " + jndiNameToUse + ". Defaulting to" + " user/password specified in the pool");
                prin = this.defaultPrin;
            } else if (!prin.equals(this.defaultPrin)) {
                ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolName);
            }
        }
        return this.internalGetConnection(mcf, prin, cxRequestInfo, resourceShareable, jndiNameToUse, conn, false);
    }

    protected Object internalGetConnection(ManagedConnectionFactory mcf, ResourcePrincipal prin, ConnectionRequestInfo cxRequestInfo, boolean shareable, String jndiNameToUse, Object conn, boolean isUnknownAuth) throws ResourceException {
        try {
            PoolManager poolmgr = Switch.getSwitch().getPoolManager();
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            PoolMetaData pmd = registry.getPoolMetaData(this.poolName);
            ResourceSpec spec = new ResourceSpec(jndiNameToUse, 1, pmd);
            spec.setConnectionPoolName(this.poolName);
            ManagedConnectionFactory freshMCF = pmd.getMCF();
            if (!freshMCF.equals(mcf)) {
                _logger.log(Level.INFO, "conmgr.mcf_not_equal");
            }
            ConnectorDescriptor desc = registry.getDescriptor(this.rarName);
            Subject subject = null;
            ClientSecurityInfo info = null;
            boolean subjectDefined = false;
            if (isUnknownAuth && this.rarName.equals(ConnectorConstants.DEFAULT_JMS_ADAPTER) && !pmd.isAuthCredentialsDefinedInPool()) {
                subject = ConnectionPoolObjectsUtils.createSubject(mcf, null);
            } else if (prin == null) {
                info = new ClientSecurityInfo(cxRequestInfo);
            } else {
                info = new ClientSecurityInfo(prin);
                if (subject == null) {
                    subject = prin.equals(this.defaultPrin) ? pmd.getSubject() : ConnectionPoolObjectsUtils.createSubject(mcf, prin);
                }
            }
            int txLevel = pmd.getTransactionSupport();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnectionMgr: poolName " + this.poolName + "  txLevel : " + txLevel);
            }
            AbstractConnectorAllocator alloc = null;
            if (conn != null) {
                spec.setConnectionToAssociate(conn);
            }
            switch (txLevel) {
                case 0: {
                    alloc = new NoTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc);
                    return poolmgr.getResource(spec, alloc, info);
                }
                case 1: {
                    if (!shareable) {
                        StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
                        String i18nMsg = localStrings.getString("con_mgr.resource_not_shareable");
                        throw new ResourceAllocationException(i18nMsg);
                    }
                    alloc = new LocalTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc);
                    return poolmgr.getResource(spec, alloc, info);
                }
                case 2: {
                    if (this.rarName.equals(ConnectorRuntime.DEFAULT_JMS_ADAPTER)) {
                        shareable = false;
                    }
                    spec.markAsXA();
                    alloc = new ConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc, shareable);
                    return poolmgr.getResource(spec, alloc, info);
                }
            }
            StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
            String i18nMsg = localStrings.getString("con_mgr.illegal_tx_level", txLevel + " ");
            throw new IllegalStateException(i18nMsg);
        }
        catch (PoolingException ex) {
            _logger.log(Level.WARNING, "poolmgr.get_connection_failure", ex.getMessage());
            StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
            String i18nMsg = localStrings.getString("con_mgr.error_creating_connection", ex.getMessage());
            ResourceAllocationException rae = new ResourceAllocationException(i18nMsg);
            rae.initCause((Throwable)ex);
            throw rae;
        }
    }

    public void setRarName(String _rarName) {
        this.rarName = _rarName;
    }

    public String getRarName() {
        return this.rarName;
    }

    public void initialize() throws ConnectorRuntimeException {
        Switch sw = Switch.getSwitch();
        if (sw.getContainerType() == 0) {
            try {
                PEORBConfigurator.initTransactionService(null, new Properties());
                if (sw.getTransactionManager() == null) {
                    sw.setTransactionManager(new J2EETransactionManagerOpt());
                }
                this.jndiName = ResourceInstaller.getPMJndiName(this.jndiName);
            }
            catch (Exception e) {
                throw (ConnectorRuntimeException)new ConnectorRuntimeException(e.getMessage()).initCause(e);
            }
        }
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        ManagedConnectionFactory mcf = runtime.obtainManagedConnectionFactory(this.poolName);
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        PoolMetaData pmd = registry.getPoolMetaData(this.poolName);
        this.defaultPrin = pmd.getResourcePrincipal();
    }

    private void validatePool() throws ResourceException {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        if (registry.getPoolMetaData(this.poolName) == null) {
            StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
            String msg = localStrings.getString("con_mgr.no_pool_meta_data");
            throw new ResourceException(this.poolName + ": " + msg);
        }
    }
}

