/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SetMethodAction
implements PrivilegedExceptionAction {
    private Object bean;
    private Set props;
    private Method[] methods;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public SetMethodAction(Object bean, Set props) {
        this.bean = bean;
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() throws Exception {
        Iterator it = this.props.iterator();
        this.methods = this.bean.getClass().getMethods();
        while (it.hasNext()) {
            EnvironmentProperty prop = (EnvironmentProperty)it.next();
            String propName = prop.getName();
            Class<?> type = this.getTypeOf(prop);
            if (type == null) {
                type = Class.forName(prop.getType());
            }
            if (prop.getResolvedValue() == null || prop.getResolvedValue().trim().length() == 0) continue;
            Method meth = null;
            try {
                meth = this.getMutatorMethod(propName, type);
                if (meth != null) {
                    logger.log(Level.FINER, "Invoking" + meth + " on " + this.bean.getClass().getName() + "with " + "value [" + prop.getResolvedValueObject().getClass() + "  , " + SetMethodAction.getFilteredPropValue(prop) + " ] ");
                    meth.invoke(this.bean, prop.getResolvedValueObject());
                    continue;
                }
                logger.log(Level.WARNING, "rardeployment.no_setter_method", new Object[]{prop.getName(), this.bean.getClass().getName()});
            }
            catch (IllegalArgumentException ia) {
                logger.log(Level.FINE, "IllegalException while trying to set " + prop.getName() + " and value " + SetMethodAction.getFilteredPropValue(prop), ia + " on an instance of " + this.bean.getClass() + " -- trying again with the type from bean");
                boolean prevBoundsChecking = EnvironmentProperty.isBoundsChecking();
                try {
                    EnvironmentProperty.setBoundsChecking(false);
                    prop.setType(type.getName());
                    logger.log(Level.FINE, "2nd try :: Invoking" + meth + " on " + this.bean.getClass().getName() + "with value [" + prop.getResolvedValueObject().getClass() + "  , " + SetMethodAction.getFilteredPropValue(prop) + " ] ");
                    meth.invoke(this.bean, prop.getResolvedValueObject());
                }
                catch (Exception e) {
                    this.handleException(e, prop, this.bean);
                }
                finally {
                    EnvironmentProperty.setBoundsChecking(prevBoundsChecking);
                }
            }
            catch (Exception ex) {
                this.handleException(ex, prop, this.bean);
            }
        }
        return null;
    }

    private void handleException(Exception ex, EnvironmentProperty prop, Object bean) throws ConnectorRuntimeException {
        logger.log(Level.WARNING, "rardeployment.exception_on_invoke_setter", new Object[]{prop.getName(), SetMethodAction.getFilteredPropValue(prop), ex.getMessage()});
        logger.log(Level.FINE, "Exception while trying to set " + prop.getName() + " and value " + SetMethodAction.getFilteredPropValue(prop), ex + " on an instance of " + bean.getClass());
        throw (ConnectorRuntimeException)new ConnectorRuntimeException(ex.getMessage()).initCause(ex);
    }

    private static String getFilteredPropValue(EnvironmentProperty prop) {
        if (prop == null) {
            return "null";
        }
        String propname = prop.getName();
        if (propname.toLowerCase().contains("password")) {
            return "********";
        }
        return prop.getResolvedValue();
    }

    private Method getMutatorMethod(String propertyName, Class type) {
        String setterMethodName = "set" + this.getCamelCasedPropertyName(propertyName);
        Method m = null;
        Method[] setterMethods = this.findMethod(setterMethodName);
        if (setterMethods.length == 1) {
            m = setterMethods[0];
        } else {
            for (int i = 0; i < setterMethods.length; ++i) {
                Class<?>[] paramTypes = setterMethods[i].getParameterTypes();
                if (paramTypes.length <= 0 || !paramTypes[0].equals(type) || paramTypes.length != 1) continue;
                logger.log(Level.FINER, "Method " + this.methods[i] + "matches with the right arg type");
                m = setterMethods[i];
            }
        }
        if (m != null) {
            return m;
        }
        logger.log(Level.WARNING, "no.such.method", new Object[]{setterMethodName, this.bean.getClass().getName()});
        return null;
    }

    private Class getTypeOf(EnvironmentProperty prop) {
        String name = prop.getName();
        Method accessorMeth = this.getAccessorMethod(name);
        if (accessorMeth != null) {
            return accessorMeth.getReturnType();
        }
        logger.log(Level.FINE, "method.name.nogetterforproperty", new Object[]{prop.getName(), this.bean.getClass()});
        return null;
    }

    private Method getAccessorMethod(String propertyName) {
        String getterName = "get" + this.getCamelCasedPropertyName(propertyName);
        Method[] getterMethods = this.findMethod(getterName);
        if (getterMethods.length > 0) {
            return getterMethods[0];
        }
        return null;
    }

    private Method[] findMethod(String methodName) {
        int i;
        ArrayList<Method> matchedMethods = new ArrayList<Method>();
        for (i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].getName().equals(methodName)) continue;
            matchedMethods.add(this.methods[i]);
        }
        for (i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].getName().equalsIgnoreCase(methodName)) continue;
            matchedMethods.add(this.methods[i]);
        }
        return matchedMethods.toArray(new Method[0]);
    }

    private String getCamelCasedPropertyName(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }
}

