/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.util.LogDomains;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoginConfigurationImpl
extends Descriptor
implements LoginConfiguration {
    public static final String AUTHENTICATION_METHOD_BASIC = "BASIC";
    public static final String AUTHENTICATION_METHOD_DIGEST = "DIGEST";
    public static final String AUTHENTICATION_METHOD_FORM = "FORM";
    public static final String AUTHENTICATION_METHOD_CLIENT_CERTIFICATE = "CLIENT-CERT";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private String authenticationMethod;
    private String realmName = "";
    private String formLoginPage = "";
    private String formErrorPage = "";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoginConfigurationImpl.class);

    public String getAuthenticationMethod() {
        if (this.authenticationMethod == null) {
            _logger.log(Level.WARNING, "enterprise.deployment_no_auth_method_dfnd");
            this.authenticationMethod = AUTHENTICATION_METHOD_BASIC;
        }
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        if (!(!this.isBoundsChecking() || AUTHENTICATION_METHOD_BASIC.equals(authenticationMethod) || AUTHENTICATION_METHOD_DIGEST.equals(authenticationMethod) || AUTHENTICATION_METHOD_FORM.equals(authenticationMethod) || AUTHENTICATION_METHOD_CLIENT_CERTIFICATE.equals(authenticationMethod))) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptionauthenticationmethod", "{0} is not a valid authentication method", new Object[]{authenticationMethod}));
        }
        this.authenticationMethod = authenticationMethod;
    }

    public String getRealmName() {
        if (this.realmName == null) {
            this.realmName = "";
        }
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getFormLoginPage() {
        if (this.formLoginPage == null) {
            this.formLoginPage = "";
        }
        return this.formLoginPage;
    }

    public void setFormLoginPage(String formLoginPage) {
        this.formLoginPage = formLoginPage;
    }

    public String getFormErrorPage() {
        if (this.formErrorPage == null) {
            this.formErrorPage = "";
        }
        return this.formErrorPage;
    }

    public void setFormErrorPage(String formErrorPage) {
        this.formErrorPage = formErrorPage;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("LoginConfig:(").append(this.authenticationMethod).append(" ").append(this.realmName).append(" ").append(this.formLoginPage).append(" ").append(this.formErrorPage).append(")");
    }
}

