/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.annotation.impl.AnnotationUtils;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class EjbJarScanner
extends ModuleScanner {
    public EjbJarScanner(File archiveFile, EjbBundleDescriptor desc) throws IOException {
        this(archiveFile, desc, null);
    }

    public EjbJarScanner(File archiveFile, EjbBundleDescriptor desc, ClassLoader classLoader) throws IOException {
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archiveFile);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        this.archiveFile = archiveFile;
        this.classLoader = classLoader;
        if (archiveFile.isDirectory()) {
            this.addScanDirectory(archiveFile);
            for (EjbDescriptor ejbDesc : desc.getEjbs()) {
                if (!(ejbDesc instanceof EjbSessionDescriptor) && !(ejbDesc instanceof EjbMessageBeanDescriptor)) continue;
                this.addScanClassName(ejbDesc.getEjbClassName());
            }
            for (EjbInterceptor interceptor : desc.getInterceptors()) {
                this.addScanClassName(interceptor.getInterceptorClassName());
            }
        }
    }
}

