/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.annotation.Scanner;
import com.sun.enterprise.deployment.annotation.impl.AnnotationUtils;
import com.sun.enterprise.deployment.annotation.impl.JavaEEScanner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarScanner
extends JavaEEScanner
implements Scanner {
    File jarFile;
    Set<JarEntry> entries = new HashSet<JarEntry>();
    ClassLoader classLoader = null;

    public JarScanner(File jarFile) throws IOException {
        this.jarFile = jarFile;
        this.init();
    }

    private void init() throws IOException {
        JarFile jf = new JarFile(this.jarFile);
        Enumeration<JarEntry> entriesEnum = jf.entries();
        while (entriesEnum.hasMoreElements()) {
            JarEntry je = entriesEnum.nextElement();
            if (!je.getName().endsWith(".class")) continue;
            this.entries.add(je);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            URL[] urls = new URL[1];
            try {
                urls[0] = this.jarFile.getAbsoluteFile().toURL();
                this.classLoader = new URLClassLoader(urls);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.classLoader;
    }

    @Override
    public Set<Class> getElements() {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (JarEntry je : this.entries) {
            String fileName = je.getName();
            String className = fileName.replace(File.separatorChar, '.');
            className = className.substring(0, className.length() - 6);
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        return elements;
    }
}

