/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.AutoDeployDirectoryScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoDeployedFilesManager {
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    protected static final String STATUS_DIR_NAME = ".autodeploystatus";
    protected String statDir = null;

    public AutoDeployedFilesManager() {
    }

    protected AutoDeployedFilesManager(String s) {
        this.statDir = s;
    }

    public static AutoDeployedFilesManager loadStatus(File statusDir) throws Exception {
        return AutoDeployedFilesManager.loadStatus(statusDir.getAbsolutePath());
    }

    public static AutoDeployedFilesManager loadStatus(String autoDeploymentDir) throws Exception {
        String statusDir = autoDeploymentDir + File.separator + STATUS_DIR_NAME;
        String sysAppDirPath = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications";
        File fileObj = new File(statusDir);
        if (!fileObj.exists() && !autoDeploymentDir.equals(sysAppDirPath)) {
            sLogger.log(Level.INFO, "autoDeployment status dir missing, creating a new one");
            fileObj.mkdirs();
        }
        AutoDeployedFilesManager adfm = new AutoDeployedFilesManager(statusDir);
        return adfm;
    }

    public void writeStatus() throws Exception {
    }

    public void setDeployedFileInfo(File f) throws Exception {
        File statusFile = this.getStatusFile(f);
        statusFile.createNewFile();
        statusFile.setLastModified(f.lastModified());
    }

    public void deleteDeployedFileInfo(File f) throws Exception {
        File statusFile = this.getStatusFile(f);
        statusFile.delete();
    }

    private File getStatusFile(File f) {
        File outDir = new File(this.statDir);
        File autoDeployDir = outDir.getParentFile();
        File dir = f.getParentFile();
        while (!dir.getAbsolutePath().equals(autoDeployDir.getAbsolutePath())) {
            outDir = new File(outDir, dir.getName());
            dir = dir.getParentFile();
        }
        outDir.mkdirs();
        return new File(outDir, f.getName());
    }

    public File[] getFilesForDeployment(File[] latestFiles) {
        if (latestFiles == null) {
            return new File[0];
        }
        File statusDir = new File(this.statDir);
        ArrayList<File> arrList = new ArrayList<File>();
        for (File deployDirFile : latestFiles) {
            File statusFile = this.getStatusFile(deployDirFile);
            if (statusFile.exists() && deployDirFile.lastModified() == statusFile.lastModified()) continue;
            arrList.add(deployDirFile);
        }
        return arrList.toArray(new File[0]);
    }

    public File[] getFilesForUndeployment(File[] latestFiles) {
        File statusDir = new File(this.statDir);
        Set<File> statusFiles = AutoDeployDirectoryScanner.getListOfFilesAsSet(statusDir, true);
        if (statusFiles == null || statusFiles.isEmpty()) {
            return null;
        }
        for (File deployDirFile : latestFiles) {
            statusFiles.remove(this.getStatusFile(deployDirFile));
        }
        ArrayList<File> appNames = new ArrayList<File>();
        File autodeployDir = statusDir.getParentFile();
        for (File statusDirFile : statusFiles) {
            File filePath = statusDir.getParentFile();
            File f = statusDirFile.getParentFile();
            while (!f.equals(statusDir)) {
                filePath = new File(filePath, f.getName());
                f = f.getParentFile();
            }
            filePath = new File(filePath, statusDirFile.getName());
            appNames.add(filePath);
        }
        return appNames.toArray(new File[0]);
    }
}

