/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.instance.ApplicationEnvironment;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.diagnostics.ObjectAnalyzer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileSource;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.Target;

public class DeploymentRequest {
    private boolean isDone = false;
    private FileSource fileSource = null;
    private File deploymentPlan = null;
    private DeploymentCallback deploymentCallback = null;
    private boolean isAborted = false;
    private boolean isReload = false;
    private String targetName = null;
    private DeployableObjectType type = null;
    private DeploymentCommand command = null;
    private String name = null;
    private String contextRoot = null;
    private String defaultContextRoot = null;
    private InstanceEnvironment instanceEnv = null;
    private ApplicationEnvironment appEnv = null;
    private ModuleEnvironment moduleEnv = null;
    private File clientJar = null;
    private File deployedDirectory = null;
    private File jspDirectory = null;
    private File stubsDirectory = null;
    private File generatedXMLDirectory = null;
    private boolean shared = false;
    private boolean forced = true;
    private boolean isVerified = false;
    private boolean isVerifying = false;
    private boolean debug = false;
    private boolean noEJBC = false;
    private boolean precompileJSP = false;
    private boolean generateRMIStubs = false;
    private boolean availabilityEnabled = false;
    private boolean javaWebStartEnabled = true;
    private String libraries = null;
    private String resourceAction = null;
    private String resourceTargetList = null;
    private boolean directoryDeployed = false;
    private List parentClasspath = null;
    private ClassLoader parentClassLoader = null;
    private List completeClasspath = null;
    private List moduleClasspath = null;
    private ClassLoader ejbClassLoader = null;
    private Properties optionalAttributes = null;
    private Properties optionalArguments = new Properties();
    private String httpHostName = null;
    private int httpPort;
    private String httpsHostName = null;
    private int httpsPort;
    private Application application = null;
    private static StringManager localStrings = StringManager.getManager(DeploymentRequest.class);
    private Target target = null;
    private boolean startOnDeploy = true;
    private int actionCode = 0;
    private boolean cascade = false;
    private DeploymentStatus currentDeploymentStatus = null;
    private String description = null;
    private boolean reregisterOnFailure = true;

    public DeploymentRequest(InstanceEnvironment iEnv, DeployableObjectType theType, DeploymentCommand theCommand) throws IASDeploymentException {
        this.instanceEnv = iEnv;
        this.setType(theType);
        this.setCommand(theCommand);
    }

    public void verify() throws IASDeploymentException {
        if (this.isVerified) {
            return;
        }
        if (this.isFileSourceRequired() && this.fileSource == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.file_source_required");
            throw new IASDeploymentException(msg);
        }
        if (this.isNameRequired() && this.name == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.name_required");
            throw new IASDeploymentException(msg);
        }
        if (this.isContextRootRequired() && this.contextRoot == null && this.defaultContextRoot == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.context_root_required");
            throw new IASDeploymentException(msg);
        }
        if (this.name == null) {
            this.createName();
        }
        if (!FileUtils.isLegalFilename(this.name)) {
            String msg = localStrings.getString("enterprise.deployment.backend.illegal_characters_in_component_name", FileUtils.getIllegalFilenameCharacters());
            throw new IASDeploymentException(msg);
        }
        this.setEnv();
        this.checkForRedeploy();
        this.isVerified = true;
    }

    public void setName(String theName) throws IASDeploymentException {
        if (StringUtils.ok(theName)) {
            this.name = theName;
        } else if (this.isNameRequired()) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_setname");
            throw new IASDeploymentException(msg);
        }
    }

    public void setFileSource(String src) throws IASDeploymentException {
        this.setFileSource(new File(src));
    }

    public void setFileSource(File src) throws IASDeploymentException {
        block3: {
            this.fileSource = null;
            if (src == null && !this.isFileSourceRequired()) {
                return;
            }
            try {
                this.fileSource = new FileSource(src);
            }
            catch (Exception e) {
                if (!this.isFileSourceRequired()) break block3;
                throw new IASDeploymentException("DeploymentRequest.setFileSource()" + e);
            }
        }
    }

    public void setDeploymentPlan(File plan) {
        this.deploymentPlan = plan;
    }

    public File getDeploymentPlan() {
        return this.deploymentPlan;
    }

    public void setDeploymentCallback(DeploymentCallback callback) {
        this.deploymentCallback = callback;
    }

    public DeploymentCallback getDeploymentCallback() {
        return this.deploymentCallback;
    }

    public void setAbort(boolean isAborted) {
        this.isAborted = isAborted;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void setReload(boolean isReload) {
        this.isReload = isReload;
    }

    public boolean isReload() {
        return this.isReload;
    }

    public void setTargetName(String name) {
        this.targetName = name;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setShared(boolean newShared) throws IASDeploymentException {
        if (!this.isEjbModule()) {
            String msg = localStrings.getString("enterprise.deployment.backend.cannot_set_shared_flag");
            throw new IASDeploymentException(msg);
        }
        this.shared = newShared;
    }

    public void setForced(boolean newForced) {
        this.forced = newForced;
    }

    public void addOptionalArguments(Properties props) {
        this.optionalArguments.putAll((Map<?, ?>)props);
    }

    public void addOptionalArguments(Map map) {
        this.optionalArguments.putAll((Map<?, ?>)map);
    }

    public void addOptionalArgument(String key, String value) {
        this.optionalArguments.put(key, value);
    }

    public void setPrecompileJSP(boolean newPrecompileJSP) {
        this.precompileJSP = newPrecompileJSP;
    }

    public boolean getPrecompileJSP() {
        return this.precompileJSP;
    }

    public void setGenerateRMIStubs(boolean newGenerateRMIStubs) {
        this.generateRMIStubs = newGenerateRMIStubs;
    }

    public boolean getGenerateRMIStubs() {
        return this.generateRMIStubs;
    }

    public void setAvailabilityEnabled(boolean newAvailabilityEnabled) {
        this.availabilityEnabled = newAvailabilityEnabled;
    }

    public boolean isAvailabilityEnabled() {
        return this.availabilityEnabled;
    }

    public void setJavaWebStartEnabled(boolean newJavaWebStartEnabled) {
        this.javaWebStartEnabled = newJavaWebStartEnabled;
    }

    public boolean isJavaWebStartEnabled() {
        return this.javaWebStartEnabled;
    }

    public void setLibraries(String newLibraries) {
        this.libraries = newLibraries;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public String getResourceAction() {
        return this.resourceAction;
    }

    public void setResourceAction(String newResourceAction) {
        this.resourceAction = newResourceAction;
    }

    public void setResourceTargetList(String newTargetList) {
        this.resourceTargetList = newTargetList;
    }

    public String getResourceTargetList() {
        return this.resourceTargetList;
    }

    public boolean isForced() {
        return this.forced;
    }

    public File getClientJar() {
        return this.clientJar;
    }

    public boolean isApplication() {
        return DeployableObjectType.APP.equals(this.type);
    }

    public void setContextRoot(String s) {
        this.contextRoot = s;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setDefaultContextRoot(String s) {
        this.defaultContextRoot = s;
    }

    public String getDefaultContextRoot() {
        return this.defaultContextRoot;
    }

    public boolean isModule() {
        return this.isWebModule() || this.isEjbModule() || this.isConnectorModule() || this.isAppClientModule();
    }

    public boolean isSharedModule() {
        return this.isModule() && this.shared;
    }

    public boolean isStandAloneModule() {
        return this.isModule() && !this.shared;
    }

    public boolean isWebModule() {
        return DeployableObjectType.WEB.equals(this.type);
    }

    public boolean isEjbModule() {
        return DeployableObjectType.EJB.equals(this.type);
    }

    public boolean isConnectorModule() {
        return DeployableObjectType.CONN.equals(this.type);
    }

    public boolean isAppClientModule() {
        return DeployableObjectType.CAR.equals(this.type);
    }

    public boolean isDeploy() throws IASDeploymentException {
        if (this.command == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.no_command");
            throw new IASDeploymentException(msg);
        }
        return this.command.equals(DeploymentCommand.DEPLOY);
    }

    public boolean isReDeploy() throws IASDeploymentException {
        if (this.command == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.no_command");
            throw new IASDeploymentException(msg);
        }
        return this.command.equals(DeploymentCommand.REDEPLOY);
    }

    public boolean isUnDeploy() throws IASDeploymentException {
        if (this.command == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.no_command");
            throw new IASDeploymentException(msg);
        }
        return this.command.equals(DeploymentCommand.UNDEPLOY);
    }

    public boolean isArchive() throws IASDeploymentException {
        if (this.isUnDeploy()) {
            String msg = localStrings.getString("enterprise.deployment.backend.invalid_isarchive_call");
            throw new IASDeploymentException(msg);
        }
        return this.getFileSource().isArchive();
    }

    public boolean isDirectory() throws IASDeploymentException {
        if (this.isUnDeploy()) {
            return false;
        }
        return this.getFileSource().isDirectory();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    public void setDebug(boolean what) {
        this.debug = true;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setNoEJBC() {
        this.noEJBC = true;
    }

    public boolean getNoEJBC() {
        return this.noEJBC;
    }

    public void setVerifying(boolean what) {
        this.isVerifying = what;
    }

    public boolean isVerifying() {
        return this.isVerifying;
    }

    public File getDeployedDirectory() {
        if (!FileUtils.safeIsDirectory(this.deployedDirectory)) {
            this.deployedDirectory = null;
        }
        return this.deployedDirectory;
    }

    public File getStubsDirectory() {
        if (!FileUtils.safeIsDirectory(this.stubsDirectory)) {
            this.stubsDirectory = null;
        }
        return this.stubsDirectory;
    }

    public File getJSPDirectory() {
        if (!FileUtils.safeIsDirectory(this.jspDirectory)) {
            this.jspDirectory = null;
        }
        return this.jspDirectory;
    }

    public File getGeneratedXMLDirectory() {
        if (!FileUtils.safeIsDirectory(this.generatedXMLDirectory)) {
            this.generatedXMLDirectory = null;
        }
        return this.generatedXMLDirectory;
    }

    void setClientJar(File f) {
        this.clientJar = f;
    }

    public FileSource getFileSource() {
        return this.fileSource;
    }

    public DeployableObjectType getType() {
        return this.type;
    }

    DeploymentCommand getCommand() {
        return this.command;
    }

    public InstanceEnvironment getInstanceEnv() {
        return this.instanceEnv;
    }

    ApplicationEnvironment getAppEnv() throws IASDeploymentException {
        if (!this.isApplication()) {
            String msg = localStrings.getString("enterprise.deployment.backend.illegal_getapplicationenv_call");
            throw new IASDeploymentException(msg);
        }
        return this.appEnv;
    }

    ModuleEnvironment getModuleEnv() throws IASDeploymentException {
        if (!this.isModule()) {
            String msg = localStrings.getString("enterprise.deployment.backend.illegal_getmoduleenv_call");
            throw new IASDeploymentException(msg);
        }
        return this.moduleEnv;
    }

    boolean isEar() {
        return this.isApplication() && this.fileSource.isArchive();
    }

    boolean isWar() {
        return this.isWebModule() && this.fileSource.isArchive();
    }

    boolean isEjbJar() {
        return this.isEjbModule() && this.fileSource.isArchive();
    }

    void setParentClassLoader(ClassLoader cl) {
        this.parentClassLoader = cl;
    }

    ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    void setParentClasspath(List classpaths) {
        this.parentClasspath = classpaths;
    }

    List getParentClasspath() {
        return this.parentClasspath;
    }

    public void setOptionalAttributes(Properties optionalAttributes) {
        this.optionalAttributes = optionalAttributes;
    }

    public Properties getOptionalAttributes() {
        return this.optionalAttributes;
    }

    void setEjbClassLoader(ClassLoader cl) {
        this.ejbClassLoader = cl;
    }

    ClassLoader getEjbClassLoader() {
        return this.ejbClassLoader;
    }

    void setCompleteClasspath(List classpaths) {
        this.completeClasspath = classpaths;
    }

    List getCompleteClasspath() {
        return this.completeClasspath;
    }

    void setModuleClasspath(List classpath) {
        this.moduleClasspath = classpath;
    }

    List getModuleClasspath() {
        return this.moduleClasspath;
    }

    public Properties getOptionalArguments() {
        return this.optionalArguments;
    }

    public void setDeployedDirectory(File d) {
        this.deployedDirectory = d;
    }

    public void setStubsDirectory(File d) {
        this.stubsDirectory = d;
    }

    public void setJSPDirectory(File d) {
        this.jspDirectory = d;
    }

    public void setGeneratedXMLDirectory(File d) {
        this.generatedXMLDirectory = d;
    }

    boolean isMaybeCMPDropTables() {
        String s = this.getOptionalArguments().getProperty("CmpInfo.DROP_TABLES");
        return s == null || !s.equalsIgnoreCase("false");
    }

    public String getHttpHostName() {
        return this.httpHostName;
    }

    public void setHttpHostName(String hostName) {
        this.httpHostName = hostName;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public String getHttpsHostName() {
        return this.httpsHostName;
    }

    public void setHttpsHostName(String hostName) {
        this.httpsHostName = hostName;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int port) {
        this.httpsPort = port;
    }

    private boolean isFileSourceRequired() throws IASDeploymentException {
        return !this.isUnDeploy();
    }

    private boolean isNameRequired() throws IASDeploymentException {
        return !this.isDeploy();
    }

    private boolean isContextRootRequired() throws IASDeploymentException {
        return this.isWebModule() && (this.isDeploy() || this.isReDeploy());
    }

    private void setType(DeployableObjectType theType) throws IASDeploymentException {
        this.type = theType;
        this.shared = this.isConnectorModule();
    }

    void setCommand(DeploymentCommand theCommand) throws IASDeploymentException {
        this.command = theCommand;
        if (this.command == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_command_type");
            throw new IASDeploymentException(msg);
        }
    }

    private void setEnv() throws IASDeploymentException {
        if (this.instanceEnv == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_instanceenvironment");
            throw new IASDeploymentException(msg);
        }
        if (this.isApplication()) {
            this.appEnv = new ApplicationEnvironment(this.instanceEnv, this.name);
        } else if (this.isWebModule()) {
            this.moduleEnv = new ModuleEnvironment(this.instanceEnv, this.name, DeployableObjectType.WEB);
        } else if (this.isEjbModule()) {
            this.moduleEnv = new ModuleEnvironment(this.instanceEnv, this.name, DeployableObjectType.EJB);
        } else if (this.isConnectorModule()) {
            this.moduleEnv = new ModuleEnvironment(this.instanceEnv, this.name, DeployableObjectType.CONN);
        } else if (this.isAppClientModule()) {
            this.moduleEnv = new ModuleEnvironment(this.instanceEnv, this.name, DeployableObjectType.CAR);
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.unknown_deployable_object", this.getClass().getName());
            throw new IASDeploymentException(msg);
        }
    }

    private void createName() {
        String aname = this.fileSource.getSource().getName();
        this.name = this.isEar() ? FileUtils.makeFriendlyFilenameNoExtension(aname) : FileUtils.makeFriendlyFilename(aname);
    }

    private void checkForRedeploy() throws IASDeploymentException {
        if (this.isUnDeploy()) {
            return;
        }
        assert (this.appEnv != null && this.moduleEnv == null || this.appEnv == null && this.moduleEnv != null);
        assert (!this.isVerified);
        assert (StringUtils.ok(this.name));
        assert (this.instanceEnv != null);
        if (this.moduleEnv != null) {
            return;
        }
        try {
            AppsManager appMgr = new AppsManager(this.instanceEnv);
            boolean isReg = appMgr.isRegistered(this.name);
            if (this.forced && isReg && this.isDeploy()) {
                this.command = DeploymentCommand.REDEPLOY;
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setCurrentDeploymentStatus(DeploymentStatus status) {
        this.currentDeploymentStatus = status;
    }

    public DeploymentStatus getCurrentDeploymentStatus() {
        return this.currentDeploymentStatus;
    }

    public void setStartOnDeploy(boolean startOnDeploy) {
        this.startOnDeploy = startOnDeploy;
    }

    public boolean isStartOnDeploy() {
        return this.startOnDeploy;
    }

    public void setActionCode(int actionCode) {
        this.actionCode = actionCode;
    }

    public int getActionCode() {
        return this.actionCode;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public boolean getCascade() {
        return this.cascade;
    }

    public void setDescriptor(Application app) {
        this.application = app;
    }

    public Application getDescriptor() {
        return this.application;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getReRegisterOnFailure() {
        return this.reregisterOnFailure;
    }

    void setReRegisterOnFailure(boolean b) {
        this.reregisterOnFailure = b;
    }

    public void done() {
        if (!this.isDone) {
            this.isDone = true;
            if (this.ejbClassLoader != null && this.ejbClassLoader instanceof EJBClassLoader) {
                ((EJBClassLoader)this.ejbClassLoader).done();
            }
        }
    }
}

