/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.JSPCompiler;
import com.sun.enterprise.deployment.backend.ModuleDeployer;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.web.security.WebSecurityManager;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class WebModuleDeployer
extends ModuleDeployer {
    private WebModulesManager webModulesMgr = null;
    private static StringManager localStrings = StringManager.getManager(WebModuleDeployer.class);

    WebModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) throws IASDeploymentException, ConfigException {
        this.webModulesMgr = new WebModulesManager(ienv);
        return this.webModulesMgr;
    }

    protected void preDeploy() throws IASDeploymentException {
        try {
            assert (this.moduleDir != null);
            assert (StringUtils.ok(this.moduleName));
            if (this.isRegistered()) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(msg);
            }
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isArchive()) {
                if (this.request.getFileSource().getFile().getName().endsWith(".class")) {
                    File subDir = new File(this.moduleDir, "WEB-INF");
                    subDir = new File(subDir, "classes");
                    this.copyAutodeployedClassFile(this.request.getFileSource().getFile(), subDir);
                } else {
                    J2EEModuleExploder.explodeJar(this.request.getFileSource().getFile(), this.moduleDir);
                }
            }
            this.xmlDir.mkdirs();
            this.stubsDir.mkdirs();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void deploy() throws IASDeploymentException {
        try {
            String mLocation = this.moduleDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IASDeploymentException(e);
        }
        Application app = this.loadDescriptors();
        this.request.getDescriptor().setGeneratedXMLDirectory(this.xmlDir.getAbsolutePath());
        WebBundleDescriptor bundleDesc = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
        if (this.request.getContextRoot() == null || this.request.getContextRoot().trim().equals("")) {
            if (bundleDesc.getContextRoot() != null && !bundleDesc.getContextRoot().trim().equals("")) {
                this.request.setContextRoot(bundleDesc.getContextRoot());
            } else {
                this.request.setContextRoot(this.request.getDefaultContextRoot());
            }
        }
        ZipItem[] clientStubs = this.runEJBC();
        try {
            if (this.request.getPrecompileJSP()) {
                long time = System.currentTimeMillis();
                JSPCompiler.compile(this.moduleDir, this.jspDir, bundleDesc, this.request.getCompleteClasspath());
                this.addJSPCTime(System.currentTimeMillis() - time);
            }
            this.runVerifier();
        }
        catch (IASDeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        assert (this.moduleDir != null);
        assert (StringUtils.ok(this.moduleName));
        this.setOldDirs();
        if (this.request.isArchive()) {
            try {
                if (this.request.getFileSource().getFile().getName().endsWith(".class")) {
                    File subDir = new File(this.moduleDir, "WEB-INF");
                    subDir = new File(subDir, "classes");
                    this.copyAutodeployedClassFile(this.request.getFileSource().getFile(), subDir);
                } else {
                    J2EEModuleExploder.explodeJar(this.request.getFileSource().getFile(), this.moduleDir);
                }
            }
            catch (IOException e) {
                throw new IASDeploymentException(e.toString(), e);
            }
        }
        this.xmlDir.mkdirs();
        this.stubsDir.mkdirs();
    }

    protected boolean needsStubs() {
        return true;
    }

    protected boolean needsJSPs() {
        return true;
    }

    protected void generatePolicy() throws IASDeploymentException {
        try {
            if (this.webModulesMgr == null) {
                this.webModulesMgr = (WebModulesManager)this.createConfigManager(this.getInstanceEnv(), this.moduleEnv);
            }
            Application app = this.request.getDescriptor();
            WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
            WebSecurityManagerFactory wsmf = null;
            wsmf = WebSecurityManagerFactory.getInstance();
            wsmf.newWebSecurityManager(wbd);
            if (this.request.isApplication()) {
                return;
            }
            String name = WebSecurityManager.getContextID(wbd);
            SecurityUtil.generatePolicyFile(name);
        }
        catch (IASDeploymentException iasde) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, iasde);
            throw iasde;
        }
        catch (ConfigException ce) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, ce);
            throw new IASDeploymentException(ce.toString());
        }
        catch (IASSecurityException iassec) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, iassec);
            throw new IASDeploymentException(msg, iassec);
        }
    }

    public void removePolicy() throws IASDeploymentException {
        if (this.request.isApplication()) {
            return;
        }
        WebSecurityManagerFactory wsmf = WebSecurityManagerFactory.getInstance();
        String requestName = this.request.getName();
        Object[] name = wsmf.getAndRemoveContextIdForWebAppName(requestName);
        try {
            if (name != null && name[0] != null) {
                SecurityUtil.removePolicy((String)name[0]);
            }
        }
        catch (IASSecurityException ex) {
            String msg = localStrings.getString("enterprise.deployment.backend.remove_policy_error", name);
            this.logger.log(Level.WARNING, msg, ex);
            throw new IASDeploymentException(msg, ex);
        }
    }
}

