/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.InputStream;
import java.util.logging.Level;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SaxParserHandlerBundled
extends SaxParserHandler {
    private static final String BUNDLED_SCHEMA_ROOT = "/schemas";
    private static final String BUNDLED_DTD_ROOT = "/dtds";

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        InputSource result = null;
        try {
            InputStream is;
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Asked to resolve  " + publicID + " system id = " + systemID);
            }
            if (publicID == null) {
                if (systemID == null || systemID.lastIndexOf(47) == systemID.length()) {
                    return null;
                }
                InputStream is2 = this.openSchemaStream(systemID);
                result = is2 != null ? new InputSource(is2) : new InputSource(systemID);
            } else if (mapping.containsKey(publicID)) {
                this.publicID = publicID;
                InputStream is3 = this.openDTDStream(publicID);
                if (is3 != null) {
                    result = new InputSource(is3);
                }
            } else if (systemID != null && (is = this.openSchemaStream(systemID)) != null) {
                result = new InputSource(is);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new SAXException(exc);
        }
        return result;
    }

    private InputStream openSchemaStream(String systemID) {
        String targetID = "/schemas/" + systemID.substring(systemID.lastIndexOf("/") + 1);
        InputStream result = this.getClass().getResourceAsStream(targetID);
        return result;
    }

    private InputStream openDTDStream(String publicID) {
        String targetID = "/dtds/" + mapping.get(publicID);
        InputStream result = this.getClass().getResourceAsStream(targetID);
        return result;
    }
}

