/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.util;

import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    static final int BUFFER = 2048;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public static void copyFile(String srcFile, String destFile) throws IOException {
        FileInputStream istream = new FileInputStream(srcFile);
        File dest = new File(destFile);
        FileUtils.copyFile(istream, dest);
    }

    public static void copyFile(InputStream istream, String destFile) throws IOException {
        File dest = new File(destFile);
        FileUtils.copyFile(istream, dest);
    }

    public static void copyFile(FileInputStream istream, String destFile) throws IOException {
        File dest = new File(destFile);
        FileUtils.copyFile(istream, dest);
    }

    public static void copyFile(InputStream istream, File dest) throws IOException {
        FileOutputStream ostream = new FileOutputStream(dest);
        dest.createNewFile();
        FileUtils.copyFileToStream(istream, (OutputStream)ostream);
        ((OutputStream)ostream).close();
    }

    public static void copyFile(FileInputStream istream, File dest) throws IOException {
        if (!dest.exists()) {
            dest.getParentFile().mkdirs();
        }
        FileOutputStream ostream = new FileOutputStream(dest);
        dest.createNewFile();
        FileUtils.copyFileToStream(istream, ostream);
        ostream.close();
    }

    public static void copyFileToStream(InputStream istream, OutputStream ostream) throws IOException {
        int nextByte;
        while ((nextByte = istream.read()) != -1) {
            ostream.write(nextByte);
        }
        istream.close();
    }

    public static void copyFileToStream(FileInputStream istream, FileOutputStream ostream) throws IOException {
        FileChannel srcChannel = istream.getChannel();
        FileChannel destChannel = ostream.getChannel();
        srcChannel.transferTo(0L, srcChannel.size(), destChannel);
        srcChannel.close();
        destChannel.close();
        istream.close();
    }

    public static void copyFileToWriter(InputStream istream, Writer writer) throws IOException {
        int nextByte;
        while ((nextByte = istream.read()) != -1) {
            writer.write(nextByte);
        }
        istream.close();
    }

    public static void copySearchPatternToFile(String srcFileName, String dstFileName, String searchPattern) throws FileNotFoundException, IOException {
        String fileLine;
        BufferedReader inFile = new BufferedReader(new FileReader(srcFileName));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(dstFileName)));
        while ((fileLine = inFile.readLine()) != null) {
            if (!fileLine.matches("(?i).*" + searchPattern + ".*")) continue;
            out.println(fileLine);
        }
        if (inFile != null) {
            inFile.close();
        }
        if (out != null) {
            out.close();
        }
    }

    public static void copyDir(String srcDir, String dstDir) throws IOException {
        FileUtils.copyDir(srcDir, dstDir, null, false);
    }

    public static void copyDir(String srcDir, String dstDir, boolean subDir) throws IOException {
        FileUtils.copyDir(srcDir, dstDir, null, subDir);
    }

    public static void copyDir(String srcDir, String dstDir, FilenameFilter filter, boolean subDir) throws IOException {
        int numFiles = 0;
        String[] strFiles = null;
        strFiles = filter == null ? new File(srcDir).list() : new File(srcDir).list(filter);
        if (strFiles != null) {
            numFiles = strFiles.length;
        }
        for (int i = 0; i < numFiles; ++i) {
            String srcFile = srcDir + File.separator + strFiles[i];
            String dstFile = dstDir + File.separator + strFiles[i];
            if (new File(srcFile).isFile()) {
                FileUtils.copyFile(srcFile, dstFile);
                continue;
            }
            if (!subDir) continue;
            File dstSubDir = new File(dstFile);
            dstSubDir.mkdirs();
            FileUtils.copyDir(srcFile, dstFile, filter, subDir);
        }
    }

    public static void extractJarFiles(String dir, String dest) {
        try {
            File aJarDir = new File(dir);
            File[] files = aJarDir.listFiles();
            FilenameFilter filter = FileUtils.getFilenameFilter(".jar");
            for (File file : files) {
                if (!filter.accept(aJarDir, file.getName())) continue;
                String fileName = file.getName();
                File outputDir = new File(dest);
                outputDir.mkdirs();
                FileUtils.unjar(file, "", outputDir.getAbsolutePath());
                file.delete();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e.fillInStackTrace());
        }
    }

    public static FilenameFilter getFilenameFilter(final String extension) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                boolean result = false;
                if (name != null && extension != null) {
                    result = name.toLowerCase().endsWith(extension.toLowerCase());
                }
                return result;
            }
        };
        return filter;
    }

    public static void jarDirectory(File jarFile, String dir) {
        try {
            BufferedInputStream origin = null;
            File aJarDir = new File(dir);
            File parent = jarFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream dest = new FileOutputStream(jarFile);
            JarOutputStream out = new JarOutputStream(new BufferedOutputStream(dest));
            out.setMethod(8);
            byte[] data = new byte[2048];
            List files = FileUtils.getFileListing(aJarDir, true);
            Iterator filesIter = files.iterator();
            int length = dir.length();
            while (filesIter.hasNext()) {
                File f = (File)filesIter.next();
                String path = f.getPath();
                String relativePath = path.substring(length);
                if (relativePath.startsWith("" + File.separator)) {
                    relativePath = path.substring(length + 1);
                }
                if (f.isDirectory()) {
                    relativePath = relativePath + "/";
                }
                JarEntry entry = new JarEntry(relativePath);
                out.putNextEntry(entry);
                if (!f.isDirectory()) {
                    int count;
                    FileInputStream fi = new FileInputStream(path);
                    origin = new BufferedInputStream(fi, 2048);
                    while ((count = origin.read(data, 0, 2048)) != -1) {
                        out.write(data, 0, count);
                    }
                }
                if (origin == null) continue;
                try {
                    origin.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException fnfEx) {
            fnfEx.printStackTrace();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public static void zipDirectory(File jarFile, String dir) {
        try {
            BufferedInputStream origin = null;
            File aJarDir = new File(dir);
            FileOutputStream dest = new FileOutputStream(jarFile);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            out.setMethod(8);
            byte[] data = new byte[2048];
            List files = FileUtils.getFileListing(aJarDir, true);
            for (File f : files) {
                String path = f.getPath();
                if (f.isDirectory()) {
                    path = path + "/";
                }
                ZipEntry entry = new ZipEntry(path);
                out.putNextEntry(entry);
                if (!f.isDirectory()) {
                    int count;
                    FileInputStream fi = new FileInputStream(path);
                    origin = new BufferedInputStream(fi, 2048);
                    while ((count = origin.read(data, 0, 2048)) != -1) {
                        out.write(data, 0, count);
                    }
                }
                if (origin == null) continue;
                try {
                    origin.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException fnfEx) {
            fnfEx.printStackTrace();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public static void unjar(File jarFile, String entryPath, String destDir) {
        int BUFFER = 2048;
        try {
            byte[] data = new byte[2048];
            if (entryPath == null) {
                entryPath = "";
            }
            JarFile jarfile = new JarFile(jarFile);
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                int count;
                JarEntry entry = e.nextElement();
                BufferedInputStream is = new BufferedInputStream(jarfile.getInputStream(entry));
                String path = entry.getName();
                if (!path.startsWith(entryPath)) continue;
                int start = path.lastIndexOf("/");
                String basis = null;
                if (start != -1) {
                    basis = path.substring(0, start);
                }
                String filename = path.substring(start + 1);
                File tmpPath = new File(destDir);
                if (basis != null && basis.length() != 0) {
                    tmpPath = new File(tmpPath, basis);
                    tmpPath.mkdirs();
                }
                if (filename == null || filename.length() == 0) continue;
                File destfile = new File(tmpPath, filename);
                FileOutputStream fos = new FileOutputStream(destfile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((count = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List getFileListing(File aStartingDir, boolean recurse) throws FileNotFoundException {
        FileUtils.validateDirectory(aStartingDir);
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        if (!recurse) {
            Collections.sort(filesDirs);
            return filesDirs;
        }
        Iterator<File> filesIter = filesDirs.iterator();
        ArrayList<File> result = new ArrayList<File>();
        File file = null;
        while (filesIter.hasNext()) {
            file = filesIter.next();
            result.add(file);
            if (!recurse || file.isFile()) continue;
            List deeperList = FileUtils.getFileListing(file, true);
            result.addAll(deeperList);
        }
        Collections.sort(result);
        return result;
    }

    public static List getFileListing(File aStartingDir, boolean recurse, FilenameFilter nameFilter, Comparator comparator) throws FileNotFoundException {
        FileUtils.validateDirectory(aStartingDir);
        File[] filesAndDirs = aStartingDir.listFiles(nameFilter);
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        if (!recurse) {
            Collections.sort(filesDirs, comparator);
            return filesDirs;
        }
        Iterator<File> filesIter = filesDirs.iterator();
        ArrayList<File> result = new ArrayList<File>();
        File file = null;
        while (filesIter.hasNext()) {
            file = filesIter.next();
            result.add(file);
            if (!recurse || file.isFile()) continue;
            List deeperList = FileUtils.getFileListing(file, true);
            result.addAll(deeperList);
        }
        Collections.sort(result, comparator);
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public static String getFileName(String absPath) {
        File file = new File(absPath);
        return file.getName();
    }

    public static void deleteFile(String fileName) {
        FileUtils.deleteFile(new File(fileName));
    }

    public static void deleteFile(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int size = files.length;
                for (int i = 0; i < size; ++i) {
                    FileUtils.deleteFile(files[i]);
                }
            }
            file.delete();
        }
    }

    public static void moveFile(String sourceFile, String destFile) throws IOException {
        FileUtils.copyFile(sourceFile, destFile);
        new File(sourceFile).delete();
    }
}

