/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.orbutil.misc.ORBClassLoader;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.iiop.GroupInfoServiceImplForJNLP;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASORBUtilities {
    private static Logger _logger = null;
    private static final String GMS_CLASS = "com.sun.enterprise.ee.ejb.iiop.IiopFolbGmsClient";
    private static boolean gisInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initGIS(ORB orb) {
        GroupInfoService gis = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "initGIS->: " + gisInitialized);
            }
            if (gisInitialized) {
                return;
            }
            gis = ASORBUtilities.isGMSAvailableAndClusterHeartbeatEnabled() ? ASORBUtilities.initGISUsesGMS() : ASORBUtilities.initGISUsesAdmin();
            if (gis == null) {
                return;
            }
            try {
                ((com.sun.corba.ee.spi.orb.ORB)((java.lang.Object)orb)).register_initial_reference("FolbServerGroupInfoService", (Object)gis);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ".initGIS: naming registration complete: " + gis);
                }
                gisInitialized = true;
                if (_logger.isLoggable(Level.FINE)) {
                    gis = (GroupInfoService)((com.sun.corba.ee.spi.orb.ORB)((java.lang.Object)orb)).resolve_initial_references("FolbServerGroupInfoService");
                    List<ClusterInstanceInfo> lcii = gis.getClusterInstanceInfo(null);
                    _logger.log(Level.FINE, "Results from getClusterInstanceInfo:");
                    if (lcii != null) {
                        for (ClusterInstanceInfo cii : lcii) {
                            _logger.log(Level.INFO, ASORBUtilities.toString(cii));
                        }
                    }
                }
            }
            catch (InvalidName e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.SEVERE, ".initGIS: registering GIS failed: " + (java.lang.Object)((java.lang.Object)e));
                }
            }
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "initGIS<-: " + gisInitialized + " " + gis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GroupInfoService initGISUsesAdmin() {
        GroupInfoServiceImplForJNLP result = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "initGISUsesAdmin->:");
            }
            GroupInfoServiceImplForJNLP groupInfoServiceImplForJNLP = result = new GroupInfoServiceImplForJNLP();
            return groupInfoServiceImplForJNLP;
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "initGISUsesAdmin<-: " + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GroupInfoService initGISUsesGMS() {
        GroupInfoService result = null;
        try {
            Class clazz;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "initGISUsesGMS->:");
            }
            if ((clazz = ASORBUtilities.loadClass(GMS_CLASS)) == null) {
                _logger.log(Level.SEVERE, ".initGISUsesGMS: GMS initialization failure: class not found: com.sun.enterprise.ee.ejb.iiop.IiopFolbGmsClient");
            }
            if ((result = (GroupInfoService)ASORBUtilities.newInstance(clazz)) == null) {
                _logger.log(Level.SEVERE, ".initGISUsesGMS: GMS initialization failure: cannot instantiate: com.sun.enterprise.ee.ejb.iiop.IiopFolbGmsClient");
            }
            GroupInfoService groupInfoService = result;
            return groupInfoService;
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "initGISUsesGMS<-: " + result);
            }
        }
    }

    public static boolean isGMSAvailableAndClusterHeartbeatEnabled() {
        Cluster cluster = null;
        boolean result = ASORBUtilities.loadClass("com.sun.enterprise.ee.cms.core.GMSFactory") != null && (cluster = ASORBUtilities.getCluster()) != null && ASORBUtilities.isClusterHeartbeatEnabled(cluster);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class loadClass(String classname) {
        Class result = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".loadClass->: " + classname);
            }
            result = ORBClassLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".loadClass: " + classname + " " + e);
            }
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".loadClass<-: " + classname + " " + result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.lang.Object newInstance(Class clazz) {
        java.lang.Object result = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".newInstance->: " + clazz);
            }
            result = clazz.newInstance();
        }
        catch (InstantiationException e) {
            _logger.log(Level.WARNING, ".newInstance: " + clazz + " " + e);
        }
        catch (IllegalAccessException e) {
            _logger.log(Level.WARNING, ".newInstance: " + clazz + " " + e);
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".newInstance<-: " + clazz + " " + result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cluster getCluster() {
        ServerContext serverContext;
        Cluster result;
        String instanceName;
        ConfigContext configCtx;
        block12: {
            configCtx = null;
            instanceName = null;
            result = null;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".getCluster->:");
            }
            if ((serverContext = ApplicationServer.getServerContext()) != null) break block12;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".getCluster: No ServerContext");
            }
            Cluster cluster = null;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".getCluster<-: " + result);
            }
            return cluster;
        }
        try {
            configCtx = serverContext.getConfigContext();
            instanceName = serverContext.getInstanceName();
            result = ClusterHelper.getClusterForInstance(configCtx, instanceName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".getCluster<-: " + result);
            }
        }
        catch (ConfigException e) {
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ".getCluster: ConfigContext: " + configCtx.toString() + " ; instanceName: " + instanceName + " ; exception: " + e);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ".getCluster<-: " + result);
                }
            }
            catch (Throwable throwable) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ".getCluster<-: " + result);
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClusterHeartbeatEnabled(Cluster cluster) {
        boolean result = false;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".isClusterHeartbeatEnabled->: " + cluster);
            }
            result = cluster.isHeartbeatEnabled();
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".isClusterHeartbeatEnabled<-: " + cluster + " " + result);
            }
        }
        return result;
    }

    public static boolean member(ClusterInstanceInfo item, List<ClusterInstanceInfo> list) {
        for (ClusterInstanceInfo element : list) {
            if (!ASORBUtilities.equals(item, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(ClusterInstanceInfo c1, ClusterInstanceInfo c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1.weight != c2.weight) {
            return false;
        }
        if (c1.endpoints.length != c2.endpoints.length) {
            return false;
        }
        if (!c1.name.equals(c2.name)) {
            return false;
        }
        for (int i = 0; i < c1.endpoints.length; ++i) {
            if (c1.endpoints[i].port != c2.endpoints[i].port) {
                return false;
            }
            if (!c1.endpoints[i].type.equals(c2.endpoints[i].type)) {
                return false;
            }
            if (c1.endpoints[i].host.equals(c2.endpoints[i].host)) continue;
            return false;
        }
        return true;
    }

    public static String toString(ClusterInstanceInfo cii) {
        return "[ClusterInstanceInfo " + cii.name + " " + cii.weight + " " + ASORBUtilities.toString(cii.endpoints) + "]";
    }

    public static String toString(SocketInfo[] socketInfo) {
        String result = "";
        for (int i = 0; i < socketInfo.length; ++i) {
            result = result + ASORBUtilities.toString(socketInfo[i]) + " ";
        }
        return result;
    }

    public static String toString(SocketInfo socketInfo) {
        return "[SocketInfo " + socketInfo.type + " " + socketInfo.host + " " + socketInfo.port + "]";
    }

    public static void forceStackTrace(String msg) {
        ASORBUtilities.forceStackTrace(msg, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceStackTrace(String msg, PrintStream out) {
        try {
            try {
                _logger.log(Level.INFO, msg + "->:");
                throw new Exception("FORCED STACKTRACE");
            }
            catch (Exception e) {
                e.printStackTrace(out);
                _logger.log(Level.INFO, msg + "<-:");
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.INFO, msg + "<-:");
            throw throwable;
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        gisInitialized = false;
    }
}

