/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.impl.encoding.CDROutputStream;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechList;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechListHelper;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.ServiceConfiguration;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import com.sun.corba.ee.org.omg.CSIIOP.TransportAddress;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CSIV2TaggedComponentInfo {
    private static Logger _logger = null;
    private String _realm_name = null;
    private byte[] _realm_name_bytes = null;
    private static final String DEFAULT_REALM = "default";
    public static final int SUPPORTED_IDENTITY_TOKEN_TYPES = 15;
    private ORB orb;
    private int sslMutualAuthPort;

    public CSIV2TaggedComponentInfo(ORB orb) {
        this.orb = orb;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort, EjbDescriptor desc) {
        org.omg.IOP.TaggedComponent tc = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IIOP: Creating a Security Tagged Component");
            }
            this._realm_name = desc.getApplication().getRealm();
            CompoundSecMech[] mechList = this.createCompoundSecMechs(sslPort, desc);
            tc = this.createTaggedComponent(mechList);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return tc;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort) {
        org.omg.IOP.TaggedComponent tc = null;
        try {
            boolean sslRequired = false;
            String sslReq = (String)ORBManager.getCSIv2Props().get("com.sun.CSIV2.ssl.server.required");
            if (sslReq != null && sslReq.equals("true")) {
                sslRequired = true;
            }
            boolean clientAuthReqd = false;
            String clientAuthReq = (String)ORBManager.getCSIv2Props().get("com.sun.CSIV2.client.auth.required");
            if (clientAuthReq != null && clientAuthReq.equals("true")) {
                clientAuthReqd = true;
            }
            CompoundSecMech[] mechList = new CompoundSecMech[1];
            org.omg.IOP.TaggedComponent transportMech = this.createSSLInfo(sslPort, null, sslRequired);
            AS_ContextSec asContext = this.createASContextSec(null);
            SAS_ContextSec sasContext = this.createSASContextSec(null);
            short targetRequires = clientAuthReqd ? (short)64 : 0;
            mechList[0] = new CompoundSecMech(targetRequires, transportMech, asContext, sasContext);
            tc = this.createTaggedComponent(mechList);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return tc;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(List<SocketInfo> scoketInfos) {
        org.omg.IOP.TaggedComponent tc = null;
        try {
            boolean sslRequired = false;
            String sslReq = (String)ORBManager.getCSIv2Props().get("com.sun.CSIV2.ssl.server.required");
            if (sslReq != null && sslReq.equals("true")) {
                sslRequired = true;
            }
            boolean clientAuthReqd = false;
            String clientAuthReq = (String)ORBManager.getCSIv2Props().get("com.sun.CSIV2.client.auth.required");
            if (clientAuthReq != null && clientAuthReq.equals("true")) {
                clientAuthReqd = true;
            }
            CompoundSecMech[] mechList = new CompoundSecMech[1];
            org.omg.IOP.TaggedComponent transportMech = this.createSSLInfo(scoketInfos, null, sslRequired);
            AS_ContextSec asContext = this.createASContextSec(null);
            SAS_ContextSec sasContext = this.createSASContextSec(null);
            short targetRequires = clientAuthReqd ? (short)64 : 0;
            mechList[0] = new CompoundSecMech(targetRequires, transportMech, asContext, sasContext);
            tc = this.createTaggedComponent(mechList);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return tc;
    }

    private org.omg.IOP.TaggedComponent createTaggedComponent(CompoundSecMech[] mechList) {
        CDROutputStream out = (CDROutputStream)this.orb.create_output_stream();
        out.putEndian();
        boolean stateful = false;
        CompoundSecMechList list = new CompoundSecMechList(stateful, mechList);
        CompoundSecMechListHelper.write((OutputStream)out, list);
        byte[] buf = out.toByteArray();
        org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(33, buf);
        return tc;
    }

    public void setSSLMutualAuthPort(int port) {
        this.sslMutualAuthPort = port;
    }

    private int getSSLMutualAuthPort() {
        return this.sslMutualAuthPort;
    }

    private CompoundSecMech[] createCompoundSecMechs(int sslPort, EjbDescriptor desc) throws IOException {
        Set iorDescSet;
        int size;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating CompoundSecMech");
        }
        if ((size = (iorDescSet = desc.getIORConfigurationDescriptors()).size()) == 0) {
            EjbIORConfigurationDescriptor eDesc = new EjbIORConfigurationDescriptor();
            eDesc.setIntegrity("SUPPORTED");
            eDesc.setConfidentiality("SUPPORTED");
            eDesc.setEstablishTrustInClient("SUPPORTED");
            iorDescSet.add(eDesc);
            size = 1;
            Set permissions = desc.getPermissionedRoles();
            if (permissions.size() > 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IIOP:Application has protected methods");
                }
                eDesc.setAuthMethodRequired(true);
            }
        }
        CompoundSecMech[] mechList = new CompoundSecMech[size];
        Iterator itr = iorDescSet.iterator();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IORDescriptor SIZE:" + size);
        }
        for (int i = 0; i < size; ++i) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            org.omg.IOP.TaggedComponent comp = this.createSSLInfo(sslPort, iorDesc, false);
            AS_ContextSec asContext = this.createASContextSec(iorDesc);
            SAS_ContextSec sasContext = this.createSASContextSec(iorDesc);
            int targ_req = target_requires | asContext.target_requires | sasContext.target_requires;
            org.omg.IOP.TaggedComponent transportMech = comp;
            mechList[i] = new CompoundSecMech((short)targ_req, transportMech, asContext, sasContext);
        }
        return mechList;
    }

    public boolean allMechanismsRequireSSL(Set iorDescSet) {
        int size = iorDescSet.size();
        if (size == 0) {
            return false;
        }
        Iterator itr = iorDescSet.iterator();
        for (int i = 0; i < size; ++i) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            if (target_requires != 0) continue;
            return false;
        }
        return true;
    }

    public AS_ContextSec createASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        AS_ContextSec asContext = null;
        int target_supports = 0;
        int target_requires = 0;
        byte[] client_authentication_mechanism = new byte[]{};
        byte[] target_name = new byte[]{};
        String authMethod = null;
        boolean authMethodRequired = false;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating AS_Context");
        }
        if (iorDesc != null) {
            authMethod = iorDesc.getAuthenticationMethod();
            authMethodRequired = iorDesc.isAuthMethodRequired();
        }
        if (authMethod != null && authMethod.equalsIgnoreCase("NONE")) {
            asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
            return asContext;
        }
        if (this._realm_name == null) {
            if (iorDesc != null) {
                this._realm_name = iorDesc.getRealmName();
            }
            if (this._realm_name == null) {
                this._realm_name = DEFAULT_REALM;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IIOP:AS_Context: Realm Name = null, setting default realm for logging in");
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP:AS_Context: Realm Name for login = " + this._realm_name);
        }
        this._realm_name_bytes = this._realm_name.getBytes();
        target_name = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, this._realm_name_bytes);
        target_supports = 64;
        if (authMethodRequired) {
            target_requires = 64;
        }
        client_authentication_mechanism = this.getMechanism();
        asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
        return asContext;
    }

    public SAS_ContextSec createSASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        SAS_ContextSec sasContext = null;
        int target_supports = 0;
        boolean target_requires = false;
        ServiceConfiguration[] priv = new ServiceConfiguration[]{};
        String callerPropagation = null;
        Object mechanisms = new byte[][]{};
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating SAS_Context");
        }
        int supported_identity_token_type = 0;
        if (iorDesc != null) {
            callerPropagation = iorDesc.getCallerPropagation();
        }
        if (callerPropagation != null && callerPropagation.equalsIgnoreCase("NONE")) {
            sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
            return sasContext;
        }
        target_supports = 1024;
        byte[] upm = this.getMechanism();
        mechanisms = new byte[1][upm.length];
        for (int i = 0; i < upm.length; ++i) {
            mechanisms[0][i] = upm[i];
        }
        if (target_supports != 0) {
            supported_identity_token_type = 15;
        }
        sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
        return sasContext;
    }

    private org.omg.IOP.TaggedComponent createSSLInfo(int sslport, EjbIORConfigurationDescriptor iorDesc, boolean sslRequired) {
        int targetSupports = 0;
        int targetRequires = 0;
        int ssl_port = sslport;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating Transport Mechanism");
        }
        if (iorDesc == null) {
            targetSupports = 102;
            if (sslRequired) {
                targetRequires = 70;
            }
        } else {
            targetSupports = this.getTargetSupports(iorDesc);
            targetRequires = this.getTargetRequires(iorDesc);
            if ((targetRequires & 0x40) == 64) {
                ssl_port = this.getSSLMutualAuthPort();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "MUTUAL AUTH PORT=" + sslport);
                }
            }
        }
        if ((targetSupports | targetRequires) == 0 || ssl_port == -1) {
            byte[] b = new byte[]{};
            org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(34, b);
            return tc;
        }
        String host_name = "";
        host_name = Utility.getLocalAddress();
        TransportAddress[] listTa = this.generateTransportAddresses(host_name, ssl_port);
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)targetSupports, (short)targetRequires, listTa);
        CDROutputStream out = (CDROutputStream)this.orb.create_output_stream();
        out.putEndian();
        TLS_SEC_TRANSHelper.write((OutputStream)out, tls_sec);
        byte[] buf = out.toByteArray();
        org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(36, buf);
        return tc;
    }

    private TransportAddress[] generateTransportAddresses(String host, int sslport) {
        short short_port = Utility.intToShort(sslport);
        TransportAddress ta = new TransportAddress(host, short_port);
        TransportAddress[] listTa = new TransportAddress[]{ta};
        return listTa;
    }

    private org.omg.IOP.TaggedComponent createSSLInfo(List<SocketInfo> scoketInfos, EjbIORConfigurationDescriptor iorDesc, boolean sslRequired) {
        int targetSupports = 0;
        int targetRequires = 0;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating Transport Mechanism");
        }
        if (iorDesc == null) {
            targetSupports = 102;
            if (sslRequired) {
                targetRequires = 70;
            }
        } else {
            targetSupports = this.getTargetSupports(iorDesc);
            targetRequires = this.getTargetRequires(iorDesc);
            if ((targetRequires & 0x40) != 64 || _logger.isLoggable(Level.FINE)) {
                // empty if block
            }
        }
        if ((targetSupports | targetRequires) == 0) {
            byte[] b = new byte[]{};
            org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(34, b);
            return tc;
        }
        TransportAddress[] listTa = this.generateTransportAddresses(scoketInfos);
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)targetSupports, (short)targetRequires, listTa);
        CDROutputStream out = (CDROutputStream)this.orb.create_output_stream();
        out.putEndian();
        TLS_SEC_TRANSHelper.write((OutputStream)out, tls_sec);
        byte[] buf = out.toByteArray();
        org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(36, buf);
        return tc;
    }

    private TransportAddress[] generateTransportAddresses(List<SocketInfo> socketInfos) {
        TransportAddress[] listTa = new TransportAddress[socketInfos.size()];
        for (int i = 0; i < socketInfos.size(); ++i) {
            TransportAddress ta;
            SocketInfo socketInfo = socketInfos.get(i);
            int sslport = socketInfo.port;
            String host = socketInfo.host;
            short short_port = Utility.intToShort(sslport);
            listTa[i] = ta = new TransportAddress(host, short_port);
        }
        return listTa;
    }

    public CompoundSecMech[] getSecurityMechanisms(IOR ior) {
        IIOPProfile prof = ior.getProfile();
        IIOPProfileTemplate ptemp = (IIOPProfileTemplate)prof.getTaggedProfileTemplate();
        Iterator<TaggedComponent> itr = ptemp.iteratorById(33);
        if (!itr.hasNext()) {
            if (_logger.isLoggable(Level.FINE)) {
                String msg = "IIOP:TAG_CSI_SEC_MECH_LIST tagged component not found";
                _logger.log(Level.FINE, msg);
            }
            return null;
        }
        TaggedComponent o = itr.next();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Component:" + o);
        }
        if (itr.hasNext()) {
            String msg = "More than one TAG_CSI_SEC_MECH_LIST tagged component found ";
            _logger.log(Level.SEVERE, "iiop.many_tagged_component");
            throw new RuntimeException(msg);
        }
        TaggedComponent tcomp = o;
        org.omg.IOP.TaggedComponent comp = tcomp.getIOPComponent(this.orb);
        byte[] b = comp.component_data;
        EncapsInputStream in = new EncapsInputStream(this.orb, b, b.length);
        in.consumeEndian();
        CompoundSecMechList l = CompoundSecMechListHelper.read((InputStream)in);
        CompoundSecMech[] list = l.mechanism_list;
        return list;
    }

    public TLS_SEC_TRANS getSSLInformation(CompoundSecMech mech) {
        org.omg.IOP.TaggedComponent pcomp = mech.transport_mech;
        TLS_SEC_TRANS ssl = this.getSSLComponent(pcomp);
        return ssl;
    }

    private TLS_SEC_TRANS getSSLComponent(org.omg.IOP.TaggedComponent comp) {
        TLS_SEC_TRANS ssl = null;
        if (comp.tag == 34) {
            ssl = null;
        } else {
            byte[] b = comp.component_data;
            EncapsInputStream in = new EncapsInputStream(this.orb, b, b.length);
            in.consumeEndian();
            ssl = TLS_SEC_TRANSHelper.read((InputStream)in);
        }
        return ssl;
    }

    public int getTargetSupports(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int supports = 0;
        String integrity = iorDesc.getIntegrity();
        if (!integrity.equalsIgnoreCase("NONE")) {
            supports |= 2;
        }
        if (!(confidentiality = iorDesc.getConfidentiality()).equalsIgnoreCase("NONE")) {
            supports |= 4;
        }
        if (!(establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equalsIgnoreCase("NONE")) {
            supports |= 0x20;
        }
        if (!(establishTrustInClient = iorDesc.getEstablishTrustInClient()).equalsIgnoreCase("NONE")) {
            supports |= 0x40;
        }
        return supports;
    }

    public int getTargetRequires(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int requires = 0;
        String integrity = iorDesc.getIntegrity();
        if (integrity.equalsIgnoreCase("REQUIRED")) {
            requires |= 2;
        }
        if ((confidentiality = iorDesc.getConfidentiality()).equalsIgnoreCase("REQUIRED")) {
            requires |= 4;
        }
        if ((establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equalsIgnoreCase("REQUIRED")) {
            requires |= 0x20;
        }
        if ((establishTrustInClient = iorDesc.getEstablishTrustInClient()).equalsIgnoreCase("REQUIRED")) {
            requires |= 0x40;
        }
        return requires;
    }

    private byte[] getMechanism() throws IOException {
        return GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

