/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.folb.CSIv2SSLTaggedComponentHandler;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt;
import com.sun.corba.ee.spi.legacy.interceptor.UnknownType;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSIv2SSLTaggedComponentHandlerImpl
extends LocalObject
implements CSIv2SSLTaggedComponentHandler,
ORBConfigurator {
    private static Logger _logger = null;
    private final String baseMsg = CSIv2SSLTaggedComponentHandlerImpl.class.getName();
    private com.sun.corba.ee.spi.orb.ORB orb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggedComponent insert(IORInfo iorInfo, List<ClusterInstanceInfo> clusterInstanceInfo) {
        TaggedComponent result = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".insert->:");
            }
            ArrayList<SocketInfo> socketInfos = new ArrayList<SocketInfo>();
            for (ClusterInstanceInfo clInstInfo : clusterInstanceInfo) {
                for (int endPIndex = 0; endPIndex < clInstInfo.endpoints.length; ++endPIndex) {
                    SocketInfo socketInfo = clInstInfo.endpoints[endPIndex];
                    if (!socketInfo.type.equals("SSL") && !socketInfo.type.equals("SSL_MUTUALAUTH")) continue;
                    socketInfos.add(socketInfo);
                }
            }
            ORB orb = ORBManager.getORB();
            int sslMutualAuthPort = -1;
            try {
                sslMutualAuthPort = ((IORInfoExt)iorInfo).getServerPort("SSL_MUTUALAUTH");
            }
            catch (UnknownType ute) {
                _logger.log(Level.FINE, ".isnert: UnknownType exception", ute);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".insert: sslMutualAuthPort: " + sslMutualAuthPort);
            }
            CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(orb);
            ctc.setSSLMutualAuthPort(sslMutualAuthPort);
            TaggedComponent taggedComponent = result = ctc.createSecurityTaggedComponent(socketInfos);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".insert<-: " + result);
            }
            return taggedComponent;
        }
        catch (Throwable throwable) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".insert<-: " + result);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<com.sun.corba.ee.spi.transport.SocketInfo> extract(IOR ior) {
        List<com.sun.corba.ee.spi.transport.SocketInfo> socketInfo = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract->:");
            }
            SecurityMechanismSelector selector = new SecurityMechanismSelector();
            IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
            String host = primary.getHost().toLowerCase();
            ConnectionContext ctx = new ConnectionContext();
            socketInfo = selector.getSSLPorts(ior, ctx);
            selector.setClientConnectionContext(ctx);
            if (socketInfo == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.baseMsg + ".extract: did not find SSL SocketInfo");
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract: found SSL socketInfo");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract: Connection Context:" + ctx);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Exception getting SocketInfo", ex);
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".extract<-: " + socketInfo);
            }
        }
        return socketInfo;
    }

    @Override
    public void configure(DataCollector collector, com.sun.corba.ee.spi.orb.ORB orb) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, ".configure->:");
        }
        this.orb = orb;
        try {
            orb.register_initial_reference("CSIv2SSLTaggedComponentHandler", (Object)this);
        }
        catch (InvalidName e) {
            _logger.log(Level.WARNING, ".configure: ", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, ".configure<-:");
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

