/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.iiop.ASORBUtilities;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponent;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponentHelper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverIORInterceptor
extends LocalObject
implements ORBInitializer,
IORInterceptor {
    private static Logger _logger = null;
    private ORB orb;
    private static final String baseMsg;
    private static final String ORB_LISTENTER = "orb-listener";
    private List currentAddressList;
    private List previousAddressList;
    private List randomizedAddressList;
    private List randomizedAndMarshaledAddressList;

    public String name() {
        return baseMsg;
    }

    public void destroy() {
    }

    public FailoverIORInterceptor() {
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        ORB orb = ((ORBInitInfoExt)info).getORB();
        try {
            info.add_ior_interceptor((IORInterceptor)new FailoverIORInterceptor(orb));
            _logger.log(Level.FINE, baseMsg + " registered.");
        }
        catch (DuplicateName ex) {
            _logger.log(Level.WARNING, "DuplicateName from " + baseMsg, ex);
        }
    }

    public FailoverIORInterceptor(ORB orb) {
        this.orb = orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establish_components(IORInfo iorInfo) {
        try {
            _logger.log(Level.FINE, baseMsg + ".establish_components->:");
            if (ApplicationServer.getServerContext() == null) {
                _logger.log(Level.FINE, baseMsg + ".establish_components:" + " not adding AlternateIIOPAddressComponent" + " because: no server context");
                return;
            }
            ConfigContext configCtx = ApplicationServer.getServerContext().getConfigContext();
            String instanceName = ApplicationServer.getServerContext().getInstanceName();
            Cluster cluster = null;
            try {
                cluster = ClusterHelper.getClusterForInstance(configCtx, instanceName);
            }
            catch (ConfigException e) {
                _logger.log(Level.FINE, baseMsg + ".establish_components:" + " not adding AlternateIIOPAddressComponent" + " because: " + e);
                _logger.log(Level.FINE, baseMsg + ".establish_components<-:");
                return;
            }
            ServerRef[] servers = cluster.getServerRef();
            IiopListener[][] listeners = FailoverIORInterceptor.getIIOPEndPointsForCurrentCluster(configCtx, instanceName, servers);
            this.currentAddressList = new ArrayList();
            for (int i = 0; i < servers.length; ++i) {
                String serverName = servers[i].getRef();
                String hostName = FailoverIORInterceptor.getHostNameForServerInstance(configCtx, serverName);
                if (hostName == null) {
                    hostName = listeners[i][0].getAddress();
                }
                for (int j = 0; j < listeners[i].length; ++j) {
                    String id = listeners[i][j].getId();
                    String port = FailoverIORInterceptor.getResolvedPort(configCtx, listeners[i][j], serverName);
                    if (!id.startsWith(ORB_LISTENTER)) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, baseMsg + ".establish_components:" + " ignoring SSL ports: " + id + " " + hostName + " " + port);
                        continue;
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, baseMsg + ".establish_components:" + " adding AlternateIIOPAddressComponent" + " for listener id: " + id + " address/port: " + hostName + "/" + port);
                    }
                    AlternateIIOPAddressComponent address = new AlternateIIOPAddressComponent(hostName, Integer.decode(port).shortValue());
                    this.currentAddressList.add(address);
                }
            }
            if (this.previousAddressList == null) {
                this.previousAddressList = new ArrayList();
                Iterator i = this.currentAddressList.iterator();
                while (i.hasNext()) {
                    this.previousAddressList.add(i.next());
                }
                Collections.shuffle(this.currentAddressList);
                this.randomizedAddressList = this.currentAddressList;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, baseMsg + " first call - saving randomized alternate address list: " + this.randomizedAddressList);
                }
                this.randomizedAndMarshaledAddressList = new ArrayList();
                for (AlternateIIOPAddressComponent address : this.randomizedAddressList) {
                    Any any = this.orb.create_any();
                    AlternateIIOPAddressComponentHelper.insert(any, address);
                    byte[] data = FailoverIORInterceptor.getCodec(this.orb).encode_value(any);
                    TaggedComponent tc = new TaggedComponent(3, data);
                    this.randomizedAndMarshaledAddressList.add(tc);
                }
            } else if (!((java.lang.Object)this.currentAddressList).equals(this.previousAddressList)) {
                throw new RuntimeException("Current address list: " + this.currentAddressList + " different from previous list: " + this.previousAddressList);
            }
            Iterator i = this.randomizedAndMarshaledAddressList.iterator();
            while (i.hasNext()) {
                iorInfo.add_ior_component((TaggedComponent)i.next());
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, baseMsg + " adding randomized alternate addresses: " + this.randomizedAddressList);
            }
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Problem in " + baseMsg + ".establish_components", e);
        }
        finally {
            _logger.log(Level.FINE, baseMsg + ".establish_components<-:");
        }
    }

    public void components_established(IORInfo iorInfo) {
    }

    public void adapter_manager_state_changed(int managerId, short state) {
    }

    public void adapter_state_changed(ObjectReferenceTemplate[] templates, short state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClusterInstanceInfo> getClusterInstanceInfo() {
        LinkedList<ClusterInstanceInfo> result = new LinkedList<ClusterInstanceInfo>();
        try {
            _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo->:");
            if (ApplicationServer.getServerContext() == null) {
                _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo:" + " not adding addresses " + " because: no server context");
                List<ClusterInstanceInfo> list = null;
                return list;
            }
            ConfigContext configCtx = ApplicationServer.getServerContext().getConfigContext();
            String instanceName = ApplicationServer.getServerContext().getInstanceName();
            Cluster cluster = null;
            try {
                cluster = ClusterHelper.getClusterForInstance(configCtx, instanceName);
            }
            catch (ConfigException e) {
                _logger.log(Level.FINE, baseMsg + ".getClusterForInstance: " + e);
                List<ClusterInstanceInfo> list = null;
                _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo<-: " + result);
                return list;
            }
            ServerRef[] servers = cluster.getServerRef();
            IiopListener[][] listeners = FailoverIORInterceptor.getIIOPEndPointsForCurrentCluster(configCtx, instanceName, servers);
            for (int i = 0; i < servers.length; ++i) {
                String serverName = servers[i].getRef();
                String hostName = FailoverIORInterceptor.getHostNameForServerInstance(configCtx, serverName);
                if (hostName == null) {
                    hostName = listeners[i][0].getAddress();
                }
                LinkedList<SocketInfo> listOfSocketInfo = new LinkedList<SocketInfo>();
                for (int j = 0; j < listeners[i].length; ++j) {
                    String id = listeners[i][j].getId();
                    String port = FailoverIORInterceptor.getResolvedPort(configCtx, listeners[i][j], serverName);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, baseMsg + ".getClusterForInstance:" + " adding address for " + serverName + "/" + id + "/" + hostName + "/" + port);
                    }
                    listOfSocketInfo.add(new SocketInfo(id, hostName, Integer.valueOf(port)));
                }
                SocketInfo[] arrayOfSocketInfo = new SocketInfo[listOfSocketInfo.size()];
                int x = 0;
                for (SocketInfo si : listOfSocketInfo) {
                    arrayOfSocketInfo[x++] = si;
                }
                ClusterInstanceInfo clusterInstanceInfo = new ClusterInstanceInfo(serverName, 100, arrayOfSocketInfo);
                result.add(clusterInstanceInfo);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, baseMsg + ".getClusterForInstance: " + ASORBUtilities.toString(clusterInstanceInfo));
            }
            LinkedList<ClusterInstanceInfo> linkedList = result;
            return linkedList;
        }
        catch (ConfigException e) {
            List<ClusterInstanceInfo> list = null;
            return list;
        }
        finally {
            _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo<-: " + result);
        }
    }

    private static IiopListener[][] getIIOPEndPointsForCurrentCluster(ConfigContext configCtx, String instanceName, ServerRef[] servers) throws ConfigException {
        IiopListener[][] listeners = new IiopListener[servers.length][3];
        for (int i = 0; i < servers.length; ++i) {
            Server server = ServerHelper.getServerByName(configCtx, servers[i].getRef());
            String configRef = server.getConfigRef();
            Config config = ConfigAPIHelper.getConfigByName(configCtx, configRef);
            IiopService iiopService = config.getIiopService();
            listeners[i] = iiopService.getIiopListener();
        }
        return listeners;
    }

    private static String getHostNameForServerInstance(ConfigContext ctx, String serverName) {
        try {
            JMXConnectorConfig info = ServerHelper.getJMXConnectorInfo(ctx, serverName);
            _logger.log(Level.FINE, baseMsg + ".getHostNameForServerInstance: " + "found info: " + info.toString());
            String host = info.getHost();
            _logger.log(Level.FINE, baseMsg + ".getHostNameForServerInstance: " + "found host: " + host);
            return host;
        }
        catch (Throwable e) {
            _logger.log(Level.FINE, baseMsg + ".getHostNameForServerInstance: " + "gotException: " + e + " " + e.getMessage() + "; returning null");
            return null;
        }
    }

    private static String getResolvedPort(ConfigContext ctx, IiopListener l, String server) throws ConfigException {
        String rawPort = l.getRawAttributeValue("port");
        PropertyResolver pr = new PropertyResolver(ctx, server);
        return pr.resolve(rawPort);
    }

    static Codec getCodec(ORB orb) {
        Codec result = null;
        try {
            CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
            result = codecFactory.create_codec(new Encoding(0, 1, 2));
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Problem in " + baseMsg + ".getCodec", e);
        }
        return result;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        baseMsg = FailoverIORInterceptor.class.getName();
    }
}

