/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt;
import com.sun.corba.ee.spi.legacy.interceptor.UnknownType;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.iiop.ASORBUtilities;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.CSIv2Policy;
import com.sun.enterprise.iiop.OTSPolicy;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class TxSecIORInterceptor
extends LocalObject
implements IORInterceptor {
    private static Logger _logger = null;
    private Codec codec;

    public TxSecIORInterceptor(Codec c) {
        this.codec = c;
    }

    public void destroy() {
    }

    public String name() {
        return "TxSecIORInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establish_components(IORInfo iorInfo) {
        try {
            _logger.log(Level.FINE, "TxSecIORInterceptor.establish_components->:");
            OTSPolicy otsPolicy = null;
            try {
                otsPolicy = (OTSPolicy)iorInfo.get_effective_policy(1398079611);
            }
            catch (INV_POLICY ex) {
                _logger.log(Level.FINE, "TxSecIORInterceptor.establish_components: OTSPolicy not present");
            }
            if (otsPolicy != null) {
                this.addOTSComponents(iorInfo);
            }
            CSIv2Policy csiv2Policy = null;
            try {
                csiv2Policy = (CSIv2Policy)iorInfo.get_effective_policy(1398079612);
            }
            catch (INV_POLICY ex) {
                _logger.log(Level.FINE, "TxSecIORInterceptor.establish_components: CSIv2Policy not present");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "TxSecIORInterceptor.establish_components: CSIv2Policy: " + (Object)((Object)csiv2Policy));
            }
            this.addCSIv2Components(iorInfo, csiv2Policy);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception in establish_components", e);
        }
        finally {
            _logger.log(Level.FINE, "TxSecIORInterceptor.establish_components<-:");
        }
    }

    private void addOTSComponents(IORInfo iorInfo) {
        short invPolicyValue = 1;
        short otsPolicyValue = 3;
        Any otsAny = ORB.init().create_any();
        Any invAny = ORB.init().create_any();
        otsAny.insert_short(otsPolicyValue);
        invAny.insert_short(invPolicyValue);
        byte[] otsCompValue = null;
        byte[] invCompValue = null;
        try {
            otsCompValue = this.codec.encode_value(otsAny);
            invCompValue = this.codec.encode_value(invAny);
        }
        catch (InvalidTypeForEncoding e) {
            throw new INTERNAL("InvalidTypeForEncoding " + e.getMessage());
        }
        TaggedComponent otsComp = new TaggedComponent(31, otsCompValue);
        iorInfo.add_ior_component(otsComp);
        TaggedComponent invComp = new TaggedComponent(32, invCompValue);
        iorInfo.add_ior_component(invComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCSIv2Components(IORInfo iorInfo, CSIv2Policy csiv2Policy) {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".addCSIv2Components->:  " + iorInfo + " " + (Object)((Object)csiv2Policy));
            }
            if (ASORBUtilities.isGMSAvailableAndClusterHeartbeatEnabled()) {
                return;
            }
            EjbDescriptor ejbDesc = null;
            if (csiv2Policy != null) {
                ejbDesc = csiv2Policy.getEjbDescriptor();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".addCSIv2Components: ejbDesc: " + ejbDesc);
            }
            ORB orb = ORBManager.getORB();
            int sslMutualAuthPort = -1;
            try {
                sslMutualAuthPort = ((IORInfoExt)iorInfo).getServerPort("SSL_MUTUALAUTH");
            }
            catch (UnknownType ute) {
                _logger.log(Level.FINE, "UnknownType exception", ute);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".addCSIv2Components: sslMutualAuthPort: " + sslMutualAuthPort);
            }
            CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(orb);
            ctc.setSSLMutualAuthPort(sslMutualAuthPort);
            int sslport = -1;
            try {
                sslport = ((IORInfoExt)iorInfo).getServerPort("SSL");
            }
            catch (UnknownType ute) {
                _logger.log(Level.FINE, "UnknownType exception", ute);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".addCSIv2Components: sslport: " + sslport);
            }
            TaggedComponent csiv2Comp = null;
            csiv2Comp = ejbDesc != null ? ctc.createSecurityTaggedComponent(sslport, ejbDesc) : ctc.createSecurityTaggedComponent(sslport);
            iorInfo.add_ior_component(csiv2Comp);
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ".addCSIv2Components<-:  " + iorInfo + " " + (Object)((Object)csiv2Policy));
            }
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

