/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.jbi.serviceengine.install.Installer;
import com.sun.enterprise.jbi.serviceengine.install.ServiceEngineObjectFactoryImpl;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.webservice.ServiceEngineUtil;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaEEServiceEngineLifeCycle
implements ServerLifecycle {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    public String DEFAULT_COMPONENT_NAME = "JavaEEServiceEngine";

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        logger.log(Level.FINEST, "se_lifecycle_initializing");
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        logger.log(Level.FINEST, "se_lifecycle_starting");
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
        Installer installer = ServiceEngineObjectFactoryImpl.getInstance().createInstaller();
        if (installer.isJBIInstalled()) {
            installer.setComponentName(this.DEFAULT_COMPONENT_NAME);
            try {
                boolean installedFlag = installer.isComponentInstalled();
                logger.log(Level.FINE, "Is Java EE Service Engine installed " + installedFlag);
                if (ServiceEngineUtil.isServiceEngineEnabled()) {
                    if (!installedFlag) {
                        installer.install(null);
                        installer.start();
                    }
                } else {
                    logger.log(Level.FINEST, "Java EE Service Engine is disabled");
                    if (installedFlag) {
                        try {
                            installer.stop();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void onShutdown() throws ServerLifecycleException {
    }

    public void onTermination() throws ServerLifecycleException {
    }
}

