/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.GlobalResourceDeployer;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminObjectResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        AdminObjectResource aor = (AdminObjectResource)resource;
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        if (aor.isEnabled()) {
            ManagementObjectManager mgr = this.getAppServerSwitchObject().getManagementObjectManager();
            mgr.registerAdminObjectResource(aor.getJndiName(), aor.getResAdapter(), aor.getResType(), this.getPropNamesAsStrArr(aor.getElementProperty()), this.getPropValuesAsStrArr(aor.getElementProperty()));
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{aor.getJndiName(), "jms-resource"});
        }
        _logger.log(Level.FINE, "Calling backend to add adminObject", aor.getJndiName());
        crt.addAdminObject(null, aor.getResAdapter(), aor.getJndiName(), aor.getResType(), this.transformProps(aor.getElementProperty()));
        _logger.log(Level.FINE, "Added adminObject in backend", aor.getJndiName());
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        AdminObjectResource aor = (AdminObjectResource)resource;
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        _logger.log(Level.FINE, "Calling backend to delete adminObject", aor.getJndiName());
        crt.deleteAdminObject(aor.getJndiName());
        _logger.log(Level.FINE, "Deleted adminObject in backend", aor.getJndiName());
        ManagementObjectManager mgr = this.getAppServerSwitchObject().getManagementObjectManager();
        mgr.unregisterAdminObjectResource(aor.getJndiName(), aor.getResType());
    }

    public synchronized void redeployResource(Object resource) throws Exception {
    }

    public synchronized void disableResource(Object resource) throws Exception {
    }

    public synchronized void enableResource(Object resource) throws Exception {
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        AdminObjectResource res = rbeans.getAdminObjectResourceByJndiName(name);
        if (res == null) {
            Exception ex = new Exception("No such resource");
            _logger.log(Level.SEVERE, "no_resource", name);
            _logger.log(Level.SEVERE, "", ex);
            throw ex;
        }
        return res;
    }

    Properties transformProps(ElementProperty[] domainProps) {
        Properties props = new Properties();
        for (int i = 0; i < domainProps.length; ++i) {
            props.setProperty(domainProps[i].getName(), domainProps[i].getValue());
        }
        return props;
    }
}

