/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.resource.Resource;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtilities {
    private ResourceUtilities() {
    }

    public static Set<Resource> getResourceConfigConflicts(Set<Resource> resSet, ConfigContext cc) throws ConfigException {
        HashSet<Resource> conflicts = new HashSet<Resource>();
        if (resSet != null) {
            for (Resource res : resSet) {
                String id = ResourceUtilities.getIdToCompare(res);
                ConfigBean sb = ResourceHelper.findResource(cc, id);
                if (sb == null) continue;
                conflicts.add(res);
            }
        }
        return conflicts;
    }

    private static String getIdToCompare(Resource res) {
        AttributeList attrs = res.getAttributes();
        String type = res.getType();
        String id = "jdbc-connection-pool".equals(type) || "connector-connection-pool".equals(type) || "resource-adapter-config".equals(type) || "security-map".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("resource-adapter-config".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "resource-adapter-name") : ResourceUtilities.getNamedAttributeValue(attrs, "jndi-name"));
        return id;
    }

    private static String getNamedAttributeValue(AttributeList attrs, String aName) {
        String value = null;
        for (Object obj : attrs) {
            Attribute a;
            if (!(obj instanceof Attribute) || !aName.equals((a = (Attribute)obj).getName())) continue;
            value = a.getValue().toString();
        }
        return value;
    }
}

