/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ondemand;

import com.sun.enterprise.appclient.jws.AppclientJWSSupportManager;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ondemand.OnDemandServer;
import com.sun.enterprise.server.ondemand.OnDemandServices;
import com.sun.enterprise.server.ondemand.ServiceGroup;
import com.sun.enterprise.server.ondemand.ServiceGroupException;
import com.sun.enterprise.server.ondemand.SystemAppLoader;
import com.sun.enterprise.server.ondemand.entry.EntryContext;
import java.util.logging.Level;
import javax.management.ObjectName;

public class WebServiceGroup
extends ServiceGroup {
    public void start(EntryContext context) throws ServiceGroupException {
        try {
            this.startLifecycleServices(context.getServerContext());
            this.loadSystemApps();
            AppclientJWSSupportManager.getInstance().startJWSServicesForDeployedAppclients();
            this.setState(2);
        }
        catch (Exception e) {
            throw new ServiceGroupException(e);
        }
    }

    private void loadSystemApps() {
        SystemAppLoader loader = OnDemandServer.getSystemAppLoader();
        loader.loadSystemApps(loader.getWebServiceGroupSystemApps());
    }

    public boolean analyseEntryContext(EntryContext context) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Analysing the context in Web ServiceGroup :" + context);
        }
        if (context.get() == null) {
            return false;
        }
        boolean result = false;
        try {
            ConfigContext ctxt = context.getServerContext().getConfigContext();
            Config conf = ServerBeansFactory.getConfigBean(ctxt);
            if (context.getEntryPointType() == 2) {
                Descriptor desc = (Descriptor)context.get();
                if (desc instanceof Application) {
                    result = !((Application)desc).getWebBundleDescriptors().isEmpty() || !((Application)desc).getWebServiceDescriptors().isEmpty();
                } else if (desc instanceof EjbBundleDescriptor) {
                    result = ((EjbBundleDescriptor)desc).hasWebServices();
                } else if (desc instanceof EjbAbstractDescriptor) {
                    result = ((EjbAbstractDescriptor)desc).hasWebServiceEndpointInterface();
                } else {
                    boolean bl = result = desc instanceof WebBundleDescriptor || desc instanceof WebServicesDescriptor;
                }
            }
            if (context.getEntryPointType() == 3) {
                // empty if block
            }
            if (context.getEntryPointType() == 1) {
                HttpService httpService = conf.getHttpService();
                HttpListener[] httpListeners = httpService.getHttpListener();
                for (int i = 0; i < httpListeners.length; ++i) {
                    int port = Integer.parseInt(httpListeners[i].getPort());
                    if (port != (Integer)context.get()) continue;
                    result = true;
                }
            }
            if (context.getEntryPointType() == 4) {
                result = this.analyseObjectName((ObjectName)context.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private boolean analyseObjectName(ObjectName name) {
        String type = name.getKeyProperty("type");
        if (type != null && type.equals("Loader")) {
            return true;
        }
        String j2eeType = name.getKeyProperty("j2eeType");
        if (j2eeType != null && j2eeType.equals("WebModule")) {
            return true;
        }
        if (name.getKeyProperty("WebModule") != null) {
            return true;
        }
        String nameStr = name.getKeyProperty("name");
        String ref = name.getKeyProperty("ref");
        String app = name.getKeyProperty("J2EEApplication");
        return this.belongsToThisServiceGroup(nameStr) || this.belongsToThisServiceGroup(ref) || this.belongsToThisServiceGroup(app);
    }

    private boolean belongsToThisServiceGroup(String name) {
        SystemAppLoader appLoader = OnDemandServer.getSystemAppLoader();
        if (appLoader != null) {
            for (Object n : appLoader.getWebServiceGroupSystemApps()) {
                if (!((String)n).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void startLifecycleServices(ServerContext context) {
        String[][] services = OnDemandServices.getWebServiceGroupServices();
        super.startLifecycleServices(services, context);
    }

    public void stop(EntryContext context) throws ServiceGroupException {
        super.stopLifecycleServices();
    }

    public void abort(EntryContext context) {
        super.stopLifecycleServices();
    }
}

