/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.web.FunctionDescriptor;
import com.sun.enterprise.tools.verifier.web.TagDescriptor;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;

public class TagLibDescriptor {
    public static final String TAG = "tag";
    public static final String LISTENER_CLASS = "listener-class";
    public static final String FUNCTION = "function";
    private Document doc = null;
    private String version = null;
    private String uri = null;

    public TagLibDescriptor(Document doc, String version, String uri) {
        this.doc = doc;
        this.version = version;
        this.uri = uri;
    }

    public String getSpecVersion() {
        return this.version;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPublicID() {
        DocumentType docType = this.doc.getDoctype();
        return docType == null ? null : docType.getPublicId();
    }

    public String getSystemID() {
        DocumentType docType = this.doc.getDoctype();
        return docType == null ? null : docType.getSystemId();
    }

    public String[] getListenerClasses() {
        NodeList nl = this.doc.getElementsByTagName(LISTENER_CLASS);
        String[] classes = null;
        if (nl != null) {
            int size = nl.getLength();
            classes = new String[size];
            for (int i = 0; i < size; ++i) {
                classes[i] = nl.item(i).getFirstChild().getNodeValue();
            }
        }
        return classes;
    }

    public TagDescriptor[] getTagDescriptors() {
        NodeList nl = this.doc.getElementsByTagName(TAG);
        TagDescriptor[] tagdescriptor = null;
        if (nl != null) {
            int size = nl.getLength();
            tagdescriptor = new TagDescriptor[size];
            for (int i = 0; i < size; ++i) {
                tagdescriptor[i] = new TagDescriptor(nl.item(i));
            }
        }
        return tagdescriptor;
    }

    public FunctionDescriptor[] getFunctionDescriptors() {
        NodeList nl = this.doc.getElementsByTagName(FUNCTION);
        ArrayList<FunctionDescriptor> list = new ArrayList<FunctionDescriptor>();
        if (nl != null) {
            int size = nl.getLength();
            for (int i = 0; i < size; ++i) {
                list.add(new FunctionDescriptor(nl.item(i)));
            }
        }
        return list.toArray(new FunctionDescriptor[0]);
    }
}

