/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.io.AppClientDeploymentDescriptorFile;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.dd.ParseDD;
import com.sun.enterprise.tools.verifier.wsclient.WebServiceClientCheckMgrImpl;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Set;

public class AppClientCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesAppClient.xml";
    private static final String sunONETestsListFileName = AppClientCheckMgrImpl.getSunPrefix().concat("TestNamesAppClient.xml");

    public AppClientCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(Descriptor descriptor) throws Exception {
        this.checkPersistenceUnits((RootDeploymentDescriptor)ApplicationClientDescriptor.class.cast(descriptor));
        this.checkWebServicesClient(descriptor);
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isAppClient()) {
            return;
        }
        if (this.getSchemaVersion(descriptor).compareTo("1.4") < 0) {
            AppClientDeploymentDescriptorFile ddf = new AppClientDeploymentDescriptorFile();
            File file = new File(this.getAbstractArchiveUri(descriptor), ddf.getDeploymentDescriptorPath());
            FileInputStream is = new FileInputStream(file);
            try {
                if (is != null) {
                    Result result = new ParseDD().validateAppClientDescriptor(is);
                    result.setComponentName(this.getArchiveUri(descriptor));
                    this.setModuleName(result);
                    this.frameworkContext.getResultManager().add(result);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        super.check(descriptor);
    }

    protected String getTestsListFileName() {
        return testsListFileName;
    }

    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected String getSchemaVersion(Descriptor descriptor) {
        return ((RootDeploymentDescriptor)descriptor).getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName("appclient");
    }

    protected void checkWebServicesClient(Descriptor descriptor) throws Exception {
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isWebServicesClient()) {
            return;
        }
        WebServiceClientCheckMgrImpl webServiceClientCheckMgr = new WebServiceClientCheckMgrImpl(this.frameworkContext);
        ApplicationClientDescriptor desc = (ApplicationClientDescriptor)descriptor;
        if (desc.hasWebServiceClients()) {
            Set serviceRefDescriptors = desc.getServiceReferenceDescriptors();
            Iterator it = serviceRefDescriptors.iterator();
            while (it.hasNext()) {
                webServiceClientCheckMgr.setVerifierContext(this.context);
                webServiceClientCheckMgr.check((ServiceReferenceDescriptor)it.next());
            }
        } else {
            webServiceClientCheckMgr.setVerifierContext(this.context);
        }
    }

    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((ApplicationClientDescriptor)descriptor);
    }
}

