/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class StatelessCreateNoArgs
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        String stateType;
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor && "Stateless".equals(stateType = ((EjbSessionDescriptor)descriptor).getSessionType())) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The bean's Home Interface properly defines one create Method with no args"));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String home, EjbSessionDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            Method m = null;
            for (Method methods : c.getDeclaredMethods()) {
                if (!methods.getName().equals("create")) continue;
                m = methods;
                break;
            }
            if (m != null) {
                Class<?>[] cc = m.getParameterTypes();
                if (cc.length > 0) {
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The create method has one or more parameters \nwithin bean [ {0} ].  Stateless session are only allowed \nto have create methods with no arguments.", new Object[]{home}));
                }
            } else {
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No Create method exists within bean [ {0} ]", new Object[]{home}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

