/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.util;

import com.sun.enterprise.tools.verifier.Result;
import java.io.File;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BundledOptPkgHasDependencies {
    public static void test(String explodedJarPath, Result result) {
        try {
            boolean failed = false;
            Manifest manifest = new Manifest(new FileInputStream(new File(explodedJarPath + File.separator + "META-INF/MANIFEST.MF")));
            String depClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (depClassPath != null) {
                StringTokenizer st = new StringTokenizer(depClassPath);
                while (st.hasMoreTokens()) {
                    Manifest bundledManifest;
                    String bundledCP;
                    String entry = st.nextToken();
                    String entryPath = new File(explodedJarPath).getParent() + File.separator + entry;
                    File bundledOptPkg = new File(entryPath);
                    if (bundledOptPkg.isDirectory() || (bundledCP = (bundledManifest = new JarFile(bundledOptPkg).getManifest()).getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) == null || bundledCP.length() == 0) continue;
                    failed = true;
                    result.failed(entry + " contains Class-Path in it's manifest.");
                }
            }
            if (!failed) {
                result.setStatus(0);
            }
        }
        catch (Exception e) {
            result.failed(e.toString());
        }
    }
}

