/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.logging.LogDomains;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DebugController {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final String PROPS_FILENAME = "debug.properties";
    private static final String FIELD_NAME = "debug";
    private static DebugController controller = null;
    private Properties props = new Properties();
    private String propsFileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DebugController getInstance() {
        if (controller != null) return controller;
        Class<DebugController> clazz = DebugController.class;
        synchronized (DebugController.class) {
            controller = new DebugController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return controller;
        }
    }

    public static void init() {
        DebugController ctrller = DebugController.getInstance();
        ctrller.load();
    }

    private DebugController() {
        this(PROPS_FILENAME);
    }

    private DebugController(String propsFileName) {
        this.propsFileName = propsFileName;
    }

    private void load() {
        try {
            FileInputStream fin = new FileInputStream(this.propsFileName);
            this.props.load(fin);
            Enumeration<?> e = this.props.propertyNames();
            while (e.hasMoreElements()) {
                String className = (String)e.nextElement();
                boolean value = Boolean.valueOf(this.props.getProperty(className));
                this.setInfo(className, value);
            }
            fin.close();
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "enterprise_util.dbgcntl_ioexception", e);
        }
    }

    private void setInfo(String className, boolean value) {
        try {
            Class<?> cls = Class.forName(className);
            Field dField = cls.getField(FIELD_NAME);
            dField.setBoolean(null, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

